/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration;

import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.exploration.cli.ExecuteDSECommandLineHandler;
import org.fortiss.af3.exploration.cli.TestCaseGenerationCommandLineHandler;
import org.fortiss.af3.exploration.cli.ValidateDSESolutionCommandLineInterface;
import org.fortiss.af3.exploration.service.IDSESolutionExporterService;
import org.fortiss.af3.exploration.solutionconverter.ComponentToTaskConverter;
import org.fortiss.af3.exploration.solutionconverter.InputPortToTaskInputPortConverter;
import org.fortiss.af3.exploration.solutionconverter.OutputPortToTaskOutputPortConverter;
import org.fortiss.af3.exploration.solutionconverter.RequirementConverter;
import org.fortiss.af3.exploration.solutionconverter.RouteConverter;
import org.fortiss.af3.exploration.solutionconverter.ScheduleConverter;
import org.fortiss.af3.exploration.solutionconverter.SignalToRouteConverter;
import org.fortiss.af3.exploration.solutionconverter.TaskConverter;
import org.fortiss.af3.exploration.solutionconverter.TaskToExecUnitConverter;
import org.fortiss.af3.exploration.solutionconverter.partition.PartitionChannelConverter;
import org.fortiss.af3.exploration.solutionconverter.partition.PartitionConverter;
import org.fortiss.af3.exploration.solutionconverter.partition.PartitionToExecutionUnitConverter;
import org.fortiss.af3.exploration.solutionconverter.partition.TaskToPartitionConverter;
import org.fortiss.af3.exploration.solutionconverter.platform.PlatformConnectorInstanceConverter;
import org.fortiss.af3.exploration.solutionconverter.platform.PlatformExecUnitInstantiationConverter;
import org.fortiss.af3.exploration.solutionconverter.platform.PlatformTransmissionConnectionConverter;
import org.fortiss.tooling.kernel.extension.ICommandLineSwitchHandler;
import org.fortiss.tooling.kernel.service.ICommandLineInterfaceService;
import org.osgi.framework.BundleContext;

public class AF3ExplorationActivator
extends Plugin {
    public static final String PLUGIN_ID = AF3ExplorationActivator.class.getPackage().getName();
    private static AF3ExplorationActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerDSESolutionConverters();
        ICommandLineInterfaceService cliService = ICommandLineInterfaceService.getInstance();
        cliService.registerHandler("--gen-dse-testcases", (ICommandLineSwitchHandler)new TestCaseGenerationCommandLineHandler());
        cliService.registerHandler("--exec-dse", (ICommandLineSwitchHandler)new ExecuteDSECommandLineHandler());
        cliService.registerHandler("--validate-dse", (ICommandLineSwitchHandler)new ValidateDSESolutionCommandLineInterface());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AF3ExplorationActivator getDefault() {
        return plugin;
    }

    private void registerDSESolutionConverters() {
        IDSESolutionExporterService dseSES = IDSESolutionExporterService.getInstance();
        dseSES.registerSolutionConverter(new PlatformExecUnitInstantiationConverter());
        dseSES.registerSolutionConverter(new PlatformConnectorInstanceConverter());
        dseSES.registerSolutionConverter(new PlatformTransmissionConnectionConverter());
        dseSES.registerSolutionConverter(new TaskConverter());
        dseSES.registerSolutionConverter(new ComponentToTaskConverter());
        dseSES.registerSolutionConverter(new InputPortToTaskInputPortConverter());
        dseSES.registerSolutionConverter(new OutputPortToTaskOutputPortConverter());
        dseSES.registerSolutionConverter(new RouteConverter());
        dseSES.registerSolutionConverter(new TaskToExecUnitConverter());
        dseSES.registerSolutionConverter(new SignalToRouteConverter());
        dseSES.registerSolutionConverter(new PartitionConverter());
        dseSES.registerSolutionConverter(new PartitionToExecutionUnitConverter());
        dseSES.registerSolutionConverter(new TaskToPartitionConverter());
        dseSES.registerSolutionConverter(new PartitionChannelConverter());
        dseSES.registerSolutionConverter(new ScheduleConverter());
        dseSES.registerSolutionConverter(new RequirementConverter());
    }
}

