/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.SolverSettings;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.service.DSEJobAdapter;
import org.fortiss.af3.exploration.service.IDSEBackend;
import org.fortiss.af3.exploration.service.IDSEBackendService;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationCLIUtils;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.ICommandLineSwitchHandler;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public final class ExecuteDSECommandLineHandler
implements ICommandLineSwitchHandler {
    private final IDSEBackendService dseService = IDSEBackendService.getInstance();
    private boolean explorationFinished = false;

    public boolean hasAdditionalArgument() {
        return true;
    }

    public void handleCLISwitch(String argument) {
        DSE matchingDSE = ExplorationCLIUtils.findMatchingDSEProject(argument);
        if (matchingDSE == null) {
            return;
        }
        Set<Class<? extends ISynthesisCategory>> solutionType = ExplorationCLIUtils.getExplorationTypeByArgument(argument);
        if (solutionType.isEmpty()) {
            return;
        }
        Optional z3Backend = LambdaUtils.getFirst(this.dseService.findBySynthTypeAndName(solutionType, IDSEBackend.EXPLORATION_TYPE.FEASIBILITY_CHECK, "Z3 (SMT)"));
        if (!z3Backend.isPresent()) {
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"Could not find the Z3 backend to perform the exploration.");
            return;
        }
        HashMap<Class<? extends IDSEBackend>, SolverSettings> settings = new HashMap<Class<? extends IDSEBackend>, SolverSettings>();
        settings.put(((IDSEBackend)z3Backend.get()).getClass(), ((IDSEBackend)z3Backend.get()).getSolverSettings());
        ExplorationSpecification expSpec = this.constructExplorationSpecification(matchingDSE);
        expSpec.getSynthTypes().addAll(solutionType);
        try {
            this.dseService.explore((IDSEBackend)z3Backend.get(), expSpec, ((IDSEBackend)z3Backend.get()).getSolverSettings(), new DseCLISolutionAdapter(matchingDSE, expSpec, settings));
        }
        catch (Exception e) {
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"The exploration failed due to an exception in the DSE backend.", (Throwable)e);
        }
        while (!this.explorationFinished) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"The DSE triggered by a CLI switch was interrupted.", (Throwable)e);
            }
        }
    }

    private ExplorationSpecification constructExplorationSpecification(DSE matchingDSE) {
        ExplorationSpecification expSpec = ExplorationModelElementFactory.createExplorationSpecification();
        ProcessStep dseStep = matchingDSE.getCurrentStep();
        expSpec.getTargets().addAll(ExecuteDSECommandLineHandler.getTargetsFromRuleSets(matchingDSE));
        expSpec.setSearchSpace(dseStep.getSuperSetMap());
        return expSpec;
    }

    private static Collection<IExplorationTarget<?>> getTargetsFromRuleSets(DSE dse) {
        ArrayList allExplorationTargets = new ArrayList();
        ProcessStep dseStep = dse.getCurrentStep();
        for (RuleSet ruleSet : dseStep.getRuleSets()) {
            allExplorationTargets.addAll((Collection<IExplorationTarget<?>>)ruleSet.getExplorationTargets());
        }
        return allExplorationTargets;
    }

    private class DseCLISolutionAdapter
    extends DSEJobAdapter {
        private final DSE dse;
        private final Map<Class<? extends IDSEBackend>, SolverSettings> settings;

        DseCLISolutionAdapter(DSE selectedDSE, ExplorationSpecification expSpec, Map<Class<? extends IDSEBackend>, SolverSettings> settings) {
            super(expSpec);
            this.dse = selectedDSE;
            this.settings = settings;
        }

        public void done(IJobChangeEvent event) {
            Optional<ExplorationSolution> result = this.getSolution();
            Assert.isTrue((boolean)result.isPresent(), (String)"The IDSEBackend contract defines that an ExplorationSolution must always be returned.");
            ExplorationStep expStep = this.createCLIExplorationStep(result.get());
            ITopLevelElement modelCtx = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.dse);
            UniqueIDUtils.prepareIDs((EObject)expStep, (EObject)this.dse, (int)UniqueIDUtils.getLargestID((EObject)this.dse));
            modelCtx.runAsCommand(() -> this.dse.addProcessStep(expStep));
            SolutionSelectionStep solSelStep = DSEProjectModelElementFactory.createSolutionSelectionStep("CLI Solution");
            Optional singleSol = LambdaUtils.getFirst(result.get().getSolutions());
            if (singleSol.isPresent()) {
                solSelStep.setSelectedSolution((SingleExplorationSolution)singleSol.get());
                UniqueIDUtils.prepareIDs((EObject)solSelStep, (EObject)this.dse, (int)UniqueIDUtils.getLargestID((EObject)this.dse));
            }
            modelCtx.runAsCommand(() -> this.dse.addProcessStep(solSelStep));
            try {
                modelCtx.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException | CoreException e) {
                LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"Could not store the result of the exploration. An exception occured while saving.", (Throwable)e);
            }
            ExecuteDSECommandLineHandler.this.explorationFinished = true;
        }

        private ExplorationStep createCLIExplorationStep(ExplorationSolution result) {
            ExplorationStep expStep = DSEProjectModelElementFactory.createExplorationStep("CLI Exploration", Collections.emptyList(), this.settings);
            expStep.setSolution(result);
            ProcessStep pStep = this.dse.getCurrentStep();
            expStep.getUsedRuleSets().addAll(pStep.getRuleSets());
            return expStep;
        }
    }
}

