/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.cli;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.lang.ExplorationExpressionDeploymentValidator;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.service.IDSESolutionExporterService;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.util.ExplorationCLIUtils;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.extension.ICommandLineSwitchHandler;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ValidateDSESolutionCommandLineInterface
implements ICommandLineSwitchHandler {
    private final IDSESolutionExporterService dseExportService = IDSESolutionExporterService.getInstance();

    public boolean hasAdditionalArgument() {
        return true;
    }

    public void handleCLISwitch(String argument) {
        boolean isSolutionValidated;
        SingleExplorationSolution singleSolution;
        SolutionSelectionStep solStep;
        Set<Class<? extends ISynthesisCategory>> synthTypes;
        DSE matchingDSE;
        block24: {
            matchingDSE = ExplorationCLIUtils.findMatchingDSEProject(argument);
            if (matchingDSE == null) {
                return;
            }
            ProcessStep currentStep = matchingDSE.getCurrentStep();
            if (!(currentStep instanceof SolutionSelectionStep)) {
                LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"The validator can only be executed if the current step of a DSE points to an ExplorationStep.");
                return;
            }
            synthTypes = ExplorationCLIUtils.getExplorationTypeByArgument(argument);
            if (synthTypes.isEmpty()) {
                return;
            }
            solStep = (SolutionSelectionStep)currentStep;
            singleSolution = solStep.getSelectedSolution();
            if (singleSolution == null) {
                LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)("The DSE project " + matchingDSE.getName() + " does not contain a solution that can be validated."));
                return;
            }
            isSolutionValidated = false;
            try {
                try {
                    isSolutionValidated = this.validateSingleSolution(solStep);
                }
                catch (Exception e1) {
                    LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"The validator for the solver model.");
                    if (isSolutionValidated) {
                        LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " passed the validation of the produced SuperSets."));
                    } else {
                        LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " did not pass the validation of the produced SuperSets."));
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (isSolutionValidated) {
                    LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " passed the validation of the produced SuperSets."));
                } else {
                    LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " did not pass the validation of the produced SuperSets."));
                }
                throw throwable;
            }
            if (isSolutionValidated) {
                LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " passed the validation of the produced SuperSets."));
            } else {
                LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " did not pass the validation of the produced SuperSets."));
            }
        }
        boolean isSolutionModelValidated = false;
        try {
            try {
                isSolutionModelValidated = this.validateTransformedSolution(solStep, synthTypes, singleSolution);
            }
            catch (Exception e) {
                LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"The validator for the exported solution from the DSE failed.", (Throwable)e);
                if (isSolutionModelValidated) {
                    LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " passed the validation of the produced model elements."));
                } else {
                    LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " did not pass the validation of the produced model elements."));
                }
                this.saveValidationResultsFile(matchingDSE, isSolutionValidated, isSolutionModelValidated);
            }
        }
        finally {
            if (isSolutionModelValidated) {
                LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " passed the validation of the produced model elements."));
            } else {
                LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)("The solution " + singleSolution.getName() + " did not pass the validation of the produced model elements."));
            }
            this.saveValidationResultsFile(matchingDSE, isSolutionValidated, isSolutionModelValidated);
        }
    }

    private boolean validateSingleSolution(SolutionSelectionStep solStep) throws Exception {
        SuperSet<TaskToExecutionUnitAllocationEntry> allocationSet = solStep.getSolutionSuperSetMap().get(TaskToExecutionUnitAllocationEntry.class);
        if (allocationSet != null) {
            ExplorationStep expStep = (ExplorationStep)solStep.eContainer();
            List<IExplorationTarget<?>> appliedTargets = expStep.getUsedRuleSets().stream().flatMap(rS -> rS.getExplorationTargets().stream()).collect(Collectors.toList());
            ExplorationExpressionDeploymentValidator validator = new ExplorationExpressionDeploymentValidator((Collection<TaskToExecutionUnitAllocationEntry>)allocationSet.getEntries(), (Collection<IExplorationTarget<?>>)appliedTargets);
            return validator.validate();
        }
        return false;
    }

    private boolean validateTransformedSolution(SolutionSelectionStep solStep, Set<Class<? extends ISynthesisCategory>> synthTypes, SingleExplorationSolution singleSolution) throws Exception {
        ExplorationStep expStep = (ExplorationStep)solStep.eContainer();
        List<IExplorationTarget<?>> appliedTargets = expStep.getUsedRuleSets().stream().flatMap(rS -> rS.getExplorationTargets().stream()).collect(Collectors.toList());
        Collection rootInputElements = solStep.getInputArtifacts().stream().map(i -> ((ModelSnapshot)i).getRootElement()).collect(Collectors.toList());
        DSESolutionArtifacts solAritfacts = new DSESolutionArtifacts(rootInputElements, Arrays.asList(singleSolution), appliedTargets);
        solAritfacts = this.dseExportService.transform((Collection<Class<? extends IModelElement>>)singleSolution.getAvailableSolutionModels(), solAritfacts, "CLI solution");
        if (synthTypes.size() == 1 && synthTypes.contains(IDeploymentSynthesis.class)) {
            AllocationTableCollection outArtifactContainer = solAritfacts.getElementOrThrow(AllocationTableCollection.class);
            TaskToExecutionUnitAllocationTable outArtifact = (TaskToExecutionUnitAllocationTable)outArtifactContainer.getAllocationTable(TaskToExecutionUnitAllocationTable.class);
            ExplorationExpressionDeploymentValidator validator = new ExplorationExpressionDeploymentValidator(outArtifact, solAritfacts.getAppliedTargets());
            return validator.validate();
        }
        return false;
    }

    public void saveValidationResultsFile(DSE matchingDSE, boolean isSolutionValidated, boolean isSolutionModelValidated) {
        FileProject fp = (FileProject)EcoreUtils.getFirstParentWithType((EObject)matchingDSE, FileProject.class);
        String file = FileUtils.getDefaultGeneralProjectURI().appendSegment(fp.getName() + "_validation.json").toFileString();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileWriter fw = new FileWriter(file);){
                JSONObject validationData = new JSONObject();
                validationData.put("projectName", (Object)fp.getName());
                validationData.put("solutionSetCorrect", isSolutionValidated);
                validationData.put("solutionModelCorrect", isSolutionModelValidated);
                fw.write(validationData.toString(2));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JSONException e) {
            String errorMsg = "Could not write to the file " + file + ".";
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)errorMsg, (Throwable)e);
        }
    }
}

