/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.lang;

import java.util.Collection;
import java.util.LinkedList;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ModelElementPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.Implies;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Dislocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.ILocationExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.function.Deploy;
import org.fortiss.af3.exploration.dseml.model.function.IsTask;
import org.fortiss.af3.exploration.dseml.model.function.MasterActive;
import org.fortiss.af3.exploration.dseml.model.function.Maximize;
import org.fortiss.af3.exploration.dseml.model.function.Minimize;
import org.fortiss.af3.exploration.dseml.model.function.StronglyCausal;
import org.fortiss.af3.exploration.lang.ExplorationExpressionEvaluator;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;

public class ExplorationExpressionDeploymentValidator
extends ExplorationExpressionEvaluator {
    private Collection<IExplorationTarget<?>> appliedTargets;
    private TaskToExecutionUnitAllocationTable ta2hw;
    private Collection<TaskToExecutionUnitAllocationEntry> ta2hwEntries;

    public ExplorationExpressionDeploymentValidator(TaskToExecutionUnitAllocationTable ta2hw, Collection<IExplorationTarget<?>> appliedTargets) {
        this.ta2hw = ta2hw;
        this.appliedTargets = appliedTargets;
    }

    public ExplorationExpressionDeploymentValidator(Collection<TaskToExecutionUnitAllocationEntry> ta2hwEntries, Collection<IExplorationTarget<?>> appliedTargets) {
        this.ta2hwEntries = ta2hwEntries;
        this.appliedTargets = appliedTargets;
    }

    public Boolean validate() throws Exception {
        boolean validationResult = true;
        LinkedList constraintSet = new LinkedList(LambdaUtils.filterByType(this.appliedTargets, IExplorationConstraint.class));
        while (!constraintSet.isEmpty()) {
            IExplorationTarget constraint = (IExplorationTarget)constraintSet.poll();
            if (((IExplorationConstraint)constraint).getExpression() == null) {
                throw new Exception("The constraint " + constraint.getName() + " neither contains an expression nor does it contain other constraints.Please validate the given ExplorationSpecification.");
            }
            validationResult = ((IExplorationConstraint)constraint).getExpression().accept(this, Boolean.class);
            if (validationResult) continue;
            return false;
        }
        return true;
    }

    private Boolean isAllocated(ILocationExpression alloc) throws Exception {
        Task task = ((ModelElementLiteral)alloc.getLeft()).accept(this, Task.class);
        ExecutionUnit executionUnit = ((ModelElementLiteral)alloc.getRight()).accept(this, ExecutionUnit.class);
        if (this.ta2hw != null) {
            return AllocationUtils.isAllocated((AllocationTable)this.ta2hw, TaskToExecutionUnitAllocationEntry.class, (IModelElement)task, (IModelElement)executionUnit);
        }
        if (this.ta2hwEntries != null) {
            return this.isEntryAllocated(this.ta2hwEntries, task, executionUnit);
        }
        return false;
    }

    private boolean isEntryAllocated(Collection<TaskToExecutionUnitAllocationEntry> entries, Task task, ExecutionUnit execUnit) {
        return entries.stream().filter(e -> e.getTasks().contains((Object)task) && e.getExecutionUnit() == execUnit).findAny().isPresent();
    }

    @Override
    public Boolean visit(Allocation alloc) throws Exception {
        return this.isAllocated(alloc);
    }

    @Override
    public Boolean visit(MasterActive masterActive) throws Exception {
        this.raiseUnsupportedExpressionException(masterActive);
        return null;
    }

    @Override
    public Boolean visit(Deploy deploy) throws Exception {
        return false;
    }

    @Override
    public Boolean visit(Dislocation disLoc) throws Exception {
        return this.isAllocated(disLoc) == false;
    }

    @Override
    public Boolean visit(StronglyCausal strc) throws Exception {
        this.raiseUnsupportedExpressionException(strc);
        return null;
    }

    @Override
    public Boolean visit(IsTask isTask) throws Exception {
        this.raiseUnsupportedExpressionException(isTask);
        return null;
    }

    @Override
    public Boolean visit(Implies implies) throws Exception {
        this.raiseUnsupportedExpressionException(implies);
        return null;
    }

    @Override
    public Number visit(Maximize max) throws Exception {
        this.raiseUnsupportedExpressionException(max);
        return null;
    }

    @Override
    public Number visit(Minimize min) {
        this.raiseUnsupportedExpressionException(min);
        return null;
    }

    private void raiseUnsupportedExpressionException(IExpression expr) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(expr.getClass().getSimpleName() + " expressions are not supported by the Task-to-Hardware Validator.");
    }

    @Override
    @Deprecated
    public Object visit(ModelElementPropertyLiteral mePropLit) {
        return null;
    }
}

