/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Count;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Div;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Maximum;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Minimum;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Minus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Mul;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Sum;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.Exists;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.Not;
import org.fortiss.af3.exploration.dseml.model.booleanp.Or;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Equal;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Greater;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.GreaterEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Less;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.LessEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.NotEqual;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.function.IsTask;
import org.fortiss.af3.exploration.dseml.model.function.StronglyCausal;
import org.fortiss.af3.exploration.lang.IExplorationExpressionVisitor;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.BaseMathUtils;

public abstract class ExplorationExpressionEvaluator
implements IExplorationExpressionVisitor {
    protected Map<Set<?>, IModelElement> selectedVars = new HashMap();

    @Override
    public Boolean visit(And and) throws Exception {
        Boolean lhsResult = ((IBooleanExpression)and.getLeft()).accept(this, Boolean.class);
        Boolean rhsResult = ((IBooleanExpression)and.getRight()).accept(this, Boolean.class);
        if (lhsResult.booleanValue() && rhsResult.booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Number visit(ArithmeticLiteral arithmeticLit) throws Exception {
        return arithmeticLit.getValue();
    }

    @Override
    public <T extends IModelElement, R extends Number> R visit(ArithmeticPropertyLiteral<T, R> mePropLiteral) throws Exception {
        IModelElement me = this.selectedVars.get(mePropLiteral.getSetReference());
        Number value = (Number)mePropLiteral.getValue(me);
        if (BaseMathUtils.isIntegerNumber((Number)value)) {
            return (R)BaseMathUtils.convertNumber((Number)value, BigInteger.class);
        }
        return (R)BaseMathUtils.convertNumber((Number)value, BigDecimal.class);
    }

    @Override
    public <T extends IModelElement> Boolean visit(BooleanPropertyLiteral<T> mePropLiteral) throws Exception {
        IModelElement me = this.selectedVars.get(mePropLiteral.getSetReference());
        return (Boolean)mePropLiteral.getValue(me);
    }

    @Override
    public Boolean visit(BooleanLiteral boolLit) throws Exception {
        return boolLit.isValue();
    }

    @Override
    public Number visit(Count count) throws Exception {
        return count.getSet().getEntries().size();
    }

    @Override
    public Number visit(Div div) throws Exception {
        Number lhsVal = ((IArithmeticExpression)div.getLeft()).accept(this, Number.class);
        Number rhsVal = ((IArithmeticExpression)div.getRight()).accept(this, Number.class);
        if (lhsVal instanceof BigInteger && rhsVal instanceof BigInteger) {
            return ((BigInteger)lhsVal).divide((BigInteger)rhsVal);
        }
        if (lhsVal instanceof BigDecimal && rhsVal instanceof BigDecimal) {
            return ((BigDecimal)lhsVal).divide((BigDecimal)rhsVal);
        }
        throw new IncompatibleExpressionTypes(lhsVal.getClass(), rhsVal.getClass(), div);
    }

    @Override
    public Boolean visit(Equal equal) throws Exception {
        Boolean lhsVal = equal.getLeft().accept(this, Boolean.class);
        Boolean rhsVal = equal.getRight().accept(this, Boolean.class);
        return lhsVal.equals(rhsVal);
    }

    @Override
    public Boolean visit(Exists exists) throws Exception {
        for (IModelElement me : exists.getSet().getEntries()) {
            this.selectedVars.put(exists.getSet(), me);
            if (!exists.getExpression().accept(this, Boolean.class).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(ForAll forAll) throws Exception {
        for (IModelElement modelElement : forAll.getSet().getEntries()) {
            this.selectedVars.put(forAll.getSet(), modelElement);
            if (forAll.getExpression().accept(this, Boolean.class).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Greater greater) throws Exception {
        Number rhsVal;
        Number lhsVal = ((IArithmeticExpression)greater.getLeft()).accept(this, Number.class);
        if (this.compare(lhsVal, rhsVal = ((IArithmeticExpression)greater.getRight()).accept(this, Number.class), greater) == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(GreaterEqual grEqual) throws Exception {
        Number rhsVal;
        Number lhsVal = ((IArithmeticExpression)grEqual.getLeft()).accept(this, Number.class);
        int cmpVal = this.compare(lhsVal, rhsVal = ((IArithmeticExpression)grEqual.getRight()).accept(this, Number.class), grEqual);
        if (cmpVal != 1 && cmpVal != 0) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Less less) throws Exception {
        Number rhsVal;
        Number lhsVal = ((IArithmeticExpression)less.getLeft()).accept(this, Number.class);
        if (this.compare(lhsVal, rhsVal = ((IArithmeticExpression)less.getRight()).accept(this, Number.class), less) == -1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(LessEqual leEqual) throws Exception {
        Number rhsVal;
        Number lhsVal = ((IArithmeticExpression)leEqual.getLeft()).accept(this, Number.class);
        int cmpVal = this.compare(lhsVal, rhsVal = ((IArithmeticExpression)leEqual.getRight()).accept(this, Number.class), leEqual);
        if (cmpVal != -1 && cmpVal != 0) {
            return false;
        }
        return true;
    }

    @Override
    public Number visit(Maximum max) throws Exception {
        Number maxVal = null;
        for (IModelElement me : max.getSet().getEntries()) {
            this.selectedVars.put(max.getSet(), me);
            Number curVal = max.getTerms().accept(this, Number.class);
            if (maxVal == null) {
                if (curVal instanceof BigInteger) {
                    maxVal = curVal;
                } else if (curVal instanceof BigDecimal) {
                    maxVal = curVal;
                } else {
                    throw new IncompatibleExpressionTypes(Number.class, curVal.getClass(), max);
                }
            }
            if (maxVal instanceof BigInteger && curVal instanceof BigInteger && ((BigInteger)maxVal).compareTo((BigInteger)curVal) == -1) {
                maxVal = curVal;
                continue;
            }
            if (maxVal instanceof BigDecimal && curVal instanceof BigDecimal && ((BigDecimal)maxVal).compareTo((BigDecimal)curVal) == -1) {
                maxVal = curVal;
                continue;
            }
            throw new IncompatibleExpressionTypes(maxVal.getClass(), curVal.getClass(), max);
        }
        return maxVal;
    }

    @Override
    public Number visit(Minimum min) throws Exception {
        Number minVal = null;
        for (IModelElement me : min.getSet().getEntries()) {
            this.selectedVars.put(min.getSet(), me);
            Number curVal = min.getTerms().accept(this, Number.class);
            if (minVal == null) {
                if (curVal instanceof BigInteger) {
                    minVal = curVal;
                } else if (curVal instanceof BigDecimal) {
                    minVal = curVal;
                } else {
                    throw new IncompatibleExpressionTypes(Number.class, curVal.getClass(), min);
                }
            }
            if (minVal instanceof BigInteger && curVal instanceof BigInteger && ((BigInteger)minVal).compareTo((BigInteger)curVal) == -1) {
                minVal = curVal;
                continue;
            }
            if (minVal instanceof BigDecimal && curVal instanceof BigDecimal && ((BigDecimal)minVal).compareTo((BigDecimal)curVal) == -1) {
                minVal = curVal;
                continue;
            }
            throw new IncompatibleExpressionTypes(minVal.getClass(), curVal.getClass(), min);
        }
        return minVal;
    }

    @Override
    public Number visit(Minus minus) throws Exception {
        Number lhsVal = ((IArithmeticExpression)minus.getLeft()).accept(this, Number.class);
        Number rhsVal = ((IArithmeticExpression)minus.getRight()).accept(this, Number.class);
        if (lhsVal instanceof BigInteger && rhsVal instanceof BigInteger) {
            return ((BigInteger)lhsVal).min((BigInteger)rhsVal);
        }
        if (lhsVal instanceof BigDecimal && rhsVal instanceof BigDecimal) {
            return ((BigDecimal)lhsVal).min((BigDecimal)rhsVal);
        }
        throw new IncompatibleExpressionTypes(lhsVal.getClass(), rhsVal.getClass(), minus);
    }

    public IModelElement visit(ModelElementLiteral meLiteral) throws Exception {
        return this.selectedVars.get(meLiteral.getSetReference());
    }

    @Override
    public Number visit(Mul mul) throws Exception {
        Number lhsVal = ((IArithmeticExpression)mul.getLeft()).accept(this, Number.class);
        Number rhsVal = ((IArithmeticExpression)mul.getRight()).accept(this, Number.class);
        if (lhsVal instanceof BigInteger && rhsVal instanceof BigInteger) {
            return ((BigInteger)lhsVal).multiply((BigInteger)rhsVal);
        }
        if (lhsVal instanceof BigDecimal && rhsVal instanceof BigDecimal) {
            return ((BigDecimal)lhsVal).multiply((BigDecimal)rhsVal);
        }
        if (lhsVal instanceof BigInteger && rhsVal instanceof BigDecimal) {
            return ((BigDecimal)rhsVal).multiply(BigDecimal.valueOf(((BigInteger)lhsVal).doubleValue()));
        }
        if (lhsVal instanceof BigDecimal && rhsVal instanceof BigInteger) {
            return ((BigDecimal)lhsVal).multiply(BigDecimal.valueOf(((BigInteger)rhsVal).doubleValue()));
        }
        throw new IncompatibleExpressionTypes(lhsVal.getClass(), rhsVal.getClass(), mul);
    }

    @Override
    public Boolean visit(Not not) throws Exception {
        return ((IBooleanExpression)not.getRight()).accept(this, Boolean.class) == false;
    }

    @Override
    public Boolean visit(NotEqual notEqual) throws Exception {
        Boolean rhsVal;
        Boolean lhsVal = notEqual.getLeft().accept(this, Boolean.class);
        return !lhsVal.equals(rhsVal = notEqual.getRight().accept(this, Boolean.class));
    }

    @Override
    public Boolean visit(Or or) throws Exception {
        Boolean lhsVal = ((IBooleanExpression)or.getLeft()).accept(this, Boolean.class);
        Boolean rhsVal = ((IBooleanExpression)or.getRight()).accept(this, Boolean.class);
        if (!lhsVal.booleanValue() && !rhsVal.booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Number visit(Plus plus) throws Exception {
        Number lhsVal = ((IArithmeticExpression)plus.getLeft()).accept(this, Number.class);
        Number rhsVal = ((IArithmeticExpression)plus.getRight()).accept(this, Number.class);
        if (lhsVal instanceof BigInteger && rhsVal instanceof BigInteger) {
            return ((BigInteger)lhsVal).add((BigInteger)rhsVal);
        }
        if (lhsVal instanceof BigDecimal && rhsVal instanceof BigDecimal) {
            return ((BigDecimal)lhsVal).add((BigDecimal)rhsVal);
        }
        throw new IncompatibleExpressionTypes(lhsVal.getClass(), rhsVal.getClass(), plus);
    }

    @Override
    public Number visit(Sum sum) throws Exception {
        Number result = null;
        for (IModelElement element : sum.getSet().getEntries()) {
            this.selectedVars.put(sum.getSet(), element);
            if (!sum.getExpression().accept(this, Boolean.class).booleanValue()) continue;
            result = this.add(result, sum.getTerms());
        }
        return result;
    }

    @Override
    public Object visit(StronglyCausal strc) throws Exception {
        return null;
    }

    @Override
    public Object visit(IsTask isTask) throws Exception {
        return null;
    }

    protected Number add(Number result, IArithmeticExpression expression) throws Exception {
        Number arithResult = expression.accept(this, Number.class);
        if ((result == null || result instanceof BigInteger) && arithResult instanceof BigInteger) {
            if (result == null) {
                result = BigInteger.valueOf(0L);
            }
            return ((BigInteger)result).add((BigInteger)arithResult);
        }
        if ((result == null || result instanceof BigDecimal) && arithResult instanceof BigDecimal) {
            if (result == null) {
                result = BigDecimal.valueOf(0L);
            }
            return ((BigDecimal)result).add((BigDecimal)arithResult);
        }
        throw new IncompatibleExpressionTypes(Number.class, expression.getClass(), expression);
    }

    protected int compare(Number lhsVal, Number rhsVal, IExpression cmpExpr) throws Exception {
        if (lhsVal instanceof BigInteger && rhsVal instanceof BigInteger) {
            return ((BigInteger)lhsVal).compareTo((BigInteger)rhsVal);
        }
        if (lhsVal instanceof BigInteger && rhsVal instanceof BigDecimal) {
            lhsVal = BigDecimal.valueOf(((BigInteger)lhsVal).longValueExact());
            return ((BigDecimal)lhsVal).compareTo((BigDecimal)rhsVal);
        }
        if (lhsVal instanceof BigDecimal && rhsVal instanceof BigInteger) {
            rhsVal = BigDecimal.valueOf(((BigInteger)rhsVal).longValueExact());
            return ((BigDecimal)lhsVal).compareTo((BigDecimal)rhsVal);
        }
        if (lhsVal instanceof BigDecimal && rhsVal instanceof BigDecimal) {
            return ((BigDecimal)lhsVal).compareTo((BigDecimal)rhsVal);
        }
        throw new IncompatibleExpressionTypes(lhsVal.getClass(), rhsVal.getClass(), cmpExpr);
    }

    public class IncompatibleExpressionTypes
    extends Exception {
        public IncompatibleExpressionTypes(Class<?> typeA, Class<?> typeB, IExpression expression) {
            super("Expression Evaluation: Incompatibe types (" + typeA.getSimpleName() + ", " + typeB.getSimpleName() + ") detetected while parsing the operator " + expression.getClass().getSimpleName() + ".");
        }
    }
}

