/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.model.arithmetic.impl;

import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Div;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Minus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Mul;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Sum;
import org.fortiss.af3.exploration.util.DSMLUtils;

public class ArithmeticStaticImpl {
    public static String toString(Plus plus) {
        return "(" + DSMLUtils.toStringNull(plus.getLeft()) + " + " + DSMLUtils.toStringNull(plus.getRight()) + ")";
    }

    public static String toString(Mul mul) {
        return "(" + DSMLUtils.toStringNull(mul.getLeft()) + " * " + DSMLUtils.toStringNull(mul.getRight()) + ")";
    }

    public static String toString(Minus minus) {
        return "(" + DSMLUtils.toStringNull(minus.getLeft()) + " - " + DSMLUtils.toStringNull(minus.getRight()) + ")";
    }

    public static String toString(Div div) {
        return "(" + DSMLUtils.toStringNull(div.getLeft()) + " / " + DSMLUtils.toStringNull(div.getRight()) + ")";
    }

    public static String toString(ArithmeticLiteral arith) {
        return DSMLUtils.toStringNull(arith.getValue());
    }

    public static String toString(Sum sum) {
        return "(Sum(" + DSMLUtils.firstLetterLowercase(DSMLUtils.toStringNull(sum.getSet())) + " from " + DSMLUtils.toStringNull(sum.getSet()) + " | " + DSMLUtils.toStringNull(sum.getExpression()) + " ):(" + DSMLUtils.toStringNull(sum.getTerms().toString()) + "))";
    }

    public static boolean equals(Plus plus, Object other) {
        if (!(other instanceof Plus)) {
            return false;
        }
        return ((IArithmeticExpression)plus.getLeft()).equals(((Plus)other).getLeft()) && ((IArithmeticExpression)plus.getRight()).equals(((Plus)other).getRight());
    }

    public static boolean equals(Minus minus, Object other) {
        if (!(other instanceof Minus)) {
            return false;
        }
        return ((IArithmeticExpression)minus.getLeft()).equals(((Minus)other).getLeft()) && ((IArithmeticExpression)minus.getRight()).equals(((Minus)other).getRight());
    }

    public static boolean equals(Mul mul, Object other) {
        if (!(other instanceof Mul)) {
            return false;
        }
        return ((IArithmeticExpression)mul.getLeft()).equals(((Mul)other).getLeft()) && ((IArithmeticExpression)mul.getRight()).equals(((Mul)other).getRight());
    }

    public static boolean equals(Div div, Object other) {
        if (!(other instanceof Div)) {
            return false;
        }
        return ((IArithmeticExpression)div.getLeft()).equals(((Div)other).getLeft()) && ((IArithmeticExpression)div.getRight()).equals(((Div)other).getRight());
    }

    public static boolean equals(ArithmeticLiteral lit, Object other) {
        if (!(other instanceof ArithmeticLiteral)) {
            return false;
        }
        return lit.getValue().equals(((ArithmeticLiteral)other).getValue());
    }

    public static boolean equals(Sum sum, Object other) {
        if (!(other instanceof Sum)) {
            return false;
        }
        boolean isSumEqual = sum.getSet().equals(((Sum)other).getSet());
        boolean isTermEqual = sum.getTerms().equals(((Sum)other).getTerms());
        boolean isExpressionEqual = sum.getExpression().equals(((Sum)other).getExpression());
        return isSumEqual && isTermEqual && isExpressionEqual;
    }
}

