/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.model.project.impl;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.IInputArtifact;
import org.fortiss.af3.exploration.model.project.InitialInputDefinitionStep;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.ProjectPackage;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.project.SystemConstraintSet;
import org.fortiss.af3.exploration.model.project.TargetDefinitionStep;
import org.fortiss.af3.exploration.model.project.impl.ProcessStepImpl;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ProcessStepStaticImpl {
    public static EList<IInputArtifact> getInputArtifacts(ProcessStepImpl processStepImpl) {
        EList<IInputArtifact> aggregateList = ProcessStepStaticImpl.aggregateLatestSnapshots(processStepImpl);
        return ECollections.unmodifiableEList(aggregateList);
    }

    public static ProcessStepImpl getParent(ProcessStepImpl processStepImpl) {
        EObject parent = processStepImpl.eContainer();
        if (parent instanceof ProcessStepImpl) {
            return (ProcessStepImpl)parent;
        }
        return null;
    }

    public static SuperSetMap getSuperSetMap(ProcessStepImpl processStepImpl) {
        SuperSetMap aggregateMap = ExplorationModelElementFactory.createSuperSetMap();
        return ProcessStepStaticImpl.recursiveSuperSetMapWalk(processStepImpl, aggregateMap, true);
    }

    public static <S extends IModelElement> SuperSetMap recursiveSuperSetMapWalk(ProcessStep processStep, SuperSetMap aggregateSuperSets, final boolean traverseSnaps) {
        BiConsumer<ProcessStep, SuperSetMap> mapSearch = new BiConsumer<ProcessStep, SuperSetMap>(){

            @Override
            public void accept(ProcessStep processStep, SuperSetMap collectedElements) {
                if (processStep instanceof SolutionSelectionStep) {
                    SolutionSelectionStep solStep = (SolutionSelectionStep)processStep;
                    SingleExplorationSolution selectedSolution = solStep.getSelectedSolution();
                    ExplorationUtils.appendNonPresentSolutionSets(selectedSolution, collectedElements);
                    if (solStep.getImplicitSuperSets() != null) {
                        SuperSetMap superSetMap = solStep.getImplicitSuperSets();
                        for (Class solType : superSetMap.keySet()) {
                            if (collectedElements.containsKey(solType)) continue;
                            SuperSet currSol = superSetMap.get(solType);
                            collectedElements.put(solType, currSol);
                        }
                    }
                }
                if (traverseSnaps) {
                    EReference modelSnapFeature = ProjectPackage.Literals.ARTIFACT_SNAPSHOT_COLLECTION__CONTAINED_MODEL_SNAPSHOTS;
                    for (ModelSnapshot thisSnapshot : (Collection)processStep.eGet((EStructuralFeature)modelSnapFeature)) {
                        EReference mapFeature;
                        SuperSetMap artifactMap = (SuperSetMap)thisSnapshot.eGet((EStructuralFeature)(mapFeature = ProjectPackage.Literals.MODEL_SNAPSHOT__SUPER_SET_MAP));
                        if (artifactMap == null) continue;
                        artifactMap.keySet().stream().filter(k -> !collectedElements.containsKey((Class<?>)k)).forEach(k -> {
                            SuperSet superSet = collectedElements.put(k, artifactMap.get(k));
                        });
                    }
                }
            }
        };
        ExplorationUtils.recursiveTreeWalk(processStep, mapSearch, aggregateSuperSets);
        return aggregateSuperSets;
    }

    public static <S extends IModelElement> SuperSetMap recursiveSolutionWalk(ProcessStep processStep, SuperSetMap aggregateSuperSets, boolean traverseSnaps) {
        BiConsumer<ProcessStep, SuperSetMap> mapSearch = new BiConsumer<ProcessStep, SuperSetMap>(){

            @Override
            public void accept(ProcessStep processStep, SuperSetMap collectedElements) {
                if (processStep instanceof SolutionSelectionStep) {
                    SolutionSelectionStep solStep = (SolutionSelectionStep)processStep;
                    SingleExplorationSolution selectedSolution = solStep.getSelectedSolution();
                    ExplorationUtils.appendNonPresentSolutionSets(selectedSolution, collectedElements);
                }
            }
        };
        ExplorationUtils.recursiveTreeWalk(processStep, mapSearch, aggregateSuperSets);
        return aggregateSuperSets;
    }

    public static EList<IExplorationTarget<?>> getUserDefinedTargets(ProcessStepImpl processStepImpl) {
        BiConsumer collectExpTargets = new BiConsumer<ProcessStep, EList<IExplorationTarget<?>>>(){

            @Override
            public void accept(ProcessStep processStep, EList<IExplorationTarget<?>> collectedElements) {
                if (processStep instanceof TargetDefinitionStep) {
                    TargetDefinitionStep tgtStep = (TargetDefinitionStep)processStep;
                    collectedElements.addAll(tgtStep.getDefinedTargets());
                }
            }
        };
        BasicEList collectedTargets = new BasicEList();
        ExplorationUtils.recursiveTreeWalk(processStepImpl, collectExpTargets, collectedTargets);
        return ECollections.unmodifiableEList((EList)collectedTargets);
    }

    private static EList<IInputArtifact> aggregateLatestSnapshots(ProcessStepImpl processStepImpl) {
        BasicEList collectedSnapshots = new BasicEList();
        BiConsumer<IInputArtifact, EList<ModelSnapshot>> getNonPresentSnapshots = new BiConsumer<IInputArtifact, EList<ModelSnapshot>>(){

            @Override
            public void accept(IInputArtifact thisArtifact, EList<ModelSnapshot> collectedSnapshots) {
                if (!(thisArtifact instanceof ModelSnapshot)) {
                    return;
                }
                ModelSnapshot thisSnapshot = (ModelSnapshot)thisArtifact;
                boolean snapShotPresent = false;
                for (ModelSnapshot otherSnapshot : collectedSnapshots) {
                    if (!ProcessStepStaticImpl.compareSnapshotsChecked(thisSnapshot, otherSnapshot)) continue;
                    snapShotPresent = true;
                }
                if (!snapShotPresent) {
                    collectedSnapshots.add((Object)thisSnapshot);
                }
            }
        };
        ExplorationUtils.recursiveArtifactWalk(processStepImpl, getNonPresentSnapshots, collectedSnapshots);
        return collectedSnapshots;
    }

    private static boolean compareSnapshotsChecked(ModelSnapshot thisSnapshot, ModelSnapshot otherSnapshot) {
        if (thisSnapshot.getRootElement() == null || otherSnapshot.getRootElement() == null) {
            return false;
        }
        if (thisSnapshot.getRootElement().getClass() != otherSnapshot.getRootElement().getClass()) {
            return false;
        }
        EReference setFeature = ProjectPackage.Literals.MODEL_SNAPSHOT__SUPER_SET_MAP;
        SuperSetMap thisMap = (SuperSetMap)thisSnapshot.eGet((EStructuralFeature)setFeature);
        SuperSetMap otherMap = (SuperSetMap)otherSnapshot.eGet((EStructuralFeature)setFeature);
        if (thisMap.keySet().size() != otherMap.keySet().size()) {
            return false;
        }
        return thisMap.keySet().equals(otherMap.keySet());
    }

    public static EList<RuleSet> getRuleSets(ProcessStepImpl processStepImpl) {
        BiConsumer<ProcessStep, EList<RuleSet>> collectExpTargets = new BiConsumer<ProcessStep, EList<RuleSet>>(){

            @Override
            public void accept(ProcessStep processStep, EList<RuleSet> collectedElements) {
                if (processStep instanceof TargetDefinitionStep) {
                    TargetDefinitionStep tgtDefStep = (TargetDefinitionStep)processStep;
                    collectedElements.addAll(tgtDefStep.getDefinedRuleSets());
                }
            }
        };
        BasicEList collectedRuleSets = new BasicEList();
        ExplorationUtils.recursiveTreeWalk(processStepImpl, collectExpTargets, collectedRuleSets);
        return ECollections.unmodifiableEList((EList)collectedRuleSets);
    }

    public static EList<SystemConstraintSet> getSystemConstraintSets(ProcessStepImpl processStepImpl) {
        BiConsumer<ProcessStep, EList<SystemConstraintSet>> collectExpTargets = new BiConsumer<ProcessStep, EList<SystemConstraintSet>>(){

            @Override
            public void accept(ProcessStep processStep, EList<SystemConstraintSet> collectedElements) {
                block3: {
                    block2: {
                        if (!(processStep instanceof SolutionSelectionStep)) break block2;
                        SolutionSelectionStep solStep = (SolutionSelectionStep)processStep;
                        for (SystemConstraintSet sysConstrSet : solStep.getImplicitSystemConstraintSets()) {
                            if (collectedElements.stream().anyMatch(e -> e.getSrcRootElement() == sysConstrSet.getSrcRootElement())) continue;
                            collectedElements.add((Object)sysConstrSet);
                        }
                        break block3;
                    }
                    if (!(processStep instanceof InitialInputDefinitionStep)) break block3;
                    InitialInputDefinitionStep inputStep = (InitialInputDefinitionStep)processStep;
                    Collection sysConstraints = inputStep.getModelSnapshots().stream().map(ms -> ms.getImplicitSystemConstraintSet()).filter(rs -> rs != null).collect(Collectors.toList());
                    for (SystemConstraintSet sysConstrSet : sysConstraints) {
                        if (collectedElements.stream().anyMatch(e -> e.getSrcRootElement() == sysConstrSet.getSrcRootElement())) continue;
                        collectedElements.add((Object)sysConstrSet);
                    }
                }
            }
        };
        BasicEList collectedRuleSets = new BasicEList();
        ExplorationUtils.recursiveTreeWalk(processStepImpl, collectExpTargets, collectedRuleSets);
        return ECollections.unmodifiableEList((EList)collectedRuleSets);
    }

    public static EList<ModelSnapshot> getModelSnapshots(ProcessStepImpl processStepImpl) {
        return EcoreUtils.convertList(ModelSnapshot.class, processStepImpl.getInputArtifacts());
    }
}

