/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.model.solutions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SolutionState implements Enumerator
{
    UNKNOWN(0, "UNKNOWN", "UNKNOWN"),
    UNSAT(1, "UNSAT", "UNSAT"),
    OPTIMIZED(2, "OPTIMIZED", ""),
    OPTIMAL(3, "OPTIMAL", "OPTIMAL");

    public static final int UNKNOWN_VALUE = 0;
    public static final int UNSAT_VALUE = 1;
    public static final int OPTIMIZED_VALUE = 2;
    public static final int OPTIMAL_VALUE = 3;
    private static final SolutionState[] VALUES_ARRAY;
    public static final List<SolutionState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SolutionState[]{UNKNOWN, UNSAT, OPTIMIZED, OPTIMAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SolutionState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SolutionState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SolutionState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SolutionState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SolutionState get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return UNSAT;
            }
            case 2: {
                return OPTIMIZED;
            }
            case 3: {
                return OPTIMAL;
            }
        }
        return null;
    }

    private SolutionState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

