/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.service.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.SolverSettings;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionsPackage;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.service.DSEJobAdapter;
import org.fortiss.af3.exploration.service.IDSEBackend;
import org.fortiss.af3.exploration.service.IDSEBackendService;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class DSEBackendService
implements IDSEBackendService,
IIntrospectiveKernelService {
    private ListMultimap<Class<? extends ISynthesisCategory>, IDSEBackend> synthToDseBackends = ArrayListMultimap.create();
    private ListMultimap<IDSEBackend.EXPLORATION_TYPE, IDSEBackend> expTypeToDseBackends = ArrayListMultimap.create();
    private Map<Class<? extends ISynthesisCategory>, String> synthNames = new HashMap<Class<? extends ISynthesisCategory>, String>();
    private static IDSEBackendService INSTANCE;

    public static synchronized IDSEBackendService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DSEBackendService();
        }
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    @Override
    public void initializeService() {
    }

    private DSEBackendService() {
    }

    @Override
    public void explore(IDSEBackend backend, ExplorationSpecification expSpec, SolverSettings settings, DSEJobAdapter dseJobAdapter) throws Exception {
        if (!this.synthToDseBackends.values().contains(backend)) {
            throw new Exception("The selected DSE backend is unknown. The DSE will not be executed.");
        }
        this.validateBasicInformation(expSpec.getSearchSpace());
        backend.validateExplorationSpecification(expSpec);
        this.executeExtension(backend, expSpec, settings, dseJobAdapter);
    }

    @Override
    public void registerDSEBackend(IDSEBackend dseBackend) {
        if (dseBackend != null) {
            dseBackend.getSynthesisTypes().keySet().forEach(sT -> {
                boolean bl = this.synthToDseBackends.put(sT, (Object)dseBackend);
            });
            dseBackend.getExplorationTypes().forEach(eT -> {
                boolean bl = this.expTypeToDseBackends.put((Object)eT, (Object)dseBackend);
            });
            for (Map.Entry<Class<? extends ISynthesisCategory>, String> synthEntry : dseBackend.getSynthesisTypes().entrySet()) {
                if (this.synthNames.containsKey(synthEntry.getKey()) && !this.synthNames.get(synthEntry.getKey()).equals(synthEntry.getValue())) {
                    LoggingUtils.warning((Plugin)AF3ExplorationActivator.getDefault(), (String)("Two different synthesis type names shall be registered. The existing name is " + this.synthNames.get(synthEntry.getKey()) + " but " + synthEntry.getValue() + " shall be registerd by the backend " + dseBackend.getName() + ". The new registration is ignored"));
                    continue;
                }
                if (this.synthNames.containsKey(synthEntry.getKey())) continue;
                this.synthNames.put(synthEntry.getKey(), synthEntry.getValue());
            }
        } else {
            throw new InvalidParameterException("The registerd backend may not be null.");
        }
    }

    @Override
    public Set<IDSEBackend> findBySynthTypeAndName(Collection<Class<? extends ISynthesisCategory>> synthType, IDSEBackend.EXPLORATION_TYPE expType, String name) {
        Set<IDSEBackend> matchingBackends = this.getDSEBackends(synthType, expType);
        if (Strings.isNullOrEmpty((String)name)) {
            matchingBackends.removeIf(backend -> !backend.getName().contains(name));
        }
        return matchingBackends;
    }

    private void executeExtension(final IDSEBackend backend, final ExplorationSpecification spec, final SolverSettings settings, final DSEJobAdapter dseJobAdapter) {
        Job dseJob = new Job("Running DSE..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Optional<ExplorationSolution> dseSolution = backend.executeDSE(spec, settings, monitor);
                    if (dseSolution.isPresent()) {
                        DSEBackendService.this.basicSolutionValidation(dseSolution.get());
                        dseJobAdapter.setSolution(dseSolution);
                    }
                }
                catch (Exception e) {
                    return ExplorationUtils.createExceptionStatus(e, AF3ExplorationActivator.PLUGIN_ID, "DSE:\n" + e.getMessage());
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        dseJob.addJobChangeListener((IJobChangeListener)dseJobAdapter);
        dseJob.setPriority(30);
        dseJob.setUser(true);
        dseJob.schedule();
    }

    private void validateBasicInformation(SuperSetMap superSets) throws Exception {
        for (Class key : superSets.keySet()) {
            SuperSet superSet = superSets.get(key);
            if (superSet != null) continue;
            throw new Exception("The set for the type " + key.getSimpleName() + " is declared, but empty. Cannot execute the DSE.");
        }
    }

    private void basicSolutionValidation(ExplorationSolution dseSolution) throws Exception {
        EReference solutionMapFeature = SolutionsPackage.Literals.SINGLE_EXPLORATION_SOLUTION__SOLUTION_SETS;
        for (SingleExplorationSolution singleSolution : dseSolution.getSolutions()) {
            try {
                SuperSetMap superSets = (SuperSetMap)singleSolution.eGet((EStructuralFeature)solutionMapFeature);
                this.validateBasicInformation(superSets);
            }
            catch (Exception e) {
                throw new Exception("The solution model of at least one solution is invalid (name: " + singleSolution.getName() + ".", e);
            }
        }
    }

    @Override
    public Set<Class<? extends ISynthesisCategory>> getDSESynthesises() {
        return Collections.unmodifiableSet(this.synthToDseBackends.keySet());
    }

    @Override
    public Set<IDSEBackend> getDSEBackends(Collection<Class<? extends ISynthesisCategory>> synthTypes, IDSEBackend.EXPLORATION_TYPE expType) {
        HashSet matchingBackends = new HashSet(this.synthToDseBackends.values());
        for (Class<? extends ISynthesisCategory> synthType : synthTypes) {
            List backends = this.synthToDseBackends.get(synthType);
            matchingBackends = CollectionUtils.intersectionSet((Collection)matchingBackends, (Collection[])new Collection[]{backends});
        }
        if (expType != null) {
            List backends = this.expTypeToDseBackends.get((Object)expType);
            matchingBackends = CollectionUtils.intersectionSet(matchingBackends, (Collection[])new Collection[]{backends});
        }
        return matchingBackends;
    }

    @Override
    public String getSynthesisName(Class<? extends ISynthesisCategory> synthCat) {
        return this.synthNames.get(synthCat);
    }

    public String getIntrospectionLabel() {
        return "DSE Backend Service";
    }

    public boolean showInIntrospectionNavigation() {
        return true;
    }

    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }

    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThe service is used to manage different solver backends for the Design Space Exploration (DSE) feature of AutoFOCUS3. The currently active backend can be selected in the DSE Perspective.";
    }
}

