/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.model.specification.IVolatileModelElementSpecification;
import org.fortiss.af3.exploration.service.IDSESolutionExporterService;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConversionContext;
import org.fortiss.af3.exploration.solutionconverter.IDSESolutionConverter;
import org.fortiss.af3.exploration.util.DSESolutionConversionUtils;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.base.layout.KielerAutoLayouter;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class DSESolutionExporterService
implements IDSESolutionExporterService,
IIntrospectiveKernelService {
    private List<IDSESolutionConverter<? extends IProjectRootElement, ? extends IModelElement>> converterList = new ArrayList<IDSESolutionConverter<? extends IProjectRootElement, ? extends IModelElement>>();
    private static IDSESolutionExporterService INSTANCE;

    public static synchronized IDSESolutionExporterService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DSESolutionExporterService();
        }
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    @Override
    public void initializeService() {
    }

    @Override
    public void registerSolutionConverter(IDSESolutionConverter<? extends IProjectRootElement, ? extends IModelElement> converter) {
        this.converterList.add(converter);
    }

    private List<IDSESolutionConverter<? extends IProjectRootElement, ? extends IModelElement>> getSolutionConverterList() {
        return this.converterList;
    }

    @Override
    public <O extends IProjectRootElement, I extends IModelElement> DSESolutionArtifacts transform(Collection<Class<? extends IModelElement>> inputArtifacts, SolutionSelectionStep solSelStep, String baseName) {
        Set<IProjectRootElement> inputModels = this.collectInputModels(inputArtifacts, solSelStep);
        List<SingleExplorationSolution> selSolutions = ExplorationUtils.getSelectedSolutions(solSelStep);
        DSESolutionArtifacts solutionArtifacts = new DSESolutionArtifacts(inputModels, selSolutions);
        return this.transform(inputArtifacts, solutionArtifacts, baseName);
    }

    @Override
    public <O extends IProjectRootElement, I extends IModelElement> DSESolutionArtifacts transform(Collection<Class<? extends IModelElement>> inputArtifacts, DSESolutionArtifacts solutionArtifacts, String baseName) {
        for (IDSESolutionConverter<? extends IProjectRootElement, ? extends IModelElement> iDSESolutionConverter : this.getSolutionConverterList()) {
            Class<? extends IModelElement> artifactType = iDSESolutionConverter.getSourceClass();
            if (!iDSESolutionConverter.isApplicable(inputArtifacts)) continue;
            IDSESolutionConverter<? extends IProjectRootElement, ? extends IModelElement> converterCasted = iDSESolutionConverter;
            IProjectRootElement result = converterCasted.transform(solutionArtifacts.getSuperSet(artifactType), solutionArtifacts, baseName);
            solutionArtifacts.addTransformedRootElement(result);
            if (!iDSESolutionConverter.isAutoLayout() || !(result instanceof IHierarchicElement)) continue;
            KielerAutoLayouter layouter = new KielerAutoLayouter();
            layouter.performAutoLayout((IHierarchicElement)result);
        }
        for (Map.Entry entry : solutionArtifacts.getOutputs()) {
            if (EcoreUtils.getFirstChildWithType((EObject)((EObject)entry.getValue()), IVolatileModelElementSpecification.class) == null) continue;
            DSESolutionConversionUtils.throwConversionError(this.getClass().getSimpleName(), "The transformation result " + ((IProjectRootElement)entry.getValue()).getName() + " contains " + IVolatileModelElementSpecification.class.getName() + " that must be removed during the conversion. No output is generated.");
        }
        return solutionArtifacts;
    }

    protected Set<IProjectRootElement> collectInputModels(Collection<Class<? extends IModelElement>> inputArtifacts, SolutionSelectionStep solSelStep) {
        HashMap optionalInputs = new HashMap();
        for (IDSESolutionConverter<? extends IProjectRootElement, ? extends IModelElement> converter : this.getSolutionConverterList()) {
            if (!converter.isApplicable(inputArtifacts)) continue;
            converter.getRequiredInputCopies().forEach(i -> {
                Boolean bl = optionalInputs.put(i, false);
            });
            converter.getOptionalInputCopies().forEach(i -> {
                if (optionalInputs.get(i) == null) {
                    optionalInputs.put(i, true);
                }
            });
        }
        HashSet<IProjectRootElement> inputModels = new HashSet<IProjectRootElement>();
        for (Map.Entry input : optionalInputs.entrySet()) {
            IProjectRootElement element = (IProjectRootElement)this.getRootElementFromSnapshot(solSelStep, (Class)input.getKey());
            if (element != null) {
                inputModels.add(element);
                continue;
            }
            if (((Boolean)input.getValue()).booleanValue()) continue;
            DSESolutionConversionUtils.throwConversionError(this.getClass().getSimpleName(), "An input model of type " + ((Class)input.getKey()).getSimpleName() + " is required by one of the converters, but not available. Exiting.");
        }
        return inputModels;
    }

    protected <T extends INamedCommentedElement> T getRootElementFromSnapshot(SolutionSelectionStep solSelStep, Class<T> seekType) {
        for (ModelSnapshot snap : solSelStep.getModelSnapshots()) {
            IProjectRootElement rootElement = snap.getRootElement();
            if (!seekType.isAssignableFrom(rootElement.getClass())) continue;
            return (T)rootElement;
        }
        return null;
    }

    @Override
    public <O extends IProjectRootElement, I extends IModelElement> void exportToAF3Project(DSESolutionArtifacts transformedArtifacts, DSE dse, String baseName) {
        ProcessStep currentStep = dse.getCurrentStep();
        if (!(currentStep instanceof SolutionSelectionStep)) {
            DSESolutionConversionUtils.throwConversionError(this.getClass().getSimpleName(), "Cannot launch a solution export from a non-SolutionSelectionStep.");
        }
        ITopLevelElement modelContext = IPersistencyService.getInstance().getTopLevelElementFor((EObject)dse);
        FileProject fp = (FileProject)KernelModelElementUtils.getParentElement((EObject)dse, FileProject.class, (boolean)false);
        DSESolutionConversionContext convContext = new DSESolutionConversionContext();
        for (Map.Entry<Class<? extends IProjectRootElement>, IProjectRootElement> output : transformedArtifacts.getOutputs()) {
            EList idElements = EcoreUtils.getChildrenWithType((EObject)((EObject)output.getValue()), IIdLabeled.class);
            idElements.forEach(e -> e.setId(-1));
            output.getValue().setId(-1);
            UniqueIDUtils.fixMissingIDs((EObject)((EObject)output.getValue()), (EObject)dse);
            String solutionName = output.getValue().getName() + " - " + baseName;
            output.getValue().setName(solutionName);
            modelContext.runAsCommand(() -> {
                boolean bl = IElementCompositorService.getInstance().compose((EObject)fp, (EObject)output.getValue(), (IElementCompositionContext)convContext);
            });
        }
    }

    public String getIntrospectionLabel() {
        return "DSE solution SuperSet conversion service";
    }

    public boolean showInIntrospectionNavigation() {
        return false;
    }

    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return null;
    }

    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }

    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThe service is used to ease the transformation from DSE-internal SuperSet representations to AF3 model elements.";
    }
}

