/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConverterBase;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.util.TaskModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class ComponentToTaskConverter
extends DSESolutionConverterBase<AllocationTableCollection, ComponentToTaskAllocationEntry> {
    @Override
    public Collection<Class<? extends IProjectRootElement>> getRequiredInputCopies() {
        return Arrays.asList(AllocationTableCollection.class, ComponentArchitecture.class, TaskArchitecture.class);
    }

    @Override
    public AllocationTableCollection transform(SuperSet<ComponentToTaskAllocationEntry> fromSuperSet, DSESolutionArtifacts solArtifacts, String baseName) {
        AllocationTableCollection atc = solArtifacts.getElementOrThrow(AllocationTableCollection.class);
        ComponentArchitecture caArch = solArtifacts.getElementOrThrow(ComponentArchitecture.class);
        TaskArchitecture taArch = solArtifacts.getElementOrThrow(TaskArchitecture.class);
        ComponentToTaskAllocationTable table = TaskModelElementFactory.createComponentToTaskAllocationTable((String)(baseName + " - Component \u2192 Task"));
        table.setSourceView((IProjectRootElement)caArch);
        table.setTargetView((IProjectRootElement)taArch);
        for (ComponentToTaskAllocationEntry entry : fromSuperSet.getEntries()) {
            Task task = entry.getTask();
            entry.getSourceElements().forEach(src -> {
                boolean bl = AllocationUtils.addAllocationEntry((AllocationTable)table, ComponentToTaskAllocationEntry.class, (IModelElement)src, (IModelElement)task);
            });
        }
        ComponentToTaskAllocationTable existingCa2Ta = (ComponentToTaskAllocationTable)atc.getAllocationTable(ComponentToTaskAllocationTable.class);
        if (existingCa2Ta != null) {
            EcoreUtil.delete((EObject)existingCa2Ta);
        }
        atc.getContainedElements().add((Object)table);
        return atc;
    }
}

