/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.util.DSESolutionConversionUtils;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class DSESolutionArtifacts {
    private SuperSetMap solutionMap;
    private Map<Class<? extends IProjectRootElement>, IProjectRootElement> inOutArtifacts;
    private Collection<IExplorationTarget<?>> appliedTargets;

    public DSESolutionArtifacts(Collection<IProjectRootElement> inputModels, List<SingleExplorationSolution> selSolutions, Collection<IExplorationTarget<?>> expTargets) {
        HashSet<Object> artifactsToCopy = new HashSet<Object>(inputModels.size() + 1);
        artifactsToCopy.addAll(selSolutions);
        artifactsToCopy.addAll(inputModels);
        artifactsToCopy.addAll(expTargets);
        Map copiedArtifacts = EcoreUtils.copyToRefMap(artifactsToCopy);
        List<SingleExplorationSolution> copiedSelSolutions = selSolutions.stream().map(s -> (SingleExplorationSolution)copiedArtifacts.get(s)).collect(Collectors.toList());
        SuperSetMap solutionMap = ExplorationModelElementFactory.createSuperSetMap();
        copiedSelSolutions.forEach(cSol -> ExplorationUtils.appendNonPresentSolutionSets(cSol, solutionMap));
        this.solutionMap = solutionMap;
        this.inOutArtifacts = inputModels.stream().collect(Collectors.toMap(i -> EcoreUtils.getInterfaceType((EObject)i), i -> (IProjectRootElement)copiedArtifacts.get(i)));
        this.appliedTargets = expTargets.stream().map(eT -> (IExplorationTarget)copiedArtifacts.get(eT)).collect(Collectors.toList());
    }

    public DSESolutionArtifacts(Collection<IProjectRootElement> inputModels, List<SingleExplorationSolution> selSolutions) {
        this(inputModels, selSolutions, Collections.emptyList());
    }

    public <T extends IModelElement> SuperSet<T> getSuperSet(Class<T> seekType) {
        SuperSet<T> superSet = this.solutionMap.get(seekType);
        if (superSet == null) {
            DSESolutionConversionUtils.throwConversionError(DSESolutionArtifacts.getConverterName(), "Could not find a superset of an " + seekType.getSimpleName() + ".");
        }
        return superSet;
    }

    public <T extends IModelElement> SuperSet<T> getOptionalSuperSet(Class<T> seekType) {
        return this.solutionMap.get(seekType);
    }

    public <T extends IProjectRootElement> T getElementOrThrow(Class<T> seekType) {
        IProjectRootElement modelElem = this.inOutArtifacts.get(seekType);
        if (modelElem == null) {
            DSESolutionConversionUtils.throwConversionError(DSESolutionArtifacts.getConverterName(), "Could not find an element of an input " + seekType.getSimpleName() + ".");
        }
        return (T)modelElem;
    }

    public void addTransformedRootElement(IProjectRootElement rootElement) {
        this.inOutArtifacts.put(EcoreUtils.getInterfaceType((EObject)rootElement), rootElement);
    }

    public Collection<Map.Entry<Class<? extends IProjectRootElement>, IProjectRootElement>> getOutputs() {
        return this.inOutArtifacts.entrySet();
    }

    public Collection<IExplorationTarget<?>> getAppliedTargets() {
        return this.appliedTargets;
    }

    private static String getConverterName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String converterName = stackTraceElements[3].getClassName();
        return converterName;
    }
}

