/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConverterBase;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationTable;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationTable;
import org.fortiss.af3.partition.util.PartitionArchitectureUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.IPlatformCommunicationResource;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Segment;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.model.SchedulableEntity;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.af3.schedule.utils.AF3ScheduleModelElementFactory;
import org.fortiss.af3.schedule.utils.ScheduleUtils;
import org.fortiss.af3.task.model.Message;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.TaskPort;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class ScheduleConverter
extends DSESolutionConverterBase<SystemSchedule, ResourceAllocation> {
    @Override
    public Collection<Class<? extends IProjectRootElement>> getRequiredInputCopies() {
        return Arrays.asList(TaskArchitecture.class, PlatformArchitecture.class, AllocationTableCollection.class);
    }

    @Override
    public Collection<Class<? extends IProjectRootElement>> getOptionalInputCopies() {
        return Arrays.asList(TimingSpecification.class);
    }

    private ExecutionUnit getAllocatedExecUnit(TaskPort port, TaskToExecutionUnitAllocationTable taskToHwTable) {
        Task parentTask = (Task)port.getOwner();
        return taskToHwTable.getExecutionUnit(parentTask);
    }

    @Override
    public SystemSchedule transform(SuperSet<ResourceAllocation> fromSuperSet, DSESolutionArtifacts solArtifacts, String baseName) {
        boolean hasTasksOnHardware;
        AllocationTableCollection allocationTableCollection = solArtifacts.getElementOrThrow(AllocationTableCollection.class);
        BasicEList allocationsToSchedule = new BasicEList(fromSuperSet.getEntries());
        boolean bl = hasTasksOnHardware = allocationTableCollection.getAllocationTable(TaskToExecutionUnitAllocationTable.class) != null;
        if (hasTasksOnHardware) {
            TaskToExecutionUnitAllocationTable taskToHwTable = (TaskToExecutionUnitAllocationTable)allocationTableCollection.getAllocationTable(TaskToExecutionUnitAllocationTable.class);
            for (ResourceAllocation resAlloc : fromSuperSet.getEntries()) {
                SchedulableEntity entity = resAlloc.getSchedulableEntity();
                IModelElement modelElement = entity.getModelElement();
                IModelElement scheduledElement = entity.getModelElement();
                if (entity instanceof Message) {
                    ExecutionUnit sender = this.getAllocatedExecUnit((TaskPort)scheduledElement, taskToHwTable);
                    EList recvPorts = ((Message)entity).getReceivers();
                    HashSet recvTasks = new HashSet();
                    recvPorts.forEach(p -> {
                        boolean bl = recvTasks.add((Task)p.getOwner());
                    });
                    HashSet recvExecUnits = new HashSet();
                    recvTasks.forEach(t -> {
                        boolean bl = recvExecUnits.add(taskToHwTable.getExecutionUnit(t));
                    });
                    if (!recvExecUnits.stream().allMatch(ex -> ex == sender)) continue;
                    allocationsToSchedule.remove(resAlloc);
                    continue;
                }
                if (modelElement instanceof Segment) {
                    Route route = ((Segment)modelElement).getRoute();
                    ExecutionUnit sender = route.getSenderExecutionUnit();
                    EList recvExecUnits = route.getReceiverExecutionUnits();
                    if (!recvExecUnits.stream().allMatch(ex -> ex == sender)) continue;
                    allocationsToSchedule.remove(resAlloc);
                    continue;
                }
                Assert.isTrue((boolean)(modelElement instanceof Task));
            }
        }
        SystemSchedule sysSched = AF3ScheduleModelElementFactory.createSystemSchedule((String)(baseName + " - SystemSchedule"));
        sysSched.setAllocationTableCollection(allocationTableCollection);
        for (ResourceAllocation allocation : allocationsToSchedule) {
            IPlatformResource resource = this.getScheduledResource(allocation, allocationTableCollection);
            SchedulableEntity entity = allocation.getSchedulableEntity();
            IModelElement element = entity.getModelElement();
            ResourceSchedule resSched = ScheduleUtils.getResourceSchedule((SystemSchedule)sysSched, (IPlatformResource)resource);
            if (resSched == null) {
                ResourceSchedule rsSolution;
                String resName = resource instanceof INamedElement ? ((INamedElement)resource).getName() : resource.toString();
                resSched = AF3ScheduleModelElementFactory.createResourceSchedule((IPlatformResource)resource, (String)(resName + " - ResourceSchedule"));
                sysSched.getContainedElements().add((Object)resSched);
                SuperSet<ResourceSchedule> freqSchedules = solArtifacts.getOptionalSuperSet(ResourceSchedule.class);
                if (freqSchedules != null && (rsSolution = ScheduleUtils.getResourceSchedule(freqSchedules.getEntries(), (IPlatformResource)resource)) != null) {
                    resSched.setFrequency(rsSolution.getFrequency());
                }
            }
            allocation.getSchedulableEntity().setModelElement(element);
            resSched.getContainedElements().add((Object)allocation);
        }
        ScheduleUtils.calculateSystemHyperPeriods((SystemSchedule)sysSched, (boolean)true);
        if (ExplorationUtils.isDebugVerboseEnabled()) {
            ScheduleUtils.csvDescription((SystemSchedule)sysSched);
        }
        return sysSched;
    }

    private IPlatformResource getScheduledResource(ResourceAllocation allocation, AllocationTableCollection collection) {
        IModelElement scheduledElement = allocation.getSchedulableEntity().getModelElement();
        if (scheduledElement instanceof Task) {
            boolean hasPartitionsOnHardware;
            boolean hasTasksOnHardware = collection.getAllocationTable(TaskToExecutionUnitAllocationTable.class) != null;
            boolean hasTasksOnPartitions = collection.getAllocationTable(TaskToPartitionAllocationTable.class) != null;
            boolean bl = hasPartitionsOnHardware = collection.getAllocationTable(PartitionToExecutionUnitAllocationTable.class) != null;
            if (hasTasksOnHardware) {
                TaskToExecutionUnitAllocationTable table = (TaskToExecutionUnitAllocationTable)collection.getAllocationTable(TaskToExecutionUnitAllocationTable.class);
                ExecutionUnit executionUnit = table.getExecutionUnit((Task)scheduledElement);
                return executionUnit;
            }
            if (hasTasksOnPartitions && hasPartitionsOnHardware) {
                TaskToPartitionAllocationTable taskTable = (TaskToPartitionAllocationTable)collection.getAllocationTable(TaskToPartitionAllocationTable.class);
                PartitionToExecutionUnitAllocationTable partitionTable = (PartitionToExecutionUnitAllocationTable)collection.getAllocationTable(PartitionToExecutionUnitAllocationTable.class);
                Collection executionUnits = PartitionArchitectureUtils.getPhysicalResource((Task)((Task)scheduledElement), (TaskToPartitionAllocationTable)taskTable, (PartitionToExecutionUnitAllocationTable)partitionTable);
                ExecutionUnit executionUnit = (ExecutionUnit)executionUnits.stream().findAny().get();
                return executionUnit;
            }
        } else {
            if (scheduledElement instanceof Segment) {
                return (IPlatformResource)((Segment)scheduledElement).getEntity();
            }
            if (scheduledElement instanceof TaskOutputPort) {
                ExecutionUnit sender = this.getAllocatedExecUnit((TaskPort)((TaskOutputPort)scheduledElement), (TaskToExecutionUnitAllocationTable)collection.getAllocationTable(TaskToExecutionUnitAllocationTable.class));
                return this.getFirstConnectedCommUnit(sender);
            }
        }
        return null;
    }

    private IPlatformCommunicationResource getFirstConnectedCommUnit(ExecutionUnit execUnit) {
        for (Transceiver tc : execUnit.getTransceiverUnits()) {
            TransmissionUnit transUnit = PlatformArchitectureUtils.findConnectedTransmissionUnit((Transceiver)tc);
            if (transUnit == null) continue;
            return transUnit;
        }
        return null;
    }
}

