/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter;

import java.util.Arrays;
import java.util.Collection;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.specification.ModelElementReference;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConverterBase;
import org.fortiss.af3.exploration.util.DSESolutionConversionUtils;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.util.TaskModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class TaskConverter
extends DSESolutionConverterBase<TaskArchitecture, Task> {
    @Override
    public Collection<Class<? extends IProjectRootElement>> getRequiredInputCopies() {
        return Arrays.asList(ComponentArchitecture.class, AllocationTableCollection.class);
    }

    @Override
    public Collection<Class<? extends IProjectRootElement>> getOptionalInputCopies() {
        return Arrays.asList(DataDictionary.class);
    }

    @Override
    public TaskArchitecture transform(SuperSet<Task> fromSuperSet, DSESolutionArtifacts solArtifacts, String baseName) {
        TaskArchitecture ta;
        SuperSet<Task> taskSS = solArtifacts.getSuperSet(Task.class);
        SuperSet<Signal> signalSS = solArtifacts.getSuperSet(Signal.class);
        String name = null;
        try {
            ta = solArtifacts.getElementOrThrow(TaskArchitecture.class);
            name = ta.getName();
        }
        catch (Exception e) {
            name = "Task Architecture";
        }
        ta = TaskModelElementFactory.createTaskArchitecture((String)name);
        ta.getContainedElements().addAll(taskSS.getEntries());
        ta.getConnections().addAll(signalSS.getEntries());
        for (Task task : taskSS.getEntries()) {
            ModelElementReference ref = null;
            do {
                if ((ref = DSESolutionConversionUtils.getAndRemoveSpec((IModelElement)task, ModelElementReference.class)) == null || !(ref.getModelElement() instanceof Task)) continue;
                Task tCopy = (Task)ref.getModelElement();
                TaskModelElementFactory.addTaskReplicaSpecification((Task)tCopy, (Task)task);
            } while (ref != null);
        }
        return ta;
    }

    @Override
    public boolean overridesSameRootElements() {
        return true;
    }

    @Override
    public boolean isAutoLayout() {
        return true;
    }
}

