/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.model.ParameterTable;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConverterBase;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.FailureScenario;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.af3.task.util.TaskModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class TaskToExecUnitConverter
extends DSESolutionConverterBase<AllocationTableCollection, TaskToExecutionUnitAllocationEntry> {
    @Override
    public Collection<Class<? extends IProjectRootElement>> getRequiredInputCopies() {
        return Arrays.asList(ComponentArchitecture.class, TaskArchitecture.class, PlatformArchitecture.class);
    }

    @Override
    public Collection<Class<? extends IProjectRootElement>> getOptionalInputCopies() {
        return Arrays.asList(DataDictionary.class);
    }

    @Override
    public AllocationTableCollection transform(SuperSet<TaskToExecutionUnitAllocationEntry> fromSuperSet, DSESolutionArtifacts solArtifacts, String baseName) {
        AllocationTableCollection atc = solArtifacts.getElementOrThrow(AllocationTableCollection.class);
        TaskToExecutionUnitAllocationTable existingT2ExUTable = (TaskToExecutionUnitAllocationTable)atc.getAllocationTable(TaskToExecutionUnitAllocationTable.class);
        if (existingT2ExUTable != null) {
            EcoreUtil.delete((EObject)existingT2ExUTable);
        }
        TaskArchitecture taArch = solArtifacts.getElementOrThrow(TaskArchitecture.class);
        PlatformArchitecture platArch = solArtifacts.getElementOrThrow(PlatformArchitecture.class);
        TaskToExecutionUnitAllocationTable ta2pa = TaskModelElementFactory.createTaskToExecutionUnitAllocationTable((String)(baseName + " - Task \u2192ExecUnit"), (TaskArchitecture)taArch, (PlatformArchitecture)platArch);
        for (TaskToExecutionUnitAllocationEntry entry : fromSuperSet.getEntries()) {
            ExecutionUnit executionUnit = entry.getExecutionUnit();
            entry.getTasks().forEach(t -> {
                boolean bl = AllocationUtils.addAllocationEntry((AllocationTable)ta2pa, TaskToExecutionUnitAllocationEntry.class, (IModelElement)t, (IModelElement)executionUnit);
            });
        }
        for (AllocationTable pt : atc.getAllocationTables(ParameterTable.class)) {
            taArch.getParameterTables().add((Object)((ParameterTable)pt));
            if (!(pt.getSourceView() instanceof TaskArchitecture)) continue;
            pt.setSourceView((IProjectRootElement)taArch);
        }
        atc.getContainedElements().add((Object)ta2pa);
        return atc;
    }

    @Override
    public boolean isApplicable(Collection<Class<? extends IModelElement>> inputArtifacts) {
        return super.isApplicable(inputArtifacts) && !inputArtifacts.contains(FailureScenario.class);
    }
}

