/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter.partition;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConverterBase;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.PartitionChannel;
import org.fortiss.af3.partition.model.PartitionInputPort;
import org.fortiss.af3.partition.model.PartitionOutputPort;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationEntry;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationTable;
import org.fortiss.af3.partition.util.PartitionModelElementFactory;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class PartitionChannelConverter
extends DSESolutionConverterBase<PartitionArchitecture, TaskToPartitionAllocationEntry> {
    @Override
    public Collection<Class<? extends IProjectRootElement>> getRequiredInputCopies() {
        return Collections.emptyList();
    }

    @Override
    public PartitionArchitecture transform(SuperSet<TaskToPartitionAllocationEntry> fromSuperSet, DSESolutionArtifacts solArtifacts, String baseName) {
        PartitionArchitecture partArch = solArtifacts.getElementOrThrow(PartitionArchitecture.class);
        SuperSet<Signal> signalSet = solArtifacts.getSuperSet(Signal.class);
        AllocationTableCollection atc = solArtifacts.getElementOrThrow(AllocationTableCollection.class);
        TaskToPartitionAllocationTable taskPartAllocTable = (TaskToPartitionAllocationTable)atc.getAllocationTable(TaskToPartitionAllocationTable.class);
        HashMultimap senderTaskToSignal = HashMultimap.create();
        for (Signal signal : signalSet.getEntries()) {
            Task senderTask = (Task)signal.getSource().getOwner();
            senderTaskToSignal.put((Object)senderTask, (Object)signal);
        }
        for (TaskToPartitionAllocationEntry alloc : taskPartAllocTable.getAllocationEntries(TaskToPartitionAllocationEntry.class)) {
            EList allocatedTasks = alloc.getSourceElements();
            Partition senderPartition = (Partition)alloc.getTargetElement();
            for (Task senderTask : allocatedTasks) {
                for (Signal signal : senderTaskToSignal.get((Object)senderTask)) {
                    TaskInputPort targetInputPort = signal.getTargetTaskPort();
                    Task targetTask = (Task)targetInputPort.getOwner();
                    Partition targetPartition = taskPartAllocTable.getPartition(targetTask);
                    if (senderPartition == targetPartition) continue;
                    TaskOutputPort senderPort = signal.getSourceTaskPort();
                    Class<?> portSemantic = senderPort.getClass();
                    PartitionOutputPort senderPartitionPort = PartitionModelElementFactory.createPartitionOutputPort((String)("Part_" + senderPort.getName()), portSemantic);
                    senderPartition.getConnectors().add((Object)senderPartitionPort);
                    PartitionInputPort targetPartitionPort = PartitionModelElementFactory.createPartitionInputPort((String)("Part_" + targetInputPort.getName()), portSemantic);
                    targetPartition.getConnectors().add((Object)targetPartitionPort);
                    PartitionChannel partitionChannel = PartitionModelElementFactory.createPartitionChannel((PartitionOutputPort)senderPartitionPort, (PartitionInputPort)targetPartitionPort, (String)(senderPartitionPort.getName() + " --> " + targetPartitionPort.getName()));
                    partArch.getConnections().add((Object)partitionChannel);
                }
            }
        }
        return partArch;
    }
}

