/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter.partition;

import java.util.Arrays;
import java.util.Collection;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConverterBase;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationEntry;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationTable;
import org.fortiss.af3.partition.util.PartitionModelElementFactory;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class PartitionToExecutionUnitConverter
extends DSESolutionConverterBase<AllocationTableCollection, PartitionToExecutionUnitAllocationEntry> {
    @Override
    public Collection<Class<? extends IProjectRootElement>> getRequiredInputCopies() {
        return Arrays.asList(AllocationTableCollection.class, PlatformArchitecture.class);
    }

    @Override
    public AllocationTableCollection transform(SuperSet<PartitionToExecutionUnitAllocationEntry> fromSuperSet, DSESolutionArtifacts solArtifacts, String baseName) {
        AllocationTableCollection atc = solArtifacts.getElementOrThrow(AllocationTableCollection.class);
        PartitionArchitecture partArch = solArtifacts.getElementOrThrow(PartitionArchitecture.class);
        PlatformArchitecture platArch = solArtifacts.getElementOrThrow(PlatformArchitecture.class);
        PartitionToExecutionUnitAllocationTable table = PartitionModelElementFactory.createPartitionToExecutionUnitAllocationTable((String)(baseName + " - Partition \u2192 ExecutionUnit"), (IProjectRootElement)partArch, (IProjectRootElement)platArch);
        for (PartitionToExecutionUnitAllocationEntry entry : fromSuperSet.getEntries()) {
            Partition partition = (Partition)entry.getSourceElement();
            entry.getTargetElements().forEach(tgt -> {
                boolean bl = AllocationUtils.addAllocationEntry((AllocationTable)table, PartitionToExecutionUnitAllocationEntry.class, (IModelElement)partition, (IModelElement)tgt);
            });
        }
        atc.getContainedElements().add((Object)table);
        return atc;
    }
}

