/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter.partition;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConverterBase;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationEntry;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationTable;
import org.fortiss.af3.partition.util.PartitionModelElementFactory;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class TaskToPartitionConverter
extends DSESolutionConverterBase<AllocationTableCollection, TaskToPartitionAllocationEntry> {
    @Override
    public Collection<Class<? extends IProjectRootElement>> getRequiredInputCopies() {
        return Arrays.asList(AllocationTableCollection.class, TaskArchitecture.class, PartitionArchitecture.class);
    }

    @Override
    public AllocationTableCollection transform(SuperSet<TaskToPartitionAllocationEntry> fromSuperSet, DSESolutionArtifacts solArtifacts, String baseName) {
        AllocationTableCollection atc = solArtifacts.getElementOrThrow(AllocationTableCollection.class);
        TaskArchitecture taArch = solArtifacts.getElementOrThrow(TaskArchitecture.class);
        PartitionArchitecture partArch = solArtifacts.getElementOrThrow(PartitionArchitecture.class);
        TaskToPartitionAllocationTable table = PartitionModelElementFactory.createTaskToPartitionAllocationTable((String)(baseName + " - Task \u2192 Partition"), (IProjectRootElement)taArch, (IProjectRootElement)partArch);
        for (TaskToPartitionAllocationEntry entry : fromSuperSet.getEntries()) {
            Partition partition = (Partition)entry.getTargetElement();
            entry.getSourceElements().forEach(src -> {
                boolean bl = AllocationUtils.addAllocationEntry((AllocationTable)table, TaskToPartitionAllocationEntry.class, (IModelElement)src, (IModelElement)partition);
            });
        }
        TaskToPartitionAllocationTable existingTa2Pa = (TaskToPartitionAllocationTable)atc.getAllocationTable(TaskToPartitionAllocationTable.class);
        if (existingTa2Pa != null) {
            EcoreUtil.delete((EObject)existingTa2Pa);
        }
        atc.getContainedElements().add((Object)table);
        return atc;
    }
}

