/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.solutionconverter.platform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.specification.ContainedByElement;
import org.fortiss.af3.exploration.model.specification.InstanceOfElement;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionConverterBase;
import org.fortiss.af3.exploration.util.DSESolutionConversionUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;

public class PlatformExecUnitInstantiationConverter
extends DSESolutionConverterBase<PlatformArchitecture, ExecutionUnit> {
    @Override
    public Collection<Class<? extends IProjectRootElement>> getRequiredInputCopies() {
        return Arrays.asList(PlatformArchitecture.class);
    }

    @Override
    public boolean overridesSameRootElements() {
        return true;
    }

    @Override
    public PlatformArchitecture transform(SuperSet<ExecutionUnit> fromSuperSet, DSESolutionArtifacts solArtifacts, String baseName) {
        IElementCompositorService ecs = IElementCompositorService.getInstance();
        PlatformArchitecture platArch = solArtifacts.getElementOrThrow(PlatformArchitecture.class);
        platArch.setName(baseName + " - " + platArch.getName());
        HashSet<ExecutionUnit> templateExecUnits = new HashSet<ExecutionUnit>();
        for (ExecutionUnit instExecUnit : fromSuperSet.getEntries()) {
            InstanceOfElement instSpec = DSESolutionConversionUtils.getAndRemoveSpec((IModelElement)instExecUnit, InstanceOfElement.class);
            ExecutionUnit templateExecUnit = (ExecutionUnit)instSpec.getTemplateElement();
            templateExecUnits.add(templateExecUnit);
            ContainedByElement containmentSpec = DSESolutionConversionUtils.getAndRemoveSpec((IModelElement)instExecUnit, ContainedByElement.class);
            IHierarchicElement currentParent = containmentSpec.getFutureContainerRef();
            currentParent.getContainedElements().add((Object)instExecUnit);
        }
        for (ExecutionUnit template : templateExecUnits) {
            Collection<IConnector> neighbors = this.getNeighborConnectors((IHierarchicElement)template);
            neighbors.stream().filter(c -> !this.hasConnections((IConnector)c)).forEach(c -> {
                boolean bl = ecs.decompose((EObject)c);
            });
            ecs.decompose((EObject)template);
        }
        return platArch;
    }

    private Collection<IConnector> getNeighborConnectors(IHierarchicElement element) {
        ArrayList<IConnector> neighborConnectors = new ArrayList<IConnector>();
        for (IConnector connector : element.getConnectors()) {
            for (IConnection connection : connector.getOutgoing()) {
                neighborConnectors.add(connection.getTarget());
            }
            for (IConnection connection : connector.getIncoming()) {
                neighborConnectors.add(connection.getSource());
            }
        }
        return neighborConnectors;
    }

    private boolean hasConnections(IConnector connector) {
        return !connector.getIncoming().isEmpty() || !connector.getOutgoing().isEmpty();
    }
}

