/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationObjective;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.testgenerator.util.AnnotationGenerationUtils;
import org.fortiss.af3.exploration.testgenerator.util.CompArchGeneratonUtil;
import org.fortiss.af3.exploration.testgenerator.util.DseUtils;
import org.fortiss.af3.exploration.testgenerator.util.GraphMetricUtils;
import org.fortiss.af3.exploration.testgenerator.util.ProjectUtils;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.af3.project.utils.TestCaseProjectUtils;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExplorationTestCaseGenerator {
    public static void generateTestCases(int compArchNum, int minComponentNum, int maxComponentNum) throws Exception {
        FileProject templateProject = TestCaseProjectUtils.loadTestProject((String)AF3ExplorationActivator.PLUGIN_ID, (String)"/res/org/fortiss/af3/exploration/testgeneration/TemplateArchitectures.af3_23");
        Collection platformArchitectures = EcoreUtils.copy((Collection)EcoreUtils.pickInstanceOf(PlatformArchitecture.class, (List)templateProject.getRootElements()));
        Set<ComponentArchitecture> genCompArchs = CompArchGeneratonUtil.generateLogicalArchitectures(compArchNum, minComponentNum, maxComponentNum);
        Collection<FileProject> fileProjects = ProjectUtils.createAF3Projects(genCompArchs, platformArchitectures, "DSE_Generated_TestCase");
        fileProjects = AnnotationGenerationUtils.expandArchitecturesByAnnotations(fileProjects);
        fileProjects = DseUtils.expandByDseProblems(fileProjects);
        LoggingUtils.info((Plugin)AF3ExplorationActivator.getDefault(), (String)"Test cases are generated in the runtime workspace.");
        fileProjects.forEach(fp -> AnnotationUtils.instantiateAnnotationsRecursive((EObject)fp));
        ProjectUtils.saveFileProjects(fileProjects);
        ExplorationTestCaseGenerator.dumpDSEMetrics(fileProjects);
    }

    private static void dumpDSEMetrics(Collection<FileProject> fileProjects) {
        Object errorMsg;
        JSONObject jsonObject = new JSONObject();
        JSONArray testCaseMetaData = new JSONArray();
        try {
            jsonObject.put("testcaseNumber", fileProjects.size());
            jsonObject.put("testcases", (Object)testCaseMetaData);
        }
        catch (JSONException e) {
            errorMsg = "Could not dump the meta data of the testcases.";
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)errorMsg, (Throwable)e);
        }
        for (FileProject fp : fileProjects) {
            try {
                JSONObject projectMetaData = new JSONObject();
                projectMetaData.put("name", (Object)fp.getName());
                DSE dse = (DSE)EcoreUtils.getFirstChildWithType((EObject)fp, DSE.class);
                ProcessStep pStep = dse.getCurrentStep();
                SuperSet<Component> cSet = pStep.getSuperSetMap().get(Component.class);
                projectMetaData.put("components", cSet.getEntries().size());
                if (ExplorationUtils.isDumpTestgenGraphmetricsEnabled()) {
                    ComponentArchitecture compArch = (ComponentArchitecture)EcoreUtils.pickFirstInstanceOf(ComponentArchitecture.class, (List)fp.getRootElements());
                    JSONObject compMetrics = new JSONObject(GraphMetricUtils.getGraphMetrics(compArch));
                    projectMetaData.put("componentMetrics", (Object)compMetrics);
                }
                int allConstraintsNumber = 0;
                int allObjectivesNumber = 0;
                JSONArray rsMetaDataArr = new JSONArray();
                for (RuleSet rS : pStep.getRuleSets()) {
                    JSONObject ruleSetMetaData = new JSONObject();
                    ruleSetMetaData.put("name", (Object)rS.getName());
                    EList<IExplorationTarget<?>> targets = rS.getExplorationTargets();
                    EList constraints = EcoreUtils.pickInstanceOf(IExplorationConstraint.class, targets);
                    EList objectives = EcoreUtils.pickInstanceOf(IExplorationObjective.class, targets);
                    if (!constraints.isEmpty()) {
                        ExplorationTestCaseGenerator.createExplorationTargetJSONArray(ruleSetMetaData, "constraints", "constraintNames", constraints);
                        allConstraintsNumber += constraints.size();
                    }
                    if (!objectives.isEmpty()) {
                        ExplorationTestCaseGenerator.createExplorationTargetJSONArray(ruleSetMetaData, "objectives", "objectiveNames", objectives);
                        allObjectivesNumber += objectives.size();
                    }
                    rsMetaDataArr.put((Object)ruleSetMetaData);
                }
                projectMetaData.put("constraints", allConstraintsNumber);
                projectMetaData.put("objectives", allObjectivesNumber);
                projectMetaData.put("ruleSets", (Object)rsMetaDataArr);
                testCaseMetaData.put((Object)projectMetaData);
            }
            catch (JSONException e22) {
                String errorMsg2 = "Could not dump the meta data of the test case " + fp.getName() + ".";
                LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)errorMsg2, (Throwable)e22);
            }
        }
        String file = FileUtils.getDefaultGeneralProjectURI().appendSegment("testcase-metadata.json").toFileString();
        try {
            errorMsg = null;
            Object e22 = null;
            try (FileWriter fw = new FileWriter(file);){
                fw.write(jsonObject.toString(2));
            }
            catch (Throwable e22) {
                if (errorMsg == null) {
                    errorMsg = e22;
                } else if (errorMsg != e22) {
                    ((Throwable)errorMsg).addSuppressed(e22);
                }
                throw errorMsg;
            }
        }
        catch (IOException | JSONException e) {
            String errorMsg3 = "Could not write to the file " + file + ".";
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)errorMsg3, (Throwable)e);
        }
    }

    private static void createExplorationTargetJSONArray(JSONObject ruleSetMetaData, String sizeName, String listName, List<? extends IExplorationTarget<?>> targets) throws JSONException {
        JSONArray cNames = new JSONArray();
        ruleSetMetaData.put(sizeName, targets.size());
        targets.forEach(c -> {
            JSONArray jSONArray2 = cNames.put((Object)c.getName());
        });
        ruleSetMetaData.put(listName, (Object)cNames);
    }
}

