/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.annotation.FlashSize;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.safety.model.SIL;
import org.fortiss.af3.safety.model.SafetyStandard;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.annotation.FlashRequirement;
import org.fortiss.af3.task.model.timing.TaskStartEvent;
import org.fortiss.af3.timing.model.PeriodicConstraint;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.model.annotation.Wcet;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class AnnotationGenerationUtils {
    private static double[] MEMORY_USAGE = new double[]{1.0};
    private static final Integer[] FLASH_AMOUNT = new Integer[]{10, 100, 1000};

    private AnnotationGenerationUtils() {
    }

    public static Collection<FileProject> expandArchitecturesByAnnotations(Collection<FileProject> fileProjects) throws Exception {
        fileProjects = AnnotationGenerationUtils.expandPlatformArchitectureAnnotations(fileProjects);
        fileProjects = AnnotationGenerationUtils.expandTaskArchitecturesByAnnotations(fileProjects);
        return fileProjects;
    }

    private static Collection<FileProject> expandPlatformArchitectureAnnotations(Collection<FileProject> fileProjects) {
        fileProjects = AnnotationGenerationUtils.expandByFlash(fileProjects);
        fileProjects = AnnotationGenerationUtils.expandBySIL(fileProjects);
        return fileProjects;
    }

    private static Collection<FileProject> expandByFlash(Collection<FileProject> fileProjects) {
        ArrayList<FileProject> expandedProjects = new ArrayList<FileProject>();
        for (FileProject origProject : fileProjects) {
            Integer[] integerArray = FLASH_AMOUNT;
            int n = FLASH_AMOUNT.length;
            int n2 = 0;
            while (n2 < n) {
                int amount = integerArray[n2];
                FileProject project = (FileProject)EcoreUtils.copy((EObject)origProject);
                PlatformArchitecture platArch = (PlatformArchitecture)EcoreUtils.pickFirstInstanceOf(PlatformArchitecture.class, (List)project.getRootElements());
                EList flashs = EcoreUtils.getChildrenWithType((EObject)platArch, FlashSize.class);
                flashs.forEach(flash -> flash.setBytes((long)amount));
                expandedProjects.add(project);
                ++n2;
            }
        }
        return expandedProjects;
    }

    private static Collection<FileProject> expandBySIL(Collection<FileProject> fileProjects) {
        Random rand = new Random(System.currentTimeMillis());
        ArrayList<FileProject> expandedProjects = new ArrayList<FileProject>();
        for (FileProject origProject : fileProjects) {
            FileProject project = (FileProject)EcoreUtils.copy((EObject)origProject);
            PlatformArchitecture platArch = (PlatformArchitecture)EcoreUtils.pickFirstInstanceOf(PlatformArchitecture.class, (List)project.getRootElements());
            SafetyIntegrityLevel platSafety = (SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)platArch, SafetyIntegrityLevel.class);
            platSafety.setSafetyStandard(SafetyStandard.IEC61508);
            for (SafetyIntegrityLevel sil : EcoreUtils.getChildrenWithType((EObject)platArch, SafetyIntegrityLevel.class)) {
                int lvlIdx = rand.nextInt(SIL.VALUES.size());
                sil.setSilValue(SIL.get((int)lvlIdx));
            }
            expandedProjects.add(project);
        }
        return expandedProjects;
    }

    private static Collection<FileProject> expandTaskArchitecturesByAnnotations(Collection<FileProject> fileProjects) throws Exception {
        ArrayList<FileProject> expandedFileProjects = new ArrayList<FileProject>();
        for (FileProject filePrj : fileProjects) {
            PlatformArchitecture platArch = (PlatformArchitecture)EcoreUtils.pickFirstInstanceOf(PlatformArchitecture.class, (List)filePrj.getRootElements());
            int numExecUnits = EcoreUtils.getChildrenWithType((EObject)platArch, ExecutionUnit.class).size();
            EList flashAnnotations = EcoreUtils.getChildrenWithType((EObject)platArch, FlashSize.class);
            long availFlash = flashAnnotations.stream().map(flash -> (Long)flash.getValue()).mapToLong(Long::longValue).sum();
            double[] dArray = MEMORY_USAGE;
            int n = MEMORY_USAGE.length;
            int n2 = 0;
            while (n2 < n) {
                double memoryUsage = dArray[n2];
                FileProject expandedFP = (FileProject)EcoreUtils.copy((EObject)filePrj);
                TaskArchitecture taskArch = (TaskArchitecture)EcoreUtils.pickFirstInstanceOf(TaskArchitecture.class, (List)expandedFP.getRootElements());
                AnnotationGenerationUtils.defineTaskMemoryRequirements(taskArch, availFlash, memoryUsage, numExecUnits);
                AnnotationGenerationUtils.defineWCETs(taskArch);
                AnnotationGenerationUtils.definePeriods(expandedFP, taskArch);
                expandedFileProjects.add(expandedFP);
                ++n2;
            }
        }
        return expandedFileProjects;
    }

    private static void defineTaskMemoryRequirements(TaskArchitecture taskArch, long availableMemory, double memoryUsageRatio, int numExecUnits) throws Exception {
        EList tasks = taskArch.getTasks();
        int childComponentNum = tasks.size();
        List<Long> memoryRequirements = AnnotationGenerationUtils.generateMemoryRequirements(availableMemory, childComponentNum, memoryUsageRatio, numExecUnits);
        int index = 0;
        while (index < childComponentNum) {
            AnnotationUtils.setAnnotationValue((IModelElement)((IModelElement)tasks.get(index)), FlashRequirement.class, (Object)memoryRequirements.get(index));
            ++index;
        }
    }

    private static void defineWCETs(TaskArchitecture taskArch) {
        Random rand = new Random(System.currentTimeMillis());
        for (Task task : taskArch.getTasks()) {
            BigDecimal wcet = new BigDecimal(rand.nextDouble());
            try {
                AnnotationUtils.setAnnotationValue((IModelElement)task, Wcet.class, (Object)wcet);
            }
            catch (Exception e) {
                LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)("Could not set the WCET of the task " + task.getName() + "."));
            }
        }
    }

    private static List<Long> generateMemoryRequirements(long availableMemory, int numberOfComponents, double memoryUsageRatio, int numExecUnits) {
        double maxMemory = (double)availableMemory * memoryUsageRatio;
        Random random = new Random();
        ArrayList<Double> randomNumbers = new ArrayList<Double>();
        int i = 0;
        while (i < numberOfComponents) {
            double randAmount = random.nextDouble() * maxMemory / (double)numberOfComponents;
            randAmount = randAmount < (double)(availableMemory / (long)numExecUnits) ? randAmount : (double)(availableMemory / (long)numExecUnits);
            randomNumbers.add(randAmount);
            ++i;
        }
        ArrayList<Long> memoryRequirements = new ArrayList<Long>();
        Iterator iterator = randomNumbers.iterator();
        while (iterator.hasNext()) {
            double randomNumber = (Double)iterator.next();
            memoryRequirements.add((long)Math.floor(randomNumber));
        }
        return memoryRequirements;
    }

    private static void definePeriods(FileProject fp, TaskArchitecture taskArch) {
        TimingSpecification timingSpec = (TimingSpecification)EcoreUtils.pickFirstInstanceOf(TimingSpecification.class, (List)fp.getRootElements());
        BigDecimal wcetSum = BigDecimal.ZERO;
        for (Task task : taskArch.getTasks()) {
            BigDecimal wcet = task.getWcet() != null ? task.getWcet() : BigDecimal.ZERO;
            wcetSum.add(wcet);
        }
        wcetSum = wcetSum.multiply(BigDecimal.valueOf(1.1));
        for (Task task : taskArch.getTasks()) {
            PeriodicConstraint pConstr = (PeriodicConstraint)timingSpec.getConstraint((IModelElement)task, PeriodicConstraint.class, TaskStartEvent.class);
            pConstr.setPeriod(wcetSum);
        }
    }
}

