/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.exploration.testgenerator.ArchitectureGraph;
import org.fortiss.af3.exploration.testgenerator.util.GraphGenerationUtilities;
import org.fortiss.af3.exploration.testgenerator.util.GraphUtils;

public class CompArchGeneratonUtil {
    private CompArchGeneratonUtil() {
    }

    public static Set<ComponentArchitecture> generateLogicalArchitectures(int numberOfArchitectures, int minNumberOfComponents, int maxNumberOfComponents) throws IOException {
        Function<Integer, Component> createComponent = index -> ComponentModelElementFactory.createComponent((String)("Component_" + String.valueOf(index)), (String)"", (boolean)false);
        Set<ArchitectureGraph<Component>> templates = CompArchGeneratonUtil.generateNetworkTemplates(minNumberOfComponents, maxNumberOfComponents, numberOfArchitectures, createComponent);
        HashSet<ComponentArchitecture> logicalArchitectures = new HashSet<ComponentArchitecture>();
        for (ArchitectureGraph<Component> template : templates) {
            logicalArchitectures.add(GraphUtils.getComponentArchitecture(template, "ComponentArchitecture_" + template.vertexSet().size() + "_" + template.edgeSet().size()));
        }
        return logicalArchitectures;
    }

    private static <V> Set<ArchitectureGraph<V>> generateNetworkTemplates(int minNumberOfVertices, int maxNumberOfVertices, int numberOfGraphs, Function<Integer, V> createVertex) {
        HashSet<ArchitectureGraph<V>> templates = new HashSet<ArchitectureGraph<V>>();
        double remainder = 0.0;
        double graphsPerNewVertice = (double)(minNumberOfVertices * numberOfGraphs) / (Math.exp(maxNumberOfVertices) - Math.exp(minNumberOfVertices));
        int numberOfVertices = minNumberOfVertices;
        while (numberOfVertices <= maxNumberOfVertices) {
            int maxNumberOfEdges = (int)Math.pow(numberOfVertices, 2.0) - numberOfVertices;
            int minNumberOfEdges = (int)Math.floor((double)numberOfVertices * 2.0);
            graphsPerNewVertice = Math.exp(numberOfVertices) * (double)numberOfGraphs / (Math.exp(maxNumberOfVertices) - Math.exp(minNumberOfVertices)) - graphsPerNewVertice;
            remainder += graphsPerNewVertice % 1.0;
            int newGraphs = (int)Math.floor(graphsPerNewVertice);
            if (remainder >= 1.0) {
                newGraphs += (int)Math.floor(remainder);
                remainder %= 1.0;
            }
            if (newGraphs != 0) {
                int newEdges = (int)Math.max(1.0, Math.ceil((maxNumberOfEdges - minNumberOfEdges) / newGraphs));
                int numberOfEdges = minNumberOfEdges;
                while (numberOfEdges < maxNumberOfEdges) {
                    templates.add(GraphGenerationUtilities.generateRandomGraph(numberOfEdges, numberOfVertices, createVertex));
                    numberOfEdges += newEdges;
                }
            }
            ++numberOfVertices;
        }
        return templates;
    }
}

