/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.ExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.InitialInputDefinitionStep;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.project.TargetDefinitionStep;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ModelSnapshotExtractUtils;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.annotation.FlashSize;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.annotation.FlashRequirement;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class DseUtils {
    private static final double[] FLASH_MAX_UTIL = new double[]{0.5, 1.0};
    private static final int[] ALLOC_PERCENTAGES = new int[]{25, 75};

    private DseUtils() {
    }

    public static Collection<FileProject> expandByDseProblems(Collection<FileProject> fileProjects) {
        fileProjects.forEach(fp -> DseUtils.createAddDse(fp));
        fileProjects = DseUtils.addFlashConstraints(fileProjects);
        fileProjects = DseUtils.expandByAllocationConstraints(fileProjects);
        return fileProjects;
    }

    private static void createAddDse(FileProject af3Project) {
        DSE dse = DSEProjectModelElementFactory.createDSE("Generated_DSE", af3Project);
        InitialInputDefinitionStep inputDefStep = dse.getInitialStep();
        ArrayList<IProjectRootElement> rootElements = new ArrayList<IProjectRootElement>();
        rootElements.add((IProjectRootElement)EcoreUtils.pickFirstInstanceOf(ComponentArchitecture.class, (List)af3Project.getRootElements()));
        rootElements.add((IProjectRootElement)EcoreUtils.pickFirstInstanceOf(PlatformArchitecture.class, (List)af3Project.getRootElements()));
        rootElements.add((IProjectRootElement)EcoreUtils.pickFirstInstanceOf(TaskArchitecture.class, (List)af3Project.getRootElements()));
        rootElements.add((IProjectRootElement)EcoreUtils.pickFirstInstanceOf(AllocationTableCollection.class, (List)af3Project.getRootElements()));
        rootElements.add((IProjectRootElement)EcoreUtils.pickFirstInstanceOf(TimingSpecification.class, (List)af3Project.getRootElements()));
        Collection copiedRootElements = EcoreUtils.copy(rootElements);
        ModelSnapshot caSnap = ModelSnapshotExtractUtils.createComponentArchitectureSnapshot((ComponentArchitecture)LambdaUtils.firstOfType((Collection)copiedRootElements, ComponentArchitecture.class).get());
        ModelSnapshot paSnap = ModelSnapshotExtractUtils.createPlatformArchitectureSnapshot((PlatformArchitecture)LambdaUtils.firstOfType((Collection)copiedRootElements, PlatformArchitecture.class).get());
        ModelSnapshot taSnap = ModelSnapshotExtractUtils.createTaskArchitectureSnapshot((TaskArchitecture)LambdaUtils.firstOfType((Collection)copiedRootElements, TaskArchitecture.class).get());
        ModelSnapshot allocSnap = ModelSnapshotExtractUtils.createAllocationTableCollectionSnapshot((AllocationTableCollection)LambdaUtils.firstOfType((Collection)copiedRootElements, AllocationTableCollection.class).get(), Arrays.asList(ComponentToTaskAllocationEntry.class, TaskToExecutionUnitAllocationEntry.class), Arrays.asList(caSnap, paSnap, taSnap));
        ModelSnapshot timeSnap = ModelSnapshotExtractUtils.createTimingSpecificationSnapshot(Optional.empty(), taSnap.getSuperSet(Task.class), paSnap.getSuperSet(Route.class), Optional.empty(), (TimingSpecification)LambdaUtils.firstOfType((Collection)copiedRootElements, TimingSpecification.class).get());
        inputDefStep.addSnapshot(caSnap);
        inputDefStep.addSnapshot(paSnap);
        inputDefStep.addSnapshot(taSnap);
        inputDefStep.addSnapshot(allocSnap);
        inputDefStep.addSnapshot(timeSnap);
        dse.addProcessStep(DSEProjectModelElementFactory.createTargetDefinitionStep("Generated Targets"));
        af3Project.getRootElements().add((Object)dse);
    }

    private static TargetDefinitionStep getTargetDefinitionStep(DSE dse) {
        ProcessStep pStep = dse.getCurrentStep();
        Assert.isTrue((boolean)(pStep instanceof TargetDefinitionStep), (String)("The current process step must be a " + TargetDefinitionStep.class.getSimpleName() + " at this point."));
        return (TargetDefinitionStep)pStep;
    }

    private static Collection<FileProject> addFlashConstraints(Collection<FileProject> fileProjects) {
        ArrayList<FileProject> expandedProjects = new ArrayList<FileProject>();
        for (FileProject fp : fileProjects) {
            double[] dArray = FLASH_MAX_UTIL;
            int n = FLASH_MAX_UTIL.length;
            int n2 = 0;
            while (n2 < n) {
                double maxFlashUtil = dArray[n2];
                FileProject expandedFileProject = (FileProject)EcoreUtils.copy((EObject)fp);
                expandedProjects.add(expandedFileProject);
                DSE dse = (DSE)EcoreUtils.pickFirstInstanceOf(DSE.class, (List)expandedFileProject.getRootElements());
                TargetDefinitionStep tgtDefStep = DseUtils.getTargetDefinitionStep(dse);
                SuperSet<ExecutionUnit> execUnits = dse.getCurrentStep().getSuperSetMap().get(ExecutionUnit.class);
                IBooleanExpression expression = DSMLModelElementFactory.createBooleanLiteral(true);
                for (ExecutionUnit executionUnit : execUnits.getEntries()) {
                    expression = DSMLModelElementFactory.createAnd(expression, PatternFactoryUtils.createUtilizationPatternExpression(dse, maxFlashUtil, executionUnit, FlashRequirement.class, FlashSize.class));
                }
                ExplorationConstraint<Boolean> constr = ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, ExplorationModelElementFactory.createResourceDimension(), Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), expression, "Max Flash Util " + maxFlashUtil * 100.0 + " of all ExecutionUnits.", false);
                RuleSet flashRuleSet = DSEProjectModelElementFactory.createRuleSet("Flash constraints", "Generated", "");
                flashRuleSet.getExplorationTargets().add(constr);
                tgtDefStep.getDefinedTargets().add(constr);
                tgtDefStep.getDefinedRuleSets().add((Object)flashRuleSet);
                ++n2;
            }
        }
        return expandedProjects;
    }

    private static Collection<FileProject> expandByAllocationConstraints(Collection<FileProject> fileProjects) {
        ArrayList<FileProject> expandedProjects = new ArrayList<FileProject>();
        for (FileProject fp : fileProjects) {
            int[] nArray = ALLOC_PERCENTAGES;
            int n = ALLOC_PERCENTAGES.length;
            int n2 = 0;
            while (n2 < n) {
                int preAllocPercent = nArray[n2];
                FileProject expandedFileProject = (FileProject)EcoreUtils.copy((EObject)fp);
                expandedProjects.add(expandedFileProject);
                DSE dse = (DSE)EcoreUtils.pickFirstInstanceOf(DSE.class, (List)expandedFileProject.getRootElements());
                TargetDefinitionStep tgtDefStep = DseUtils.getTargetDefinitionStep(dse);
                Collection<IExplorationConstraint<?>> constraints = DseUtils.genAllocConstraints(dse, tgtDefStep.getSuperSetMap().get(Task.class), tgtDefStep.getSuperSetMap().get(ExecutionUnit.class), preAllocPercent);
                if (!constraints.isEmpty()) {
                    RuleSet allocRuleSet = DSEProjectModelElementFactory.createRuleSet("Alloc constraints", "Generated", "");
                    allocRuleSet.getExplorationTargets().addAll(constraints);
                    tgtDefStep.getDefinedTargets().addAll(constraints);
                    tgtDefStep.getDefinedRuleSets().add((Object)allocRuleSet);
                }
                ++n2;
            }
        }
        return expandedProjects;
    }

    private static Collection<IExplorationConstraint<?>> genAllocConstraints(DSE dse, SuperSet<Task> taskSet, SuperSet<ExecutionUnit> execUnits, int allocPercent) {
        Random rand = new Random(System.currentTimeMillis());
        ArrayList allocConstraints = new ArrayList();
        HashMap<ExecutionUnit, Long> freeFlash = new HashMap<ExecutionUnit, Long>();
        for (ExecutionUnit executionUnit : execUnits.getEntries()) {
            long flashSize = (Long)AnnotationUtils.getAnnotationValue((IModelElement)executionUnit, FlashSize.class, Long.class);
            freeFlash.put(executionUnit, flashSize);
        }
        LinkedList tasks = new LinkedList(taskSet.getEntries());
        Collections.shuffle(tasks);
        int numTasksToAllocate = (int)Math.floor(allocPercent * tasks.size());
        while (allocConstraints.size() < numTasksToAllocate && !tasks.isEmpty()) {
            Task task = (Task)tasks.poll();
            long requiredFlash = (Long)AnnotationUtils.getAnnotationValue((IModelElement)task, FlashRequirement.class, Long.class);
            List tgtExecUnits = freeFlash.entrySet().stream().filter(e -> (Long)e.getValue() >= requiredFlash).map(e -> (ExecutionUnit)e.getKey()).collect(Collectors.toList());
            if (tgtExecUnits.isEmpty()) continue;
            Collections.shuffle(tgtExecUnits);
            ExecutionUnit selExU = (ExecutionUnit)tgtExecUnits.get(rand.nextInt(tgtExecUnits.size()));
            IBooleanExpression expr = PatternFactoryUtils.createAllocationPatternExpression(dse, true, Arrays.asList(task), Arrays.asList(selExU));
            ExplorationConstraint<Boolean> constr = ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, ExplorationModelElementFactory.createReliabilityDimension(), Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), expr, task.getName() + "-->" + selExU.getName(), false);
            allocConstraints.add(constr);
        }
        return allocConstraints;
    }
}

