/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.fortiss.af3.component.model.ComponentArchitecture;

public class FileWriterUtil {
    private FileWriterUtil() {
    }

    public static void write(String fileName, String content) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(FileWriterUtil.createNewFile(FileWriterUtil.generateFilePath(fileName))));
        writer.write(content);
        writer.flush();
        writer.close();
    }

    private static String generateFilePath(String fileName) {
        return String.valueOf(Platform.getLocation()) + "/" + fileName;
    }

    private static File createNewFile(String filePath) throws IOException {
        File file = new File(filePath);
        file.createNewFile();
        return file;
    }

    public static void write(String fileName, Map<ComponentArchitecture, Map<String, Double>> graphMetrics) throws IOException {
        Object csvString = "";
        Character separator = Character.valueOf(',');
        for (ComponentArchitecture componentArchitecture : graphMetrics.keySet()) {
            for (String metric : graphMetrics.get(componentArchitecture).keySet()) {
                csvString = (String)csvString + componentArchitecture.getTopComponent().getName().toLowerCase() + String.valueOf(separator);
                csvString = (String)csvString + metric + String.valueOf(separator);
                csvString = (String)csvString + String.valueOf(graphMetrics.get(componentArchitecture).get(metric));
                csvString = (String)csvString + "\n";
            }
        }
        FileWriterUtil.write("graph-metrics.csv", (String)csvString);
    }
}

