/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.Assert;
import org.fortiss.af3.exploration.testgenerator.ArchitectureGraph;
import org.jgrapht.Graphs;

public class GraphGenerationUtilities {
    private static final int CONNECTION_LIKELINESS_BASE = 2;

    private GraphGenerationUtilities() {
    }

    public static <V> ArchitectureGraph<V> generateRandomGraph(int numberOfEdges, int vertexNum, Function<Integer, V> createVertices) {
        ArchitectureGraph graph = new ArchitectureGraph();
        List vertices = IntStream.range(0, vertexNum).mapToObj(i -> createVertices.apply(i)).collect(Collectors.toList());
        Graphs.addAllVertices(graph, vertices);
        HashBasedTable connectionLikeliness = HashBasedTable.create();
        graph.vertexSet().forEach(arg_0 -> GraphGenerationUtilities.lambda$1(graph, (Table)connectionLikeliness, arg_0));
        long remainingRandomEdges = (long)numberOfEdges - GraphGenerationUtilities.getUnconnectedVertexNum(graph);
        int edgeNumber = 0;
        while ((long)edgeNumber < remainingRandomEdges) {
            Pair<V, V> newEdge = GraphGenerationUtilities.selectWithProbability(connectionLikeliness);
            graph.addEdge(newEdge.getKey(), newEdge.getValue());
            connectionLikeliness.put(newEdge.getKey(), newEdge.getValue(), (Object)0);
            connectionLikeliness.row(newEdge.getKey()).forEach((c, v) -> {
                Integer n = v = Integer.valueOf((int)Math.pow(v.intValue(), 4.0));
            });
            connectionLikeliness.row(newEdge.getValue()).forEach((c, v) -> {
                Integer n = v = Integer.valueOf((int)Math.pow(v.intValue(), 4.0));
            });
            connectionLikeliness.column(newEdge.getKey()).forEach((c, v) -> {
                Integer n = v = Integer.valueOf((int)Math.pow(v.intValue(), 4.0));
            });
            connectionLikeliness.column(newEdge.getValue()).forEach((c, v) -> {
                Integer n = v = Integer.valueOf((int)Math.pow(v.intValue(), 4.0));
            });
            connectionLikeliness.values().forEach(v -> {
                Integer n = v = Integer.valueOf((int)Math.max(2.0, Math.sqrt(v.intValue())));
            });
            remainingRandomEdges = (long)numberOfEdges - GraphGenerationUtilities.getUnconnectedVertexNum(graph);
            ++edgeNumber;
        }
        List unconnectedVertices = graph.vertexSet().stream().filter(v -> graph.inDegreeOf(v) == 0 && graph.outDegreeOf(v) == 0).collect(Collectors.toList());
        ArrayList connectedVertices = new ArrayList();
        connectedVertices.removeAll(unconnectedVertices);
        Random rnd = new Random();
        for (Object unconnectedV : unconnectedVertices) {
            Object vertexToConnect = connectedVertices.size() > 0 ? connectedVertices.get(rnd.nextInt(connectedVertices.size())) : unconnectedVertices.get(unconnectedVertices.size() - 1);
            boolean direction = rnd.nextBoolean();
            if (direction) {
                graph.addEdge(unconnectedV, vertexToConnect);
            } else {
                graph.addEdge(vertexToConnect, unconnectedV);
            }
            connectedVertices.add(unconnectedV);
        }
        return graph;
    }

    private static <V> long getUnconnectedVertexNum(ArchitectureGraph<V> graph) {
        return graph.vertexSet().stream().filter(v -> graph.inDegreeOf(v) == 0 && graph.outDegreeOf(v) == 0).count();
    }

    private static <V> Pair<V, V> selectWithProbability(Table<V, V, Integer> connectionLikeliness) {
        Long sumOfProbabilities = connectionLikeliness.values().stream().mapToLong(Integer::intValue).sum();
        double random = new Random().nextDouble() * (double)sumOfProbabilities.longValue();
        long cumulativeProbability = 0L;
        ArrayList connectionList = new ArrayList(connectionLikeliness.cellSet());
        Collections.shuffle(connectionList);
        for (Table.Cell cell : connectionList) {
            if (!(random <= (double)(cumulativeProbability += (long)((Integer)cell.getValue()).intValue()))) continue;
            return Pair.of((Object)cell.getRowKey(), (Object)cell.getColumnKey());
        }
        Assert.isTrue((boolean)false, (String)"No vertex pair was selected for the architecture graph generation");
        return null;
    }

    private static /* synthetic */ void lambda$1(ArchitectureGraph architectureGraph, Table table, Object fromV) {
        architectureGraph.vertexSet().stream().filter(toV -> fromV != toV).forEach(toV -> {
            Object object2 = table.put(fromV, toV, (Object)2);
        });
    }
}

