/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.conqat.lib.commons.math.MathUtils;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.testgenerator.ArchitectureGraph;
import org.fortiss.af3.exploration.testgenerator.util.GraphUtils;
import org.jgrapht.Graphs;
import org.jgrapht.alg.cycle.SzwarcfiterLauerSimpleCycles;
import org.jgrapht.alg.scoring.BetweennessCentrality;
import org.jgrapht.alg.scoring.ClusteringCoefficient;
import org.jgrapht.alg.shortestpath.GraphMeasurer;

public class GraphMetricUtils {
    public static Map<String, Double> getGraphMetrics(ComponentArchitecture componentArchitecture) {
        HashMap<String, Double> graphMetrics = new HashMap<String, Double>();
        ArchitectureGraph<Component> graph = GraphUtils.getGraph(componentArchitecture);
        GraphMeasurer measurer = new GraphMeasurer(graph);
        ClusteringCoefficient clusterCoeff = new ClusteringCoefficient(graph);
        graphMetrics.put("average_degree", GraphMetricUtils.getAverageDegree(graph));
        graphMetrics.put("clustering_coefficient", clusterCoeff.getAverageClusteringCoefficient());
        graphMetrics.put("central_point_dominance", GraphMetricUtils.getCentralPointDominance(graph));
        graphMetrics.put("diameter", measurer.getDiameter());
        graphMetrics.put("radius", measurer.getRadius());
        graphMetrics.put("nr_edges", Double.valueOf(graph.edgeSet().size()));
        graphMetrics.put("nr_vertices", Double.valueOf(graph.vertexSet().size()));
        graphMetrics.put("cyclic_coefficient", GraphMetricUtils.getCyclicCoefficient(graph));
        return graphMetrics;
    }

    private static double getCentralPointDominance(ArchitectureGraph<?> graph) {
        Collection betweeness = new BetweennessCentrality(graph, true).getScores().values();
        Double maxBetweeness = MathUtils.max(betweeness);
        return betweeness.stream().mapToDouble(betw -> maxBetweeness - betw).sum();
    }

    private static double getAverageDegree(ArchitectureGraph<?> graph) {
        return (double)graph.edgeSet().size() / (double)graph.vertexSet().size();
    }

    public static <V> double getCyclicCoefficient(ArchitectureGraph<V> graph) {
        double scalingFactor = 1.0 / (double)graph.vertexSet().size();
        double verticeCyclicCoefficientSum = graph.vertexSet().stream().mapToDouble(v -> GraphMetricUtils.getVertexCyclicCoefficient(graph, v)).sum();
        return scalingFactor * verticeCyclicCoefficientSum;
    }

    private static <V> double getVertexCyclicCoefficient(ArchitectureGraph<V> graph, V srcVertex) {
        SzwarcfiterLauerSimpleCycles cycleAnalyzer = new SzwarcfiterLauerSimpleCycles(graph);
        List cycles = cycleAnalyzer.findSimpleCycles();
        List cyclesWithSrcVertex = cycles.stream().filter(cList -> cList.contains(srcVertex)).collect(Collectors.toList());
        double sumOfInverseSmallestCycleSizes = 0.0;
        List neighbors = Graphs.neighborListOf(graph, srcVertex);
        for (Object neighbor_1 : neighbors) {
            for (Object neighbor_2 : neighbors) {
                OptionalInt minSizeCycle;
                List cyclesThreeVertices;
                if (neighbor_1 == neighbor_2 || (cyclesThreeVertices = cyclesWithSrcVertex.stream().filter(vList -> vList.contains(neighbor_1) && vList.contains(neighbor_2)).collect(Collectors.toList())).isEmpty() || (minSizeCycle = cyclesThreeVertices.stream().mapToInt(vList -> vList.size()).min()).isEmpty()) continue;
                sumOfInverseSmallestCycleSizes += (double)(1 / minSizeCycle.getAsInt());
            }
        }
        double scalingFactor = 1 / (neighbors.size() * (neighbors.size() - 1));
        return scalingFactor * sumOfInverseSmallestCycleSizes;
    }
}

