/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.component.constraint.WeakCausalityCycleConstraintChecker;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.exploration.testgenerator.ArchitectureGraph;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.jgrapht.alg.connectivity.GabowStrongConnectivityInspector;
import org.jgrapht.graph.DefaultWeightedEdge;

public class GraphUtils {
    private GraphUtils() {
    }

    private static Table<Component, Component, Integer> getAdjacencyMatrix(ComponentArchitecture componentArchitecture) {
        HashBasedTable adjacencyMatrix = HashBasedTable.create();
        Component topComponent = componentArchitecture.getTopComponent();
        EList subComponents = topComponent.getSubComponents();
        for (Component source : subComponents) {
            for (Component target : subComponents) {
                if (!GraphUtils.isConnected(source, target)) continue;
                Integer connNum = (Integer)adjacencyMatrix.get((Object)source, (Object)target);
                connNum = connNum != null ? connNum : Integer.valueOf(0);
                connNum = connNum + 1;
                adjacencyMatrix.put((Object)source, (Object)target, (Object)connNum);
            }
        }
        return adjacencyMatrix;
    }

    public static ArchitectureGraph<Component> getGraph(ComponentArchitecture componentArchitecture) {
        return new ArchitectureGraph<Component>((Collection<Component>)componentArchitecture.getTopComponent().getSubComponents(), GraphUtils.getAdjacencyMatrix(componentArchitecture));
    }

    public static ComponentArchitecture getComponentArchitecture(ArchitectureGraph<Component> graph, String name) {
        Component topLevelComponent = ComponentModelElementFactory.createComponent((String)name, (String)"");
        ComponentArchitecture architecture = ComponentModelElementFactory.createComponentArchitecture((Component)topLevelComponent);
        GraphUtils.defineStronglyCausalComponents(graph);
        for (Component component : graph.vertexSet()) {
            topLevelComponent.getContainedElements().add((Object)component);
        }
        int channel_id = 0;
        for (DefaultWeightedEdge edge : graph.edgeSet()) {
            Component from = (Component)graph.getEdgeSource(edge);
            Component to = (Component)graph.getEdgeTarget(edge);
            OutputPort outputPort = ComponentModelElementFactory.createOutputPort((String)("OutputPort " + channel_id), (String)"");
            InputPort inputPort = ComponentModelElementFactory.createInputPort((String)("InputPort " + channel_id), (String)"");
            from.getConnectors().add((Object)outputPort);
            to.getConnectors().add((Object)inputPort);
            ComponentModelElementFactory.createChannelAndAttach((Component)topLevelComponent, (String)"Channel", (Port)outputPort, (Port)inputPort);
            ++channel_id;
        }
        GraphUtils.breakRemainingCycles(architecture);
        return architecture;
    }

    private static void defineStronglyCausalComponents(ArchitectureGraph<Component> graph) {
        GabowStrongConnectivityInspector connAlg = new GabowStrongConnectivityInspector(graph);
        HashMap cycleOccurrenceMap = new HashMap();
        graph.vertexSet().forEach(c -> {
            Integer n = cycleOccurrenceMap.put(c, 0);
        });
        for (Set strongCycle : connAlg.stronglyConnectedSets()) {
            for (Component comp : strongCycle) {
                Integer occurence = (Integer)cycleOccurrenceMap.get(comp);
                occurence = occurence + 1;
            }
        }
        for (Set strongCycle : connAlg.stronglyConnectedSets()) {
            Component strongComp = (Component)strongCycle.stream().findAny().get();
            for (Component comp : strongCycle) {
                if ((Integer)cycleOccurrenceMap.get(comp) <= (Integer)cycleOccurrenceMap.get(strongComp)) continue;
                strongComp = comp;
            }
            strongComp.getCausalitySpecification().setStronglyCausal(true);
        }
    }

    private static void breakRemainingCycles(ComponentArchitecture compArch) {
        ArrayList results = new ArrayList();
        WeakCausalityCycleConstraintChecker checker = new WeakCausalityCycleConstraintChecker();
        checker.collectViolations(compArch, results);
        for (IConstraintViolation violation : results) {
            ((Component)violation.getSource()).getCausalitySpecification().setStronglyCausal(true);
        }
    }

    private static boolean isConnected(Component source, Component target) {
        boolean connected = false;
        for (Channel channel : source.getParentComponent().getChannels()) {
            if (!source.getConnectors().contains((Object)channel.getSource()) || !target.getConnectors().contains((Object)channel.getTarget())) continue;
            connected = true;
            break;
        }
        return connected;
    }
}

