/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.testgenerator.util;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationModelElementFactory;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.InitialInputDefinitionStep;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.ProjectConfiguration;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.af3.project.utils.ProjectModelElementFactory;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.timing.TaskStartEvent;
import org.fortiss.af3.task.util.ComponentToTaskArchitectureTransformation;
import org.fortiss.af3.task.util.TaskModelElementFactory;
import org.fortiss.af3.timing.model.Event;
import org.fortiss.af3.timing.model.PeriodicConstraint;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.utils.TimingModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class ProjectUtils {
    private ProjectUtils() {
    }

    public static List<FileProject> createAF3Projects(Collection<ComponentArchitecture> compArchs, Collection<PlatformArchitecture> platArchs, String name) throws IllegalStateException {
        ArrayList<FileProject> fileProjects = new ArrayList<FileProject>();
        for (PlatformArchitecture platArch : platArchs) {
            for (ComponentArchitecture compArch : compArchs) {
                PlatformArchitecture fpPlatArch = (PlatformArchitecture)EcoreUtils.copy((EObject)platArch);
                ComponentArchitecture fpCompArch = (ComponentArchitecture)EcoreUtils.copy((EObject)compArch);
                AllocationTableCollection allocTableColl = AllocationModelElementFactory.createAllocationTableCollection((String)"AllocationTable");
                TaskArchitecture taskArch = ProjectUtils.generateTaskArchitecture(fpCompArch, allocTableColl);
                allocTableColl.getContainedElements().add((Object)TaskModelElementFactory.createTaskToExecutionUnitAllocationTable((String)"Task_ExU Allocs", (TaskArchitecture)taskArch, (PlatformArchitecture)fpPlatArch));
                TimingSpecification timingSpec = ProjectUtils.generateTimingSpecification(taskArch);
                FileProject fp = ProjectUtils.createAF3Project(fpCompArch, taskArch, timingSpec, allocTableColl, fpPlatArch, name);
                fileProjects.add(fp);
            }
        }
        return fileProjects;
    }

    private static TaskArchitecture generateTaskArchitecture(ComponentArchitecture componentArchitecture, AllocationTableCollection allocationTableCollection) {
        ComponentToTaskArchitectureTransformation componentToTaskTranformator = new ComponentToTaskArchitectureTransformation();
        TaskArchitecture taskArchitecture = (TaskArchitecture)componentToTaskTranformator.transform(componentArchitecture.getTopComponent(), Collections.emptyList(), allocationTableCollection);
        return taskArchitecture;
    }

    private static TimingSpecification generateTimingSpecification(TaskArchitecture taskArch) {
        TimingSpecification timingSpec = TimingModelElementFactory.createTimingSpecification((String)"Timing Specification", (IProjectRootElement)taskArch);
        for (Task task : taskArch.getTasks()) {
            PeriodicConstraint pConstraint = TimingModelElementFactory.createPeriodicConstraint();
            pConstraint.setPeriod(BigDecimal.ONE);
            pConstraint.setJitter(BigDecimal.ZERO);
            TaskStartEvent startEvent = (TaskStartEvent)TimingModelElementFactory.createEntityEvent(TaskStartEvent.class, (IModelElement)task);
            timingSpec.addEvent((Event)startEvent);
            pConstraint.setEvent((Event)startEvent);
            timingSpec.getConstraints().add((Object)pConstraint);
        }
        return timingSpec;
    }

    private static FileProject createAF3Project(ComponentArchitecture componentArchitecture, TaskArchitecture taskArch, TimingSpecification timingSpec, AllocationTableCollection allocationTableCollection, PlatformArchitecture platformArchitecture, String name) throws IllegalStateException {
        FileProject fileProject = ProjectModelElementFactory.createFileProject((String)name, (ProjectConfiguration)ProjectModelElementFactory.createProjectConfiguration());
        fileProject.getRootElements().add((Object)componentArchitecture);
        fileProject.getRootElements().add((Object)allocationTableCollection);
        fileProject.getRootElements().add((Object)taskArch);
        fileProject.getRootElements().add((Object)timingSpec);
        fileProject.getRootElements().add((Object)platformArchitecture);
        return fileProject;
    }

    public static void saveFileProjects(Collection<FileProject> fileProjects) throws IOException {
        org.fortiss.af3.project.utils.ProjectUtils.ensureEclipseContainerProjectExists();
        int projectID = -1;
        for (FileProject fp : fileProjects) {
            UniqueIDUtils.generateAllIDs((EObject)fp);
            String nameSuffix = "_" + ++projectID;
            fp.setName(fp.getName() + nameSuffix);
            DSE dse = (DSE)EcoreUtils.getFirstChildWithType((EObject)fp, DSE.class);
            if (dse != null) {
                dse.setName(dse.getName() + nameSuffix);
                InitialInputDefinitionStep inputStep = (InitialInputDefinitionStep)EcoreUtils.getFirstChildWithType((EObject)dse, InitialInputDefinitionStep.class);
                if (inputStep != null) {
                    String name = inputStep.getName();
                    inputStep.setName(name.substring(0, name.length() - 1) + nameSuffix + "\"");
                }
            }
            URI prjURI = URI.createURI((String)(String.valueOf(FileUtils.getDefaultGeneralProjectURI()) + File.separator + fp.getName() + ".af3_23"));
            org.fortiss.af3.project.utils.ProjectUtils.saveProject((FileProject)fp, (URI)prjURI);
        }
    }
}

