/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.SolverSettings;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.InitialInputDefinitionStep;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.project.ProjectFactory;
import org.fortiss.af3.exploration.model.project.ProjectPackage;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.project.SystemConstraintSet;
import org.fortiss.af3.exploration.model.project.TargetDefinitionStep;
import org.fortiss.af3.exploration.service.IDSEBackend;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class DSEProjectModelElementFactory {
    public static DSE createDSE(String name, FileProject fp) {
        DSE dse = ProjectFactory.eINSTANCE.createDSE();
        dse.setName(name);
        dse.setDate(new Date());
        InitialInputDefinitionStep step = ProjectFactory.eINSTANCE.createInitialInputDefinitionStep();
        step.setName("Import of model \"" + fp.getName() + "\"");
        dse.setInitialStep(step);
        dse.setCurrentStep(step);
        return dse;
    }

    public static RuleSet createRuleSet() {
        return ProjectFactory.eINSTANCE.createRuleSet();
    }

    public static RuleSet createRuleSet(String setName, String author, String comment) {
        RuleSet exSpecSubSet = DSEProjectModelElementFactory.createRuleSet();
        exSpecSubSet.setName(setName);
        exSpecSubSet.setAuthor(author);
        exSpecSubSet.setComment(comment);
        exSpecSubSet.setDate(new Date());
        return exSpecSubSet;
    }

    public static SystemConstraintSet createSystemConstraintSet(IProjectRootElement srcRootElement, String setName, String author, String comment) {
        SystemConstraintSet systemConstraintSet = ProjectFactory.eINSTANCE.createSystemConstraintSet();
        systemConstraintSet.setSrcRootElement(srcRootElement);
        systemConstraintSet.setImplicit(true);
        systemConstraintSet.setName(setName);
        systemConstraintSet.setAuthor(author);
        systemConstraintSet.setComment(comment);
        systemConstraintSet.setDate(new Date());
        return systemConstraintSet;
    }

    public static ModelSnapshot createModelSnapshot(IProjectRootElement rootElement, SuperSetMap map) {
        ModelSnapshot snapshot = ProjectFactory.eINSTANCE.createModelSnapshot();
        snapshot.setRootElement(rootElement);
        if (map != null) {
            EReference setFeature = ProjectPackage.Literals.MODEL_SNAPSHOT__SUPER_SET_MAP;
            snapshot.eSet((EStructuralFeature)setFeature, map);
            map.keySet().forEach(k -> snapshot.addSuperSet(map.get(k), k));
        }
        return snapshot;
    }

    public static ModelSnapshot createModelSnapshot(IProjectRootElement rootElement, SuperSetMap map, SystemConstraintSet systemConstraints) {
        ModelSnapshot snapshot = DSEProjectModelElementFactory.createModelSnapshot(rootElement, map);
        snapshot.setImplicitSystemConstraintSet(systemConstraints);
        EList sysConstraints = EcoreUtils.pickInstanceOf(IExplorationConstraint.class, systemConstraints.getExplorationTargets());
        EList<IExplorationConstraint<?>> constraintList = snapshot.getSystemConstraintContainmentList();
        constraintList.addAll((Collection<IExplorationConstraint<?>>)sysConstraints);
        return snapshot;
    }

    public static ModelSnapshot createModelSnapshot(IProjectRootElement rootElement, SuperSetMap map, SystemConstraintSet systemConstraints, Collection<? extends IModelElement> containments) {
        ModelSnapshot snapshot = DSEProjectModelElementFactory.createModelSnapshot(rootElement, map, systemConstraints);
        snapshot.getOptionalEntityContainments().addAll(containments);
        return snapshot;
    }

    public static ModelSnapshot createModelSnapshot() {
        return ProjectFactory.eINSTANCE.createModelSnapshot();
    }

    public static ExplorationStep createExplorationStep(String name, Collection<RuleSet> ruleSets, Map<Class<? extends IDSEBackend>, SolverSettings> settings) {
        ExplorationStep explorationStep = ProjectFactory.eINSTANCE.createExplorationStep();
        explorationStep.setName(name);
        explorationStep.getUsedRuleSets().addAll(ruleSets);
        Map<Class, SolverSettings> settingsCopy = settings.entrySet().parallelStream().collect(Collectors.toMap(e -> (Class)e.getKey(), e -> (SolverSettings)EcoreUtils.copy((EObject)((SolverSettings)e.getValue()))));
        explorationStep.getSolverSettings().putAll(settingsCopy);
        return explorationStep;
    }

    public static TargetDefinitionStep createTargetDefinitionStep(String name) {
        TargetDefinitionStep step = ProjectFactory.eINSTANCE.createTargetDefinitionStep();
        step.setName(name);
        return step;
    }

    public static SolutionSelectionStep createSolutionSelectionStep(String name) {
        SolutionSelectionStep step = ProjectFactory.eINSTANCE.createSolutionSelectionStep();
        step.setName(name);
        return step;
    }
}

