/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.util.List;
import org.fortiss.af3.exploration.model.specification.ContainedByElement;
import org.fortiss.af3.exploration.model.specification.IVolatileModelElementSpecification;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class DSESolutionConversionUtils {
    private DSESolutionConversionUtils() {
    }

    public static <T extends IVolatileModelElementSpecification> T getAndRemoveSpec(IModelElement element, Class<? extends T> specType) {
        IVolatileModelElementSpecification spec = (IVolatileModelElementSpecification)EcoreUtils.pickFirstInstanceOf(specType, (List)element.getSpecifications());
        if (spec == null) {
            return null;
        }
        element.getSpecifications().remove((Object)spec);
        return (T)spec;
    }

    public static IHierarchicElement getContainedByAndRemoveSpec(IModelElement element) {
        ContainedByElement containmentSpec = DSESolutionConversionUtils.getAndRemoveSpec(element, ContainedByElement.class);
        if (containmentSpec == null) {
            return null;
        }
        return containmentSpec.getFutureContainerRef();
    }

    public static void throwConversionError(String converterName, String errMsg) {
        String errString = "The converter " + converterName + " produced an error:\n\n" + errMsg;
        LoggingUtils.showError((String)errString);
        throw new RuntimeException(errString);
    }
}

