/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticFactory;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Div;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Maximum;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Minus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Mul;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Sum;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanpFactory;
import org.fortiss.af3.exploration.dseml.model.booleanp.Exists;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.Implies;
import org.fortiss.af3.exploration.dseml.model.booleanp.Not;
import org.fortiss.af3.exploration.dseml.model.booleanp.Or;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.AllocationFactory;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Dislocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.ComparisonFactory;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Equal;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Greater;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.GreaterEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Less;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.LessEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.NotEqual;
import org.fortiss.af3.exploration.dseml.model.expression.ExpressionFactory;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.AllocationType;
import org.fortiss.af3.exploration.dseml.model.function.AllocationTypeEnum;
import org.fortiss.af3.exploration.dseml.model.function.Deploy;
import org.fortiss.af3.exploration.dseml.model.function.FunctionFactory;
import org.fortiss.af3.exploration.dseml.model.function.IsTask;
import org.fortiss.af3.exploration.dseml.model.function.MasterActive;
import org.fortiss.af3.exploration.dseml.model.function.MaxTime;
import org.fortiss.af3.exploration.dseml.model.function.Maximize;
import org.fortiss.af3.exploration.dseml.model.function.Minimize;
import org.fortiss.af3.exploration.dseml.model.function.StronglyCausal;
import org.fortiss.af3.exploration.dseml.model.function.Uses;
import org.fortiss.af3.exploration.dseml.model.function.Weight;
import org.fortiss.af3.exploration.lang.Function;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class DSMLModelElementFactory {
    public static Plus createPlus(IArithmeticExpression left, IArithmeticExpression right) {
        Plus plus = ArithmeticFactory.eINSTANCE.createPlus();
        plus.setLeft(left);
        plus.setRight(right);
        return plus;
    }

    public static Minus createMinus(IArithmeticExpression left, IArithmeticExpression right) {
        Minus minus = ArithmeticFactory.eINSTANCE.createMinus();
        minus.setLeft(left);
        minus.setRight(right);
        return minus;
    }

    public static Mul createMul(IArithmeticExpression left, IArithmeticExpression right) {
        Mul mul = ArithmeticFactory.eINSTANCE.createMul();
        mul.setLeft(left);
        mul.setRight(right);
        return mul;
    }

    public static Div createDiv(IArithmeticExpression left, IArithmeticExpression right) {
        Div div = ArithmeticFactory.eINSTANCE.createDiv();
        div.setLeft(left);
        div.setRight(right);
        return div;
    }

    public static ArithmeticLiteral createArithmeticLiteral(BigDecimal value) {
        ArithmeticLiteral literal = ArithmeticFactory.eINSTANCE.createArithmeticLiteral();
        literal.setValue(value);
        return literal;
    }

    public static <T extends IModelElement, R extends Number> ArithmeticPropertyLiteral<T, R> createArithmeticPropertyLiteral(Set<T> setReference, Function<T, R> getter, String name) {
        ArithmeticPropertyLiteral literal = ArithmeticFactory.eINSTANCE.createArithmeticPropertyLiteral();
        literal.setSetReference(setReference);
        literal.setGetter(getter);
        literal.setName(name);
        return literal;
    }

    public static <T extends IModelElement, R extends Number> ArithmeticPropertyLiteral<T, R> createAnnotationArithPropLit(Set<T> meSet, Class<? extends IAnnotatedSpecification> annType) {
        Function annotationValGetter = me -> (Number)AnnotationUtils.getAnnotationValue((IModelElement)me, (Class)annType, Number.class);
        return DSMLModelElementFactory.createArithmeticPropertyLiteral(meSet, annotationValGetter, annType.getSimpleName());
    }

    public static <T extends IModelElement> ArithmeticPropertyLiteral<T, Integer> createEnumAnnotationArithPropLit(Set<T> meSet, Class<? extends IAnnotatedSpecification> annType) {
        Function annotationValGetter = me -> {
            Enum enumVal = (Enum)AnnotationUtils.getAnnotationValue((IModelElement)me, (Class)annType, Enum.class);
            return enumVal.ordinal();
        };
        return DSMLModelElementFactory.createArithmeticPropertyLiteral(meSet, annotationValGetter, annType.getSimpleName());
    }

    public static <T extends IModelElement> BooleanPropertyLiteral<T> createBooleanPropertyLiteral(Set<T> setReference, Function<T, Boolean> getter) {
        BooleanPropertyLiteral<T> literal = BooleanpFactory.eINSTANCE.createBooleanPropertyLiteral();
        literal.setSetReference(setReference);
        literal.setGetter(getter);
        return literal;
    }

    public static Sum createSum(Set<IModelElement> set, IBooleanExpression predicate, IArithmeticExpression term) {
        Sum sum = ArithmeticFactory.eINSTANCE.createSum();
        sum.setSet(set);
        sum.setExpression(predicate);
        sum.setTerms(term);
        return sum;
    }

    public static Maximum createMaximum(Set<IModelElement> set, IBooleanExpression predicate, IArithmeticExpression term) {
        Maximum maximum = ArithmeticFactory.eINSTANCE.createMaximum();
        maximum.setSet(set);
        maximum.setExpression(predicate);
        maximum.setTerms(term);
        return maximum;
    }

    public static Not createNot(IBooleanExpression expr) {
        Not not = BooleanpFactory.eINSTANCE.createNot();
        not.setRight(expr);
        return not;
    }

    public static And createAnd(IBooleanExpression left, IBooleanExpression right) {
        And and = BooleanpFactory.eINSTANCE.createAnd();
        and.setLeft(left);
        and.setRight(right);
        return and;
    }

    public static Or createOr(IBooleanExpression left, IBooleanExpression right) {
        Or and = BooleanpFactory.eINSTANCE.createOr();
        and.setLeft(left);
        and.setRight(right);
        return and;
    }

    public static Implies createImplies(IBooleanExpression left, IBooleanExpression right) {
        Implies and = BooleanpFactory.eINSTANCE.createImplies();
        and.setLeft(left);
        and.setRight(right);
        return and;
    }

    public static BooleanLiteral createBooleanLiteral(boolean value) {
        BooleanLiteral literal = BooleanpFactory.eINSTANCE.createBooleanLiteral();
        literal.setValue(value);
        return literal;
    }

    public static ForAll createForAll() {
        return BooleanpFactory.eINSTANCE.createForAll();
    }

    public static <T extends IModelElement> ForAll createForAll(Set<T> set, IBooleanExpression expression, boolean unfold) {
        ForAll forAll = BooleanpFactory.eINSTANCE.createForAll();
        forAll.setUnfold(unfold);
        forAll.setSet(set.getCastedSet(IModelElement.class));
        forAll.setExpression(expression);
        return forAll;
    }

    public static Exists createExists() {
        return BooleanpFactory.eINSTANCE.createExists();
    }

    public static Exists createExists(Set<IModelElement> set, IBooleanExpression expression, boolean unfold) {
        Exists exists = BooleanpFactory.eINSTANCE.createExists();
        exists.setUnfold(unfold);
        exists.setSet(set);
        exists.setExpression(expression);
        return exists;
    }

    public static Equal createEquals(IExpression left, IExpression right) {
        Equal equals = ComparisonFactory.eINSTANCE.createEqual();
        equals.setLeft(left);
        equals.setRight(right);
        return equals;
    }

    public static Less createLess(IArithmeticExpression left, IArithmeticExpression right) {
        Less equals = ComparisonFactory.eINSTANCE.createLess();
        equals.setLeft(left);
        equals.setRight(right);
        return equals;
    }

    public static LessEqual createLessEqual(IArithmeticExpression left, IArithmeticExpression right) {
        LessEqual equals = ComparisonFactory.eINSTANCE.createLessEqual();
        equals.setLeft(left);
        equals.setRight(right);
        return equals;
    }

    public static Greater createGreater(IArithmeticExpression left, IArithmeticExpression right) {
        Greater equals = ComparisonFactory.eINSTANCE.createGreater();
        equals.setLeft(left);
        equals.setRight(right);
        return equals;
    }

    public static GreaterEqual createGreaterEqual(IArithmeticExpression left, IArithmeticExpression right) {
        GreaterEqual equals = ComparisonFactory.eINSTANCE.createGreaterEqual();
        equals.setLeft(left);
        equals.setRight(right);
        return equals;
    }

    public static NotEqual createNotEqual(IExpression left, IExpression right) {
        NotEqual equals = ComparisonFactory.eINSTANCE.createNotEqual();
        equals.setLeft(left);
        equals.setRight(right);
        return equals;
    }

    public static Minimize createMinimize(IArithmeticExpression expr) {
        Minimize minimum = FunctionFactory.eINSTANCE.createMinimize();
        minimum.setArgs(expr);
        return minimum;
    }

    public static Maximize createMaximize(IArithmeticExpression expr) {
        Maximize maximum = FunctionFactory.eINSTANCE.createMaximize();
        maximum.setArgs(expr);
        return maximum;
    }

    public static Allocation createAllocation(ModelElementLiteral left, ModelElementLiteral right) {
        Allocation allocation = AllocationFactory.eINSTANCE.createAllocation();
        allocation.setLeft(left);
        allocation.setRight(right);
        return allocation;
    }

    public static Dislocation createDislocation(ModelElementLiteral left, ModelElementLiteral right) {
        Dislocation allocation = AllocationFactory.eINSTANCE.createDislocation();
        allocation.setLeft(left);
        allocation.setRight(right);
        return allocation;
    }

    public static ModelElementLiteral createModelElementLiteral(Set<?> setReference) {
        ModelElementLiteral literal = ExpressionFactory.eINSTANCE.createModelElementLiteral();
        literal.setSetReference(setReference);
        return literal;
    }

    public static <T extends IModelElement> Set<T> createSet(SuperSet<T> superSet, Collection<T> entries, String name, Class<T> setType) {
        Set set = ExpressionFactory.eINSTANCE.createSet();
        set.setEntryType(setType);
        set.setSuperSetReference(superSet);
        set.getEntries().addAll(entries);
        set.setName(name);
        return set;
    }

    public static <T extends IModelElement> Set<T> createSet(SuperSet<T> superSet, List<T> entries, Class<T> setType) {
        return DSMLModelElementFactory.createSet(superSet, entries, setType.getSimpleName() + "_Set", setType);
    }

    public static <T extends IModelElement> Set<T> createSet(SuperSet<T> superSet, T entry, String name, Class<T> setType) {
        return DSMLModelElementFactory.createSet(superSet, Collections.singletonList(entry), name, setType);
    }

    public static <T extends IModelElement> Set<T> createSet(SuperSet<T> superSet, T entry, Class<T> setType) {
        return DSMLModelElementFactory.createSet(superSet, entry, setType.getSimpleName() + "_Set", setType);
    }

    public static <T extends IModelElement> Set<T> createSet(SuperSet<T> superSet, String name, Class<T> setType) {
        return DSMLModelElementFactory.createSet(superSet, Collections.emptyList(), name, setType);
    }

    public static Uses createUses(ModelElementLiteral arg0, ModelElementLiteral arg1) {
        Uses uses = FunctionFactory.eINSTANCE.createUses();
        uses.setArg0(arg0);
        uses.setArg1(arg1);
        return uses;
    }

    public static StronglyCausal createStronglyCausal(ModelElementLiteral arg) {
        StronglyCausal sc = FunctionFactory.eINSTANCE.createStronglyCausal();
        sc.setArg0(arg);
        return sc;
    }

    public static IsTask createIsTask(ModelElementLiteral arg) {
        IsTask it = FunctionFactory.eINSTANCE.createIsTask();
        it.setArg0(arg);
        return it;
    }

    public static Weight createWeight(ModelElementLiteral arg0) {
        Weight weight = FunctionFactory.eINSTANCE.createWeight();
        weight.setArg0(arg0);
        return weight;
    }

    public static MaxTime createMaxTime() {
        MaxTime time = FunctionFactory.eINSTANCE.createMaxTime();
        return time;
    }

    public static AllocationType createAllocationType(AllocationTypeEnum value) {
        AllocationType at = FunctionFactory.eINSTANCE.createAllocationType();
        at.setValue(BigDecimal.valueOf(value.getValue()));
        return at;
    }

    public static MasterActive createMasterActive(ModelElementLiteral task, ModelElementLiteral fs) {
        MasterActive masterActive = FunctionFactory.eINSTANCE.createMasterActive();
        masterActive.setTask(task);
        masterActive.setFs(fs);
        return masterActive;
    }

    public static Deploy createDeploy(ModelElementLiteral task, ModelElementLiteral ecu, ModelElementLiteral fs) {
        Deploy deployType = FunctionFactory.eINSTANCE.createDeploy();
        deployType.setTask(task);
        deployType.setFs(fs);
        deployType.setEcu(ecu);
        return deployType;
    }

    public static <T extends IModelElement> SuperSet<T> createSuperSet(Collection<T> entries, String name, Class<T> setType) {
        TreeSet<T> sortedEntries = new TreeSet<T>(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                String name2;
                String name1;
                int cmpResult;
                int id2;
                int id1;
                if (o1 instanceof IIdLabeled && o2 instanceof IIdLabeled && (id1 = ((IIdLabeled)o1).getId()) != (id2 = ((IIdLabeled)o2).getId())) {
                    return Integer.compare(id1, id2);
                }
                if (o1 instanceof INamedElement && o2 instanceof INamedElement && (cmpResult = (name1 = KernelModelElementUtils.computeFullyQualifiedName((INamedElement)((INamedElement)o1))).compareTo(name2 = KernelModelElementUtils.computeFullyQualifiedName((INamedElement)((INamedElement)o2)))) != 0) {
                    return cmpResult;
                }
                return Integer.compare(o1.hashCode(), o2.hashCode());
            }
        });
        sortedEntries.addAll(entries);
        SuperSet<T> set = DSMLModelElementFactory.createSuperSet(name, setType);
        set.getEntries().addAll(sortedEntries);
        return set;
    }

    public static <T extends IModelElement> SuperSet<T> createSuperSet(String name, Class<T> setType) {
        SuperSet set = ExpressionFactory.eINSTANCE.createSuperSet();
        set.setEntryType(setType);
        set.setSuperSetReference(set);
        set.setName(name);
        return set;
    }
}

