/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.IPlatformSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.IReconfigurationSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ExplorationCLIUtils {
    private ExplorationCLIUtils() {
    }

    public static DSE findMatchingDSEProject(String argument) {
        Pair<String, String> prjNames = ExplorationCLIUtils.parseArgument(argument);
        if (prjNames == null) {
            return null;
        }
        return ExplorationCLIUtils.findReferencedDSEProject((String)prjNames.getLeft(), (String)prjNames.getRight());
    }

    private static Pair<String, String> parseArgument(String argument) {
        int slashCount = StringUtils.countMatches((CharSequence)argument, (CharSequence)"/");
        if (slashCount < 1) {
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"The DSE to be loaded at startup must be provided in the format <AF3-Project>/<DSE-Name>.");
            return null;
        }
        String[] argParts = argument.split("/");
        return Pair.of((Object)argParts[0], (Object)argParts[1]);
    }

    private static DSE findReferencedDSEProject(String af3PrjName, String dsePrjName) {
        String errMsg;
        FileProject matchingAF3Project = null;
        DSE matchingDSE = null;
        for (ITopLevelElement topElement : IPersistencyService.getInstance().getTopLevelElements()) {
            FileProject fp;
            if (!(topElement.getRootModelElement() instanceof FileProject) || !(fp = (FileProject)topElement.getRootModelElement()).getName().equals(af3PrjName)) continue;
            matchingAF3Project = fp;
            break;
        }
        if (matchingAF3Project == null) {
            errMsg = "Could not find a matching AF3 Project with the name " + af3PrjName + " to load a DSE project.";
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)errMsg);
            LoggingUtils.showError((String)errMsg);
            return null;
        }
        for (DSE dse : EcoreUtils.pickInstanceOf(DSE.class, (List)matchingAF3Project.getRootElements())) {
            if (!dse.getName().equals(dsePrjName)) continue;
            matchingDSE = dse;
            break;
        }
        if (matchingDSE == null) {
            errMsg = "Could not find a matching DSE project with the name " + dsePrjName + " in the AF3 project " + af3PrjName + ".";
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)errMsg);
            LoggingUtils.showError((String)errMsg);
            return null;
        }
        return matchingDSE;
    }

    public static Set<Class<? extends ISynthesisCategory>> getExplorationTypeByArgument(String argument) {
        String explorationType;
        int expectedDividers = 2;
        int synthArtifactPos = 2;
        int slashCount = StringUtils.countMatches((CharSequence)argument, (CharSequence)"/");
        if (slashCount != expectedDividers) {
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)"To execute a DSE, please specify it as follows: <AF3-Project>/<DSE-Name>/<ExplorationType>.\nThe exploration type can be a \"Deployment\", \"Schedule\",\"Reconfiguration\", or \"DeploySchedule\"");
            return null;
        }
        String[] argParts = argument.split("/");
        switch (explorationType = argParts[synthArtifactPos]) {
            case "Platform": {
                return Sets.newHashSet((Object[])new Class[]{IPlatformSynthesis.class});
            }
            case "Deployment": {
                return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
            }
            case "Schedule": {
                return Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
            }
            case "Reconfiguration": {
                return Sets.newHashSet((Object[])new Class[]{IReconfigurationSynthesis.class});
            }
            case "DeploSchedule": {
                return Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class, IScheduleSynthesis.class});
            }
        }
        return null;
    }
}

