/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.util.Collection;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.model.BackendSetting;
import org.fortiss.af3.exploration.model.ExplorationConstraint;
import org.fortiss.af3.exploration.model.ExplorationFactory;
import org.fortiss.af3.exploration.model.ExplorationObjective;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.HazardDefinitionConstraint;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SolverSettings;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.TerminationCriteria;
import org.fortiss.af3.exploration.model.dimension.DimensionFactory;
import org.fortiss.af3.exploration.model.dimension.EnergyDimension;
import org.fortiss.af3.exploration.model.dimension.ReliabilityDimension;
import org.fortiss.af3.exploration.model.dimension.ResourceDimension;
import org.fortiss.af3.exploration.model.dimension.SafetyDimension;
import org.fortiss.af3.exploration.model.dimension.TemporalDimension;
import org.fortiss.af3.exploration.model.dimension.UserDefinedDimension;
import org.fortiss.af3.exploration.model.impl.SuperSetMapImpl;
import org.fortiss.af3.exploration.model.solutions.ExplorationResult;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SolutionsFactory;
import org.fortiss.af3.exploration.model.solutions.impl.SingleExplorationSolutionImpl;
import org.fortiss.af3.exploration.model.specification.ContainedByElement;
import org.fortiss.af3.exploration.model.specification.InstanceOfElement;
import org.fortiss.af3.exploration.model.specification.IntegerAttribute;
import org.fortiss.af3.exploration.model.specification.ModelElementReference;
import org.fortiss.af3.exploration.model.specification.SpecificationFactory;
import org.fortiss.af3.exploration.model.synthesiscategory.IPlatformSynthesis;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.safety.model.artefact.Hazard;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;

public class ExplorationModelElementFactory {
    public static ExplorationSpecification createExplorationSpecification() {
        return ExplorationFactory.eINSTANCE.createExplorationSpecification();
    }

    private static <T> void initializeExplorationTarget(IExplorationTarget<T> explorationTarget, Class<T> returnType, IProblemDimension probDim, Collection<Class<? extends ISynthesisCategory>> synthCategory, IExpression expr, String name) {
        explorationTarget.setResultType(returnType);
        explorationTarget.setExpression(expr);
        explorationTarget.setProblemDimension(probDim);
        explorationTarget.getSynthesisCategories().addAll(synthCategory);
        explorationTarget.setName(name);
    }

    public static <T> ExplorationObjective<T> createExplorationObjective(Class<T> returnType, IProblemDimension probDim, Collection<Class<? extends ISynthesisCategory>> synthCategory, IExpression expr, String name) {
        ExplorationObjective objective = ExplorationFactory.eINSTANCE.createExplorationObjective();
        ExplorationModelElementFactory.initializeExplorationTarget(objective, returnType, probDim, synthCategory, expr, name);
        return objective;
    }

    public static <T> ExplorationConstraint<T> createExplorationConstraint(Class<T> returnType, IProblemDimension probDim, Collection<Class<? extends ISynthesisCategory>> synthCategory, IExpression expr, String name, boolean isImplicit) {
        ExplorationConstraint constraint = ExplorationFactory.eINSTANCE.createExplorationConstraint();
        ExplorationModelElementFactory.initializeExplorationTarget(constraint, returnType, probDim, synthCategory, expr, name);
        constraint.setImplicit(isImplicit);
        return constraint;
    }

    public static EnergyDimension createEnergyDimension() {
        return DimensionFactory.eINSTANCE.createEnergyDimension();
    }

    public static ReliabilityDimension createReliabilityDimension() {
        return DimensionFactory.eINSTANCE.createReliabilityDimension();
    }

    public static ResourceDimension createResourceDimension() {
        return DimensionFactory.eINSTANCE.createResourceDimension();
    }

    public static SafetyDimension createSafetyDimension() {
        return DimensionFactory.eINSTANCE.createSafetyDimension();
    }

    public static TemporalDimension createTemporalDimension() {
        return DimensionFactory.eINSTANCE.createTemporalDimension();
    }

    public static UserDefinedDimension createUserDefinedDimension(String identifier) {
        UserDefinedDimension dimension = DimensionFactory.eINSTANCE.createUserDefinedDimension();
        dimension.setIdentifier(identifier);
        return dimension;
    }

    public static SuperSetMap createSuperSetMap() {
        SuperSetMap superSets = ExplorationFactory.eINSTANCE.createSuperSetMap();
        ((SuperSetMapImpl)superSets).getSuperSetMap();
        return superSets;
    }

    public static ExplorationSolution createExplorationSolution() {
        return SolutionsFactory.eINSTANCE.createExplorationSolution();
    }

    public static SingleExplorationSolution createSingleExplorationSolution() {
        SingleExplorationSolution singleSolution = SolutionsFactory.eINSTANCE.createSingleExplorationSolution();
        ((SingleExplorationSolutionImpl)singleSolution).getSolutionMap();
        ((SingleExplorationSolutionImpl)singleSolution).setSolutionSets(ExplorationModelElementFactory.createSuperSetMap());
        return singleSolution;
    }

    public static <T> ExplorationResult<T> createExplorationResult(Class<T> valueType, T value) {
        ExplorationResult<T> result = ExplorationModelElementFactory.createExplorationResult();
        result.setResult(value);
        return result;
    }

    private static <T> ExplorationResult<T> createExplorationResult() {
        return SolutionsFactory.eINSTANCE.createExplorationResult();
    }

    public static SolverSettings createSolverSettings(int defaultTimeout_s, int defaultMaxIterations) {
        SolverSettings settings = ExplorationFactory.eINSTANCE.createSolverSettings();
        settings.setTermination(ExplorationModelElementFactory.createTerminationCriteria(defaultTimeout_s, defaultMaxIterations));
        return settings;
    }

    private static TerminationCriteria createTerminationCriteria(int defaultTimeout_s, int defaultMaxIterations) {
        TerminationCriteria term = ExplorationFactory.eINSTANCE.createTerminationCriteria();
        term.setName("Termination");
        term.setTimeoutS(ExplorationModelElementFactory.createBackendSetting("Timeout in s", Integer.class, defaultTimeout_s));
        term.setIterations(ExplorationModelElementFactory.createBackendSetting("Max Iterations", Integer.class, defaultMaxIterations));
        return term;
    }

    public static <T> BackendSetting<T> createBackendSetting(String name, Class<T> type, T defaultValue) {
        BackendSetting setting = ExplorationFactory.eINSTANCE.createBackendSetting();
        setting.setName(name);
        setting.setType(type);
        setting.setValue(defaultValue);
        return setting;
    }

    public static InstanceOfElement createInstanceOfElementSpec(IModelElement instanceElement, IModelElement templateElement) {
        InstanceOfElement spec = SpecificationFactory.eINSTANCE.createInstanceOfElement();
        spec.setTemplateElement(templateElement);
        spec.setSpecificationOf(instanceElement);
        return spec;
    }

    public static ContainedByElement createContainedByElementSpec(IModelElement thisElement, IHierarchicElement containerElement) {
        ContainedByElement spec = SpecificationFactory.eINSTANCE.createContainedByElement();
        spec.setFutureContainerRef(containerElement);
        spec.setSpecificationOf(thisElement);
        return spec;
    }

    public static ModelElementReference createModelElementReferenceSpec(IModelElement element, IModelElement referencedElement) {
        ModelElementReference spec = SpecificationFactory.eINSTANCE.createModelElementReference();
        spec.setModelElement(referencedElement);
        spec.setSpecificationOf(element);
        return spec;
    }

    public static IntegerAttribute createIntegerAttributeSpec(IModelElement element, int value) {
        IntegerAttribute spec = SpecificationFactory.eINSTANCE.createIntegerAttribute();
        spec.setValue(value);
        spec.setSpecificationOf(element);
        return spec;
    }

    public static HazardDefinitionConstraint createHazardDefinitionConstraint(Hazard hz, String name) {
        HazardDefinitionConstraint cstr = ExplorationFactory.eINSTANCE.createHazardDefinitionConstraint();
        cstr.setHazard(hz);
        cstr.setProblemDimension(ExplorationModelElementFactory.createReliabilityDimension());
        cstr.getSynthesisCategories().add(IPlatformSynthesis.class);
        cstr.setName(name);
        return cstr;
    }
}

