/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;

public class ExplorationReflectionUtils {
    public static <T> Class<T> getSubstitutionTypeOfGenericIface(Object object, Class<?> interfaceClass, Class<T> retType) {
        Type paramType;
        LinkedList<Class<?>> inheritancePath = ExplorationReflectionUtils.getClassPathToIface(object, interfaceClass);
        Stack<Type> paramTypeStack = new Stack<Type>();
        LinkedList hierTraversalList = new LinkedList();
        hierTraversalList.addAll(inheritancePath);
        Type currParamRawType = null;
        Predicate<Class> targetIfaceFound = t -> t != null && t.isAssignableFrom(interfaceClass);
        do {
            Class hierStackElem = (Class)hierTraversalList.poll();
            Type[] genTypes = hierStackElem.getGenericInterfaces();
            LinkedList<Type> typesToTraverse = new LinkedList<Type>();
            typesToTraverse.addAll(Arrays.asList(genTypes));
            while (!typesToTraverse.isEmpty() && !targetIfaceFound.test((Class)currParamRawType)) {
                Type currTraversedType = (Type)typesToTraverse.poll();
                paramTypeStack.add(currTraversedType);
                if (currTraversedType instanceof ParameterizedType) {
                    currParamRawType = ((ParameterizedType)currTraversedType).getRawType();
                    if (!inheritancePath.contains(currParamRawType)) continue;
                    Collection<Type> matchedTypes = ExplorationReflectionUtils.processParentParamerType(currParamRawType);
                    typesToTraverse.addAll(0, matchedTypes);
                    continue;
                }
                paramTypeStack.pop();
            }
            if (targetIfaceFound.test((Class)currParamRawType)) continue;
            paramTypeStack.clear();
        } while (!hierTraversalList.isEmpty() && !targetIfaceFound.test((Class)currParamRawType));
        if (targetIfaceFound.test((Class)currParamRawType) && (paramType = (Type)paramTypeStack.get(0)) instanceof ParameterizedType) {
            Type actParamType = ((ParameterizedType)paramType).getActualTypeArguments()[0];
            if (actParamType instanceof Class) {
                return (Class)actParamType;
            }
            if (actParamType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)actParamType).getRawType();
            }
        }
        return null;
    }

    private static Collection<Type> processParentParamerType(Type rawType) {
        ArrayList<Type> matchingTypes = new ArrayList<Type>();
        Type[] typeParams = ((Class)rawType).getGenericInterfaces();
        List xT = Arrays.asList(((Class)rawType).getTypeParameters());
        Type[] typeArray = typeParams;
        int n = typeParams.length;
        int n2 = 0;
        while (n2 < n) {
            Type[] typeArgs;
            Type parentType = typeArray[n2];
            if (parentType instanceof ParameterizedType && (typeArgs = ((ParameterizedType)parentType).getActualTypeArguments()).length == 1 && xT.contains(typeArgs[0])) {
                matchingTypes.add(parentType);
            }
            ++n2;
        }
        return matchingTypes;
    }

    private static LinkedList<Class<?>> getClassPathToIface(Object object, Class<?> interfaceClass) {
        LinkedList traversalList = new LinkedList();
        Stack<Class> hierarchyBrachStack = new Stack<Class>();
        LinkedList ifacesTraversalList = new LinkedList();
        ifacesTraversalList.addAll(Arrays.asList(object.getClass().getInterfaces()));
        while (!ifacesTraversalList.isEmpty()) {
            Class currIface = (Class)ifacesTraversalList.poll();
            traversalList.add(currIface);
            if (currIface.equals(interfaceClass)) break;
            Class<?>[] parentIfaces = currIface.getInterfaces();
            if (parentIfaces.length > 0) {
                ifacesTraversalList.addAll(0, Arrays.asList(parentIfaces));
                if (parentIfaces.length <= 1) continue;
                hierarchyBrachStack.add(currIface);
                continue;
            }
            int lastBranchIdx = 1;
            if (!hierarchyBrachStack.isEmpty()) {
                Class lastHierBranch = (Class)hierarchyBrachStack.lastElement();
                traversalList.indexOf(lastHierBranch);
            }
            ArrayList rmFromTravStrack = new ArrayList();
            rmFromTravStrack.addAll(traversalList.subList(lastBranchIdx, traversalList.size()));
            traversalList.removeAll(rmFromTravStrack);
        }
        return traversalList;
    }
}

