/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Segment;
import org.fortiss.af3.platform.utils.RouteUtils;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationTrigger;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.model.SchedulableEntity;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.af3.schedule.utils.AF3ScheduleModelElementFactory;
import org.fortiss.af3.schedule.utils.ScheduleUtils;
import org.fortiss.af3.task.model.Message;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.timing.TaskStartEvent;
import org.fortiss.af3.task.util.TaskModelElementFactory;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.utils.TimingUtils;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class ExplorationScheduleUtils {
    private ExplorationScheduleUtils() {
    }

    public static SystemSchedule generateSchedule(SuperSet<TaskToExecutionUnitAllocationEntry> ta2hw, SuperSet<Route> routeSuperSet, SuperSet<SignalToRouteAllocationEntry> s2rSetOut, TimingSpecification ts) {
        if (ta2hw == null || ta2hw.getEntries().isEmpty()) {
            return null;
        }
        HashMap<Route, SignalToRouteAllocationEntry> s2rMap = new HashMap<Route, SignalToRouteAllocationEntry>();
        SystemSchedule systemSchedule = AF3ScheduleModelElementFactory.createSystemSchedule((String)"SystemSchedule_");
        for (TaskToExecutionUnitAllocationEntry ae : ta2hw.getEntries()) {
            ExecutionUnit ecu = (ExecutionUnit)ae.getTargetElement();
            for (IModelElement source : ae.getSourceElements()) {
                Task task = (Task)source;
                BigDecimal period = TimingUtils.getPeriod((TimingSpecification)ts, (IModelElement)task, TaskStartEvent.class);
                PeriodicTimeTrigger trigger = AF3ScheduleModelElementFactory.createPeriodicTimeTrigger((BigDecimal)period, (BigDecimal)BigDecimal.ZERO);
                ExplorationScheduleUtils.createTask(systemSchedule, task, ecu, trigger);
                ExplorationScheduleUtils.createSignals(systemSchedule, task, ta2hw, routeSuperSet, s2rMap);
            }
        }
        s2rSetOut.getEntries().addAll(s2rMap.values());
        UniqueIDUtils.fixMissingIDs((EObject)systemSchedule, ta2hw);
        return systemSchedule;
    }

    private static void createTask(SystemSchedule systemSchedule, Task task, ExecutionUnit executionUnit, PeriodicTimeTrigger trigger) {
        ResourceSchedule resourceSchedule = ExplorationScheduleUtils.getOrCreateResourceSchedule(systemSchedule, (IPlatformResource)executionUnit);
        ResourceAllocation ra = ExplorationScheduleUtils.createResourceAllocation(task, executionUnit, trigger);
        resourceSchedule.getContainedElements().add((Object)ra);
        SchedulableEntity compEntity = AF3ScheduleModelElementFactory.createSchedulableEntity((String)("Task_" + task.getName()));
        compEntity.setModelElement((IModelElement)task);
        ra.setSchedulableEntity(compEntity);
    }

    private static ResourceSchedule getOrCreateResourceSchedule(SystemSchedule systemSchedule, IPlatformResource resource) {
        ResourceSchedule resourceSchedule = ScheduleUtils.getResourceSchedule((SystemSchedule)systemSchedule, (IPlatformResource)resource);
        if (resourceSchedule != null) {
            return resourceSchedule;
        }
        String resourceName = resource instanceof INamedElement ? ((INamedElement)resource).getName() : resource.toString();
        resourceSchedule = AF3ScheduleModelElementFactory.createResourceSchedule((String)resourceName);
        resourceSchedule.setResource(resource);
        systemSchedule.getContainedElements().add((Object)resourceSchedule);
        return resourceSchedule;
    }

    private static void createSignals(SystemSchedule systemSchedule, Task senderTask, SuperSet<TaskToExecutionUnitAllocationEntry> ta2hw, SuperSet<Route> routes, Map<Route, SignalToRouteAllocationEntry> entryMap) {
        ExecutionUnit senderEcu = ((TaskToExecutionUnitAllocationEntry)LambdaUtils.getFirst(ta2hw.getEntries(), e -> e.getSourceElements().contains((Object)senderTask)).get()).getExecutionUnit();
        for (TaskOutputPort senderPort : senderTask.getTaskOutputPorts()) {
            for (Signal signal : senderPort.getOutGoingSignals()) {
                Optional r;
                TaskInputPort receiverPort = signal.getTargetTaskPort();
                Task receiverTask = receiverPort.getTask();
                ExecutionUnit receiverEcu = ((TaskToExecutionUnitAllocationEntry)LambdaUtils.getFirst(ta2hw.getEntries(), e -> e.getSourceElements().contains((Object)receiverTask)).get()).getExecutionUnit();
                Collection availableRoutes = RouteUtils.getRoutes(routes.getEntries(), (IPlatformResource)senderEcu, (IPlatformResource)receiverEcu);
                if (availableRoutes.size() > 1) {
                    LoggingUtils.warning((Plugin)AF3ExplorationActivator.getDefault(), (String)String.format("Multiple alternative routes connecting %s and %s found. Selecting one randomly...", senderEcu.getName(), receiverEcu.getName()));
                }
                if (!(r = availableRoutes.stream().findAny()).isPresent()) {
                    LoggingUtils.warning((Plugin)AF3ExplorationActivator.getDefault(), (String)String.format("No route between %s and %s found. Skipping signal %s...", senderEcu.getName(), receiverEcu.getName(), signal.getName()));
                    continue;
                }
                Route route = (Route)r.get();
                SignalToRouteAllocationEntry s2r = entryMap.get(route);
                if (s2r == null) {
                    s2r = TaskModelElementFactory.createSignalToRouteAllocationEntry((Signal)signal, (Route)route);
                    entryMap.put(route, s2r);
                } else {
                    s2r.getSourceElements().add((Object)signal);
                }
                if (route == null) continue;
                Segment segment = route.getRootSegment();
                while (segment != null) {
                    ResourceSchedule resourceSchedule = ExplorationScheduleUtils.getOrCreateResourceSchedule(systemSchedule, (IPlatformResource)segment.getEntity());
                    if (!(segment.getEntity() instanceof ExecutionUnit)) {
                        ResourceAllocation ra = ExplorationScheduleUtils.createResourceAllocation(senderPort, receiverPort, segment);
                        resourceSchedule.getContainedElements().add((Object)ra);
                    }
                    Segment segment2 = segment = !segment.getNext().isEmpty() ? (Segment)segment.getNext().get(0) : null;
                }
            }
        }
    }

    public static SuperSet<ResourceAllocation> createResourceAllocations(SuperSet<Task> tasksSS, TimingSpecification ts) {
        SuperSet<ResourceAllocation> raSet = DSMLModelElementFactory.createSuperSet("ResourceAllocations", ResourceAllocation.class);
        for (Task senderTask : tasksSS.getEntries()) {
            BigDecimal period = TimingUtils.getPeriod((TimingSpecification)ts, (IModelElement)senderTask, TaskStartEvent.class);
            PeriodicTimeTrigger trigger = AF3ScheduleModelElementFactory.createPeriodicTimeTrigger((BigDecimal)period, (BigDecimal)BigDecimal.ZERO);
            ResourceAllocation ra = ExplorationScheduleUtils.createResourceAllocation(senderTask, null, trigger);
            SchedulableEntity compEntity = AF3ScheduleModelElementFactory.createSchedulableEntity((String)("Task_" + senderTask.getName()));
            compEntity.setModelElement((IModelElement)senderTask);
            ra.setSchedulableEntity(compEntity);
            raSet.getEntries().add((Object)ra);
            for (TaskOutputPort senderPort : senderTask.getTaskOutputPorts()) {
                for (IConnection connection : senderPort.getOutgoing()) {
                    TaskInputPort receiverPort = (TaskInputPort)connection.getTarget();
                    ResourceAllocation resAlloc = ExplorationScheduleUtils.createResourceAllocationMessage(senderPort, receiverPort);
                    raSet.getEntries().add((Object)resAlloc);
                }
            }
        }
        return raSet;
    }

    public static ResourceAllocation createResourceAllocation(Task task, ExecutionUnit executionUnit, PeriodicTimeTrigger trigger) {
        String name = task.getName();
        ResourceAllocation resourceAllocation = AF3ScheduleModelElementFactory.createResourceAllocation((String)name);
        BigDecimal wcet = task.getWcet(executionUnit);
        if (wcet == null) {
            throw new RuntimeException("No WCET has been provided for Task \"" + name + "\".");
        }
        resourceAllocation.setDuration(wcet);
        SchedulableEntity schedulableEntity = AF3ScheduleModelElementFactory.createSchedulableEntity((String)name);
        schedulableEntity.setModelElement((IModelElement)task);
        resourceAllocation.setSchedulableEntity(schedulableEntity);
        resourceAllocation.setTrigger((ResourceAllocationTrigger)trigger);
        return resourceAllocation;
    }

    private static ResourceAllocation createResourceAllocationMessage(TaskOutputPort senderPort, TaskInputPort receiverPort) {
        Message message = TaskModelElementFactory.createMessage((TaskOutputPort)senderPort, (TaskInputPort[])new TaskInputPort[]{receiverPort});
        message.setModelElement((IModelElement)senderPort);
        String senderName = senderPort.getTask().getName();
        String receiverName = receiverPort.getTask().getName();
        message.setName("Signal_" + senderName + "_to_" + receiverName + "_" + senderPort.getName());
        ResourceAllocation resourceAllocation = AF3ScheduleModelElementFactory.createResourceAllocation((String)message.getName());
        resourceAllocation.setDuration(new BigDecimal(5));
        resourceAllocation.setSchedulableEntity((SchedulableEntity)message);
        PeriodicTimeTrigger trigger = AF3ScheduleModelElementFactory.createPeriodicTimeTrigger((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        resourceAllocation.setTrigger((ResourceAllocationTrigger)trigger);
        return resourceAllocation;
    }

    public static ResourceAllocation createResourceAllocation(TaskOutputPort senderPort, TaskInputPort receiverPort, Segment segment) {
        IModelElement entity;
        String raName = "Signal_" + senderPort.getTask().getName() + "_to_" + receiverPort.getTask().getName() + "_" + senderPort.getName();
        ResourceAllocation resourceAllocation = AF3ScheduleModelElementFactory.createResourceAllocation((String)raName);
        resourceAllocation.setDuration(new BigDecimal(5));
        String entityName = segment != null ? ((entity = segment.getEntity()) instanceof INamedElement ? ((INamedElement)entity).getName() : entity.toString()) : "<>";
        SchedulableEntity se = AF3ScheduleModelElementFactory.createSchedulableEntity((String)("Segment_" + entityName));
        se.setModelElement((IModelElement)segment);
        resourceAllocation.setSchedulableEntity(se);
        PeriodicTimeTrigger trigger = AF3ScheduleModelElementFactory.createPeriodicTimeTrigger((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        resourceAllocation.setTrigger((ResourceAllocationTrigger)trigger);
        return resourceAllocation;
    }

    public static SuperSetMap constructSchedulableEntities(Optional<SuperSet<TaskToExecutionUnitAllocationEntry>> ta2hw, SuperSet<Route> routeSuperSet, Optional<SuperSet<SignalToRouteAllocationEntry>> s2rSetIn, TimingSpecification timingSpec, Collection<IModelElement> containments) {
        SuperSetMap superSetMap = ExplorationModelElementFactory.createSuperSetMap();
        SuperSet<SignalToRouteAllocationEntry> s2rSet = DSMLModelElementFactory.createSuperSet("SignaltoRouteAllocation", SignalToRouteAllocationEntry.class);
        SystemSchedule schedule = ExplorationScheduleUtils.generateSchedule(ta2hw.get(), routeSuperSet, s2rSet, timingSpec);
        SuperSet<ResourceAllocation> resAllocSet = DSMLModelElementFactory.createSuperSet("ResourceAllocations", ResourceAllocation.class);
        resAllocSet.getEntries().addAll((Collection)EcoreUtils.getChildrenWithType((EObject)schedule, ResourceAllocation.class));
        containments.add((IModelElement)schedule);
        superSetMap.put(ResourceAllocation.class, resAllocSet);
        if (s2rSetIn.isEmpty()) {
            superSetMap.put(SignalToRouteAllocationEntry.class, s2rSet);
            containments.addAll((Collection<IModelElement>)s2rSet.getEntries());
        }
        return superSetMap;
    }

    public static List<SingleExplorationSolution> getSchedulingSolutions(DSE dse) {
        SingleExplorationSolution selectedSolution;
        ArrayList<SingleExplorationSolution> solutionList = new ArrayList<SingleExplorationSolution>();
        ProcessStep processStep = dse.getCurrentStep();
        if (processStep instanceof ExplorationStep) {
            ExplorationSolution solution = ((ExplorationStep)processStep).getSolution();
            if (solution != null) {
                solution.getSolutions().forEach(ses -> {
                    if (ses.getAvailableSolutionModels().contains(ResourceAllocation.class)) {
                        solutionList.add((SingleExplorationSolution)ses);
                    }
                });
            }
        } else if (processStep instanceof SolutionSelectionStep && (selectedSolution = ((SolutionSelectionStep)processStep).getSelectedSolution()).getAvailableSolutionModels().contains(ResourceAllocation.class)) {
            solutionList.add(selectedSolution);
        }
        return solutionList;
    }
}

