/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.exploration.model.ExplorationSpecification;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.allocation.PartitionToExecutionUnitAllocationEntry;
import org.fortiss.af3.partition.model.allocation.TaskToPartitionAllocationEntry;
import org.fortiss.af3.partition.util.PartitionArchitectureUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.model.annotation.MessageSize;
import org.fortiss.af3.platform.utils.RouteUtils;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.timing.model.annotation.TransmissionUnitBandwidth;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.util.LambdaUtils;

public class ExplorationSpecificationUtils {
    private static final int MEGA_FACTOR = 1000000;
    private static final int ROUNDING_SCALE = 22;

    private ExplorationSpecificationUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutionUnit getExecutionUnit(ExplorationSpecification specification, Task task) {
        ExecutionUnit executionUnit = null;
        if (ExplorationSpecificationUtils.includesPartitions(specification)) {
            Map<Task, Partition> taskAllocations = ExplorationSpecificationUtils.extractTaskToPartitionAllocation(specification);
            Map<Partition, Collection<ExecutionUnit>> partitionAllocations = ExplorationSpecificationUtils.extractPartitionToExecutionUnitAllocation(specification);
            Collection<ExecutionUnit> executionUnits = partitionAllocations.get(taskAllocations.get(task));
            if (executionUnits.size() == 1) {
                return executionUnits.stream().findAny().get();
            }
            if (!executionUnits.isEmpty()) throw new UnsupportedOperationException("Partitions allocated to multiple execution units are not yet supported by the EDF backend.");
            throw new NoSuchElementException("No execution unit can be associated with the given task.");
        }
        EList taskToExecutionUnitAllocations = specification.getSearchSpace().get(TaskToExecutionUnitAllocationEntry.class).getEntries();
        Optional<TaskToExecutionUnitAllocationEntry> optionalAllocationEntry = taskToExecutionUnitAllocations.stream().filter(allocation -> allocation.getTasks().contains((Object)task)).findAny();
        if (!optionalAllocationEntry.isPresent()) return executionUnit;
        return optionalAllocationEntry.get().getExecutionUnit();
    }

    public static boolean includesPartitions(ExplorationSpecification specification) {
        SuperSetMap searchSpace = specification.getSearchSpace();
        boolean containsPartitions = searchSpace.containsKey(Partition.class);
        boolean allocatesTasksToPartitions = searchSpace.containsKey(TaskToPartitionAllocationEntry.class);
        boolean allocatesPartitionsToExecutionUnits = searchSpace.containsKey(PartitionToExecutionUnitAllocationEntry.class);
        return containsPartitions && allocatesTasksToPartitions && allocatesPartitionsToExecutionUnits;
    }

    public static Map<Signal, Route> extractSignalRoute(ExplorationSpecification specification) {
        HashMap<Signal, Route> signalRoute = new HashMap<Signal, Route>();
        if (ExplorationSpecificationUtils.includesPartitions(specification)) {
            Collection<Signal> signals = ExplorationSpecificationUtils.extractSignals(specification);
            Collection<Route> routes = ExplorationSpecificationUtils.extractRoutes(specification);
            Map<Task, ExecutionUnit> taskAllocation = ExplorationSpecificationUtils.extractTaskToExecutionUnitAllocation(specification);
            signals.forEach(signal -> {
                Task senderTask = signal.getSourceTaskPort().getTask();
                Task receiverTask = signal.getTargetTaskPort().getTask();
                ExecutionUnit senderExecutionUnit = (ExecutionUnit)taskAllocation.get(senderTask);
                ExecutionUnit receiverExecutionUnit = (ExecutionUnit)taskAllocation.get(receiverTask);
                Collection matchingRoutes = RouteUtils.getRoutes((Collection)routes, (IPlatformResource)senderExecutionUnit, (IPlatformResource)receiverExecutionUnit);
                List shortestRoutes = matchingRoutes.stream().sorted((a, b) -> Integer.compare(a.getAllSegments().size(), b.getAllSegments().size())).collect(Collectors.toList());
                Route route = (Route)shortestRoutes.stream().findFirst().get();
                signalRoute.put((Signal)signal, route);
            });
        } else {
            EList signalToRouteAllocations = specification.getSearchSpace().get(SignalToRouteAllocationEntry.class).getEntries();
            ExplorationSpecificationUtils.extractSignals(specification).forEach(signal -> {
                Optional<SignalToRouteAllocationEntry> optionalAllocationEntry = signalToRouteAllocations.stream().filter(allocation -> allocation.getSignals().contains(signal)).findAny();
                if (optionalAllocationEntry.isPresent()) {
                    Route route = optionalAllocationEntry.get().getRoute();
                    signalRoute.put((Signal)signal, route);
                }
            });
        }
        return signalRoute;
    }

    public static Map<Signal, TransmissionUnit> extractSignalAllocation(ExplorationSpecification specification) {
        HashMap<Signal, TransmissionUnit> signalAllocation = new HashMap<Signal, TransmissionUnit>();
        Map<Signal, Route> signalRoute = ExplorationSpecificationUtils.extractSignalRoute(specification);
        ExplorationSpecificationUtils.extractSignals(specification).forEach(signal -> {
            Route route = (Route)signalRoute.get(signal);
            Set<TransmissionUnit> transmissionUnits = ExplorationSpecificationUtils.getTransmissionUnits(specification, route);
            if (transmissionUnits.size() == 1) {
                TransmissionUnit transmissionUnit = (TransmissionUnit)LambdaUtils.getFirst(transmissionUnits).get();
                signalAllocation.put((Signal)signal, transmissionUnit);
            } else if (!transmissionUnits.isEmpty()) {
                throw new UnsupportedOperationException("Complex routes spanning multiple transmission units are not yet supported.");
            }
        });
        return signalAllocation;
    }

    public static Map<Signal, BigDecimal> extractSignalDuration(ExplorationSpecification specification) {
        HashMap<Signal, BigDecimal> signalDuration = new HashMap<Signal, BigDecimal>();
        Map<Signal, TransmissionUnit> signalAllocation = ExplorationSpecificationUtils.extractSignalAllocation(specification);
        ExplorationSpecificationUtils.extractSignals(specification).stream().filter(signal -> signalAllocation.containsKey(signal)).forEach(signal -> {
            TransmissionUnit transmissionUnit = (TransmissionUnit)signalAllocation.get(signal);
            BigDecimal size = new BigDecimal((Integer)AnnotationUtils.getAnnotationValue((IModelElement)signal.getSourceTaskPort(), MessageSize.class, Integer.class));
            BigDecimal bandwidth = new BigDecimal(1000000.0 * (Double)AnnotationUtils.getAnnotationValue((IModelElement)transmissionUnit, TransmissionUnitBandwidth.class, Double.class));
            BigDecimal duration = size.divide(bandwidth, 22, RoundingMode.HALF_EVEN);
            signalDuration.put((Signal)signal, duration);
        });
        return signalDuration;
    }

    public static Set<TransmissionUnit> getTransmissionUnits(ExplorationSpecification specification, Route route) {
        return specification.getSearchSpace().get(TransmissionUnit.class).getEntries().stream().filter(bus -> RouteUtils.busUsesRoute((TransmissionUnit)bus, (Route)route)).collect(Collectors.toSet());
    }

    public static Map<Signal, BigDecimal> extractSignalPeriods(ExplorationSpecification specification) {
        Map<Task, BigDecimal> taskPeriod = ExplorationSpecificationUtils.extractTaskPeriods(specification);
        HashMap<Signal, BigDecimal> signalPeriod = new HashMap<Signal, BigDecimal>();
        ExplorationSpecificationUtils.extractSignals(specification).forEach(signal -> {
            Task sender = signal.getSourceTaskPort().getTask();
            signalPeriod.put((Signal)signal, (BigDecimal)taskPeriod.get(sender));
        });
        return signalPeriod;
    }

    public static Collection<Signal> extractSignals(ExplorationSpecification specification) {
        return specification.getSearchSpace().get(Signal.class).getEntries();
    }

    public static Collection<ResourceAllocation> extractSingleRateResourceAllocations(ExplorationSpecification specification) {
        return specification.getSearchSpace().get(ResourceAllocation.class).getEntries();
    }

    public static Collection<Task> extractTasks(ExplorationSpecification specification) {
        return specification.getSearchSpace().get(Task.class).getEntries();
    }

    public static Collection<Route> extractRoutes(ExplorationSpecification specification) {
        return specification.getSearchSpace().get(Route.class).getEntries();
    }

    public static Map<Task, ExecutionUnit> extractTaskToExecutionUnitAllocation(ExplorationSpecification specification) {
        HashMap<Task, ExecutionUnit> taskAllocation = new HashMap<Task, ExecutionUnit>();
        ExplorationSpecificationUtils.extractTasks(specification).forEach(task -> {
            ExecutionUnit executionUnit = ExplorationSpecificationUtils.getExecutionUnit(specification, task);
            taskAllocation.put((Task)task, executionUnit);
        });
        return taskAllocation;
    }

    public static Map<Task, BigDecimal> extractTaskDurations(ExplorationSpecification specification) {
        HashMap<Task, BigDecimal> taskDuration = new HashMap<Task, BigDecimal>();
        ExplorationSpecificationUtils.extractTasks(specification).forEach(task -> {
            ResourceAllocation resourceAllocation = ExplorationSpecificationUtils.getSingleRateResourceAllocation(specification, task);
            if (resourceAllocation != null) {
                taskDuration.put((Task)task, resourceAllocation.getDuration());
            }
        });
        return taskDuration;
    }

    public static Map<Task, BigDecimal> extractTaskPeriods(ExplorationSpecification specification) {
        HashMap<Task, BigDecimal> taskPeriod = new HashMap<Task, BigDecimal>();
        ExplorationSpecificationUtils.extractTasks(specification).forEach(task -> {
            ResourceAllocation resourceAllocation = ExplorationSpecificationUtils.getSingleRateResourceAllocation(specification, task);
            if (resourceAllocation != null) {
                PeriodicTimeTrigger trigger = (PeriodicTimeTrigger)resourceAllocation.getTrigger();
                taskPeriod.put((Task)task, trigger.getPeriod());
            }
        });
        return taskPeriod;
    }

    public static ResourceAllocation getSingleRateResourceAllocation(ExplorationSpecification specification, Task task) {
        Optional<ResourceAllocation> optional = ExplorationSpecificationUtils.extractSingleRateResourceAllocations(specification).stream().filter(ra -> ra.getSchedulableEntity().getModelElement() == task).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static Collection<Partition> extractPartitions(ExplorationSpecification specification) {
        return specification.getSearchSpace().get(Partition.class).getEntries();
    }

    public static Partition getPartition(ExplorationSpecification specification, Task task) {
        EList taskToPartitionAllocations = specification.getSearchSpace().get(TaskToPartitionAllocationEntry.class).getEntries();
        return PartitionArchitectureUtils.getPartitionAllocation((Task)task, taskToPartitionAllocations);
    }

    public static Collection<ExecutionUnit> getExecutionUnits(ExplorationSpecification specification, Partition partition) {
        EList partitionToExecutionUnitAllocations = specification.getSearchSpace().get(PartitionToExecutionUnitAllocationEntry.class).getEntries();
        return PartitionArchitectureUtils.getExecutionUnitsAllocation((Partition)partition, partitionToExecutionUnitAllocations);
    }

    public static Map<Task, Partition> extractTaskToPartitionAllocation(ExplorationSpecification specification) {
        HashMap<Task, Partition> taskAllocation = new HashMap<Task, Partition>();
        ExplorationSpecificationUtils.extractTasks(specification).forEach(task -> {
            Partition partition = ExplorationSpecificationUtils.getPartition(specification, task);
            taskAllocation.put((Task)task, partition);
        });
        return taskAllocation;
    }

    public static Map<Partition, Collection<ExecutionUnit>> extractPartitionToExecutionUnitAllocation(ExplorationSpecification specification) {
        HashMap<Partition, Collection<ExecutionUnit>> partitionAllocation = new HashMap<Partition, Collection<ExecutionUnit>>();
        ExplorationSpecificationUtils.extractPartitions(specification).forEach(partition -> {
            Collection<ExecutionUnit> executionUnits = ExplorationSpecificationUtils.getExecutionUnits(specification, partition);
            partitionAllocation.put((Partition)partition, executionUnits);
        });
        return partitionAllocation;
    }
}

