/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.AF3ExplorationActivator;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Minus;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Plus;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.GreaterEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.LessEqual;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.ExplorationConstraint;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.project.SystemConstraintSet;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.timing.SignalReceiveEvent;
import org.fortiss.af3.task.model.timing.SignalSendEvent;
import org.fortiss.af3.task.model.timing.TaskStartEvent;
import org.fortiss.af3.task.model.timing.TaskTerminateEvent;
import org.fortiss.af3.timing.model.Event;
import org.fortiss.af3.timing.model.EventChain;
import org.fortiss.af3.timing.model.EventChainConstraint;
import org.fortiss.af3.timing.model.PeriodicConstraint;
import org.fortiss.af3.timing.model.ReactionConstraint;
import org.fortiss.af3.timing.model.SynchronizationConstraint;
import org.fortiss.af3.timing.model.TimingConstraint;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.utils.TimingModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ExplorationTimingConstraintUtils {
    public static final String START_TIME_IDENTIFIER = "VAR_StartTime";
    public static final String DURATION_IDENTIFIER = "VAR_Duration";

    public static SystemConstraintSet generateTimingConstraints(TimingSpecification ts, SuperSet<ResourceAllocation> resAllocSS) {
        SystemConstraintSet additionalConstraints = DSEProjectModelElementFactory.createSystemConstraintSet((IProjectRootElement)ts, "Additional Timing Constraints", "", "None");
        additionalConstraints.setImplicit(true);
        ExplorationTimingConstraintUtils.unrollSingleTaskPeriodConstraints(ts, resAllocSS);
        int i = 1;
        boolean periodDefined = false;
        for (TimingConstraint tc : ts.getConstraints()) {
            if (tc instanceof PeriodicConstraint) {
                periodDefined = true;
                PeriodicConstraint periodicConstraint = (PeriodicConstraint)tc;
                BigDecimal period = periodicConstraint.getPeriod();
                Event event = periodicConstraint.getEvent();
                Optional ra = LambdaUtils.getFirst(resAllocSS.getEntries(), r -> r.getSchedulableEntity().getModelElement() == event.getEntity());
                if (ra.isPresent()) {
                    ((PeriodicTimeTrigger)((ResourceAllocation)ra.get()).getTrigger()).setPeriod(period);
                }
                for (ResourceAllocation resAlloc : resAllocSS.getEntries()) {
                    ((PeriodicTimeTrigger)resAlloc.getTrigger()).setPeriod(period);
                }
                continue;
            }
            if (!(tc instanceof SynchronizationConstraint)) continue;
            List<IBooleanExpression> assertions = ExplorationTimingConstraintUtils.createSynchronizationConstraint(resAllocSS, (SynchronizationConstraint)tc);
            for (IBooleanExpression assertion : assertions) {
                ExplorationTimingConstraintUtils.createTimingConstraint(i, assertion, additionalConstraints, "Synchronization Constraint");
                ++i;
            }
        }
        if (!periodDefined) {
            throw new RuntimeException("The period of at least one task/signal must be specified.");
        }
        List<IBooleanExpression> assertions = ExplorationTimingConstraintUtils.createPeriodicConstraints(resAllocSS);
        i = 1;
        for (IBooleanExpression assertion : assertions) {
            ExplorationTimingConstraintUtils.createTimingConstraint(i, assertion, additionalConstraints, "Periodic Constraint");
            ++i;
        }
        i = 1;
        for (EventChain ec : ts.getEventChains()) {
            for (EventChainConstraint ecc : EcoreUtils.getChildrenWithType((EObject)ec, EventChainConstraint.class)) {
                if (!(ecc instanceof ReactionConstraint)) continue;
                IBooleanExpression assertion = ExplorationTimingConstraintUtils.createReactionConstraint(resAllocSS, (ReactionConstraint)ecc);
                ExplorationTimingConstraintUtils.createTimingConstraint(i, assertion, additionalConstraints, "Reaction Constraint");
                ++i;
            }
        }
        return additionalConstraints;
    }

    private static void unrollSingleTaskPeriodConstraints(TimingSpecification ts, SuperSet<ResourceAllocation> resAllocSS) {
        EList timingConstraints = ts.getConstraints();
        if (LambdaUtils.filterByType((Collection)timingConstraints, PeriodicConstraint.class).size() == 1) {
            PeriodicConstraint pConstr = (PeriodicConstraint)LambdaUtils.getFirst((Collection)timingConstraints, tc -> tc instanceof PeriodicConstraint).get();
            for (ResourceAllocation ra : resAllocSS.getEntries()) {
                IModelElement task = ra.getSchedulableEntity().getModelElement();
                if (task == pConstr.getEvent().getEntity()) continue;
                PeriodicConstraint duplPeriodConstr = (PeriodicConstraint)EcoreUtils.copy((EObject)pConstr);
                TaskStartEvent startEvt = (TaskStartEvent)TimingModelElementFactory.createEntityEvent(TaskStartEvent.class, (IModelElement)task);
                duplPeriodConstr.setEvent((Event)startEvt);
                timingConstraints.add(duplPeriodConstr);
                ts.getEventsContainer().getEvents().add((Object)startEvt);
            }
        }
    }

    private static IExplorationConstraint<Boolean> createTimingConstraint(int index, IBooleanExpression assertion, RuleSet ruleSet, String name) {
        ExplorationConstraint<Boolean> constraint = ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, ExplorationModelElementFactory.createTemporalDimension(), Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class}), assertion, name + " " + index, true);
        ruleSet.getExplorationTargets().add(constraint);
        return constraint;
    }

    public static List<IBooleanExpression> createPeriodicConstraints(SuperSet<ResourceAllocation> resAllocSS) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        for (ResourceAllocation ra : resAllocSS.getEntries()) {
            Set<ResourceAllocation> raSet = DSMLModelElementFactory.createSet(resAllocSS, ra, "aResourceAllocation", ResourceAllocation.class);
            ArithmeticPropertyLiteral<ResourceAllocation, Number> start = ExplorationTimingConstraintUtils.createStartTimeLiteral(raSet);
            ArithmeticPropertyLiteral<ResourceAllocation, Number> duration = ExplorationTimingConstraintUtils.createDurationLiteral(raSet);
            Plus end = DSMLModelElementFactory.createPlus(start, duration);
            ArithmeticLiteral period = DSMLModelElementFactory.createArithmeticLiteral(((PeriodicTimeTrigger)ra.getTrigger()).getPeriod());
            LessEqual lessEqual = DSMLModelElementFactory.createLessEqual(end, period);
            ForAll formula = DSMLModelElementFactory.createForAll(raSet, lessEqual, true);
            assertions.add(formula);
        }
        return assertions;
    }

    public static List<IBooleanExpression> createSynchronizationConstraint(SuperSet<ResourceAllocation> resAllocSS, SynchronizationConstraint constraint) {
        ArrayList<IBooleanExpression> assertions = new ArrayList<IBooleanExpression>();
        EList raList = resAllocSS.getEntries();
        EList eventList = constraint.getEvents();
        int i = 0;
        while (i < eventList.size()) {
            Event e1 = (Event)eventList.get(i);
            ResourceAllocation ra1 = ExplorationTimingConstraintUtils.extractResourceAllocation(raList, e1);
            if (ra1 != null) {
                int j = i + 1;
                while (j < eventList.size()) {
                    Event e2 = (Event)eventList.get(j);
                    ResourceAllocation ra2 = ExplorationTimingConstraintUtils.extractResourceAllocation(raList, e2);
                    if (ra2 != null) {
                        Set<ResourceAllocation> raSet1 = DSMLModelElementFactory.createSet(resAllocSS, ra1, "aResourceAllocation", ResourceAllocation.class);
                        Set<ResourceAllocation> raSet2 = DSMLModelElementFactory.createSet(resAllocSS, ra2, "bResourceAllocation", ResourceAllocation.class);
                        IArithmeticExpression time1 = ExplorationTimingConstraintUtils.createEventTimeLiteral(raSet1, e1);
                        IArithmeticExpression time2 = ExplorationTimingConstraintUtils.createEventTimeLiteral(raSet2, e2);
                        Minus minus = DSMLModelElementFactory.createMinus(time1, time2);
                        ArithmeticLiteral tolerance = DSMLModelElementFactory.createArithmeticLiteral(constraint.getTolerance());
                        LessEqual cond1 = DSMLModelElementFactory.createLessEqual(minus, tolerance);
                        IArithmeticExpression time1b = ExplorationTimingConstraintUtils.createEventTimeLiteral(raSet1, e1);
                        IArithmeticExpression time2b = ExplorationTimingConstraintUtils.createEventTimeLiteral(raSet2, e2);
                        Minus minusb = DSMLModelElementFactory.createMinus(time2b, time1b);
                        ArithmeticLiteral toleranceb = DSMLModelElementFactory.createArithmeticLiteral(constraint.getTolerance());
                        LessEqual cond2 = DSMLModelElementFactory.createLessEqual(minusb, toleranceb);
                        And conj = DSMLModelElementFactory.createAnd(cond1, cond2);
                        ForAll forAllRA2 = DSMLModelElementFactory.createForAll(raSet2, conj, true);
                        ForAll formula = DSMLModelElementFactory.createForAll(raSet1, forAllRA2, true);
                        assertions.add(formula);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return assertions;
    }

    private static ResourceAllocation extractResourceAllocation(EList<ResourceAllocation> raList, Event event) {
        IModelElement entity = ExplorationTimingConstraintUtils.extractEntity(event);
        if (entity == null) {
            LoggingUtils.error((Plugin)AF3ExplorationActivator.getDefault(), (String)("It is not possible to extract an entity for the event " + String.valueOf(event) + ". \n The reaction constraint has not been created."));
            return null;
        }
        ResourceAllocation resourceAllocation = (ResourceAllocation)LambdaUtils.getFirst(raList, ra -> ra == entity).get();
        return resourceAllocation;
    }

    public static IBooleanExpression createReactionConstraint(SuperSet<ResourceAllocation> resAllocSS, ReactionConstraint constraint) {
        EList raList = resAllocSS.getEntries();
        Event e1 = constraint.getEventChain().getStimulus();
        Event e2 = constraint.getEventChain().getResponse();
        ResourceAllocation ra1 = ExplorationTimingConstraintUtils.extractResourceAllocation(raList, e1);
        if (ra1 == null) {
            return null;
        }
        ResourceAllocation ra2 = ExplorationTimingConstraintUtils.extractResourceAllocation(raList, e2);
        if (ra2 == null) {
            return null;
        }
        Set<ResourceAllocation> raSet1 = DSMLModelElementFactory.createSet(resAllocSS, ra1, "aResourceAllocation", ResourceAllocation.class);
        Set<ResourceAllocation> raSet2 = DSMLModelElementFactory.createSet(resAllocSS, ra2, "bResourceAllocation", ResourceAllocation.class);
        IArithmeticExpression time1 = ExplorationTimingConstraintUtils.createEventTimeLiteral(raSet1, e1);
        IArithmeticExpression time2 = ExplorationTimingConstraintUtils.createEventTimeLiteral(raSet2, e2);
        Minus minus = DSMLModelElementFactory.createMinus(time2, time1);
        ArithmeticLiteral lower = DSMLModelElementFactory.createArithmeticLiteral(constraint.getMinimum());
        GreaterEqual cond1 = DSMLModelElementFactory.createGreaterEqual(minus, lower);
        IArithmeticExpression time1b = ExplorationTimingConstraintUtils.createEventTimeLiteral(raSet1, e1);
        IArithmeticExpression time2b = ExplorationTimingConstraintUtils.createEventTimeLiteral(raSet2, e2);
        Minus minusb = DSMLModelElementFactory.createMinus(time2b, time1b);
        ArithmeticLiteral upper = DSMLModelElementFactory.createArithmeticLiteral(constraint.getMaximum());
        LessEqual cond2 = DSMLModelElementFactory.createLessEqual(minusb, upper);
        And conj = DSMLModelElementFactory.createAnd(cond1, cond2);
        ForAll forAllRA2 = DSMLModelElementFactory.createForAll(raSet2, conj, true);
        ForAll formula = DSMLModelElementFactory.createForAll(raSet1, forAllRA2, true);
        return formula;
    }

    private static IModelElement extractEntity(Event event) {
        if (event instanceof SignalReceiveEvent && event.getEntity() instanceof TaskInputPort) {
            TaskInputPort taskInputPort = (TaskInputPort)event.getEntity();
            if (taskInputPort.getIncomingSignal() != null) {
                return taskInputPort.getIncomingSignal().getSourceTaskPort();
            }
        } else {
            return event.getEntity();
        }
        return null;
    }

    public static IArithmeticExpression createEventTimeLiteral(Set<ResourceAllocation> set, Event event) {
        if (event instanceof TaskStartEvent || event instanceof SignalSendEvent) {
            return ExplorationTimingConstraintUtils.createStartTimeLiteral(set);
        }
        if (event instanceof TaskTerminateEvent || event instanceof SignalReceiveEvent) {
            ArithmeticPropertyLiteral<ResourceAllocation, Number> start = ExplorationTimingConstraintUtils.createStartTimeLiteral(set);
            ArithmeticPropertyLiteral<ResourceAllocation, Number> duration = ExplorationTimingConstraintUtils.createDurationLiteral(set);
            return DSMLModelElementFactory.createPlus(start, duration);
        }
        return null;
    }

    public static ArithmeticPropertyLiteral<ResourceAllocation, Number> createStartTimeLiteral(Set<ResourceAllocation> set) {
        return DSMLModelElementFactory.createArithmeticPropertyLiteral(set, t -> BigDecimal.ZERO, START_TIME_IDENTIFIER);
    }

    public static ArithmeticPropertyLiteral<ResourceAllocation, Number> createDurationLiteral(Set<ResourceAllocation> set) {
        return DSMLModelElementFactory.createArithmeticPropertyLiteral(set, t -> BigDecimal.ZERO, DURATION_IDENTIFIER);
    }
}

