/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.IInputArtifact;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.ProjectPackage;
import org.fortiss.af3.exploration.model.project.RuleSet;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.model.synthesiscategory.ISynthesisCategory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class ExplorationUtils {
    private static final String DSE_DEBUG_VERBOSE_ENV_VAR = "DSE_DEBUG_VERBOSE";
    private static final String DSE_DUMP_TESTGEN_GRAPHMETRICS_ENV_VAR = "DSE_DUMP_TESTGEN_GRAPHMETRICS";

    public static boolean isDebugVerboseEnabled() {
        return Boolean.valueOf(System.getenv(DSE_DEBUG_VERBOSE_ENV_VAR));
    }

    public static boolean isDumpTestgenGraphmetricsEnabled() {
        return Boolean.valueOf(System.getenv(DSE_DUMP_TESTGEN_GRAPHMETRICS_ENV_VAR));
    }

    public static <T> T recursiveTreeWalk(ProcessStep processStep, BiConsumer<ProcessStep, T> aggregateFunction, T collectedElements) {
        if (processStep == null) {
            return collectedElements;
        }
        ExplorationUtils.recursiveTreeWalk(processStep.getParent(), aggregateFunction, collectedElements);
        aggregateFunction.accept(processStep, (ProcessStep)collectedElements);
        return collectedElements;
    }

    public static <T> EList<T> recursiveArtifactWalk(ProcessStep processStep, final BiConsumer<IInputArtifact, EList<T>> aggregateFunction, EList<T> collectedElements) {
        BiConsumer listSearch = new BiConsumer<ProcessStep, EList<T>>(){

            @Override
            public void accept(ProcessStep processStep, EList<T> collectedElements) {
                EReference modelSnapFeature = ProjectPackage.Literals.ARTIFACT_SNAPSHOT_COLLECTION__CONTAINED_MODEL_SNAPSHOTS;
                for (ModelSnapshot thisSnapshot : (Collection)processStep.eGet((EStructuralFeature)modelSnapFeature)) {
                    aggregateFunction.accept(thisSnapshot, collectedElements);
                }
            }
        };
        ExplorationUtils.recursiveTreeWalk(processStep, listSearch, collectedElements);
        return collectedElements;
    }

    public static List<SingleExplorationSolution> getSelectedSolutions(ProcessStep processStep) {
        BiConsumer<ProcessStep, Collection<SingleExplorationSolution>> listSearch = new BiConsumer<ProcessStep, Collection<SingleExplorationSolution>>(){

            @Override
            public void accept(ProcessStep processStep, Collection<SingleExplorationSolution> collectedSolutions) {
                if (processStep instanceof SolutionSelectionStep) {
                    SolutionSelectionStep solStep = (SolutionSelectionStep)processStep;
                    collectedSolutions.add(solStep.getSelectedSolution());
                }
            }
        };
        ArrayList<SingleExplorationSolution> expSolutions = new ArrayList<SingleExplorationSolution>();
        ExplorationUtils.recursiveTreeWalk(processStep, listSearch, expSolutions);
        return expSolutions;
    }

    public static <T extends IModelElement> SuperSetMap getSelectedSolutionSets(ProcessStep processStep) {
        List<SingleExplorationSolution> expSolutions = ExplorationUtils.getSelectedSolutions(processStep);
        SuperSetMap aggregateSolutionSets = ExplorationModelElementFactory.createSuperSetMap();
        expSolutions.forEach(sol -> sol.getAvailableSolutionModels().forEach(sType -> {
            if (!aggregateSolutionSets.containsKey((Class<?>)sType)) {
                Class castedType = sType;
                aggregateSolutionSets.put(castedType, sol.getSolutionModel(castedType));
            }
        }));
        return aggregateSolutionSets;
    }

    public static EList<IProjectRootElement> getRootElementsFromSnaps(ProcessStep processStep, Collection<Class<? extends IProjectRootElement>> seekElementTypes) {
        final Collection<Class<? extends IProjectRootElement>> internalSeekTypes = seekElementTypes;
        BasicEList collectedElements = new BasicEList();
        BiConsumer<IInputArtifact, EList<IProjectRootElement>> getSeekElementsElements = new BiConsumer<IInputArtifact, EList<IProjectRootElement>>(){

            @Override
            public void accept(IInputArtifact thisArtifact, EList<IProjectRootElement> collectedElements) {
                IProjectRootElement rootElement;
                if (thisArtifact instanceof ModelSnapshot && LambdaUtils.isAssignableFromAny((Collection)internalSeekTypes, (Object)(rootElement = ((ModelSnapshot)thisArtifact).getRootElement()))) {
                    collectedElements.add((Object)rootElement);
                }
            }
        };
        ExplorationUtils.recursiveArtifactWalk(processStep, getSeekElementsElements, collectedElements);
        return collectedElements;
    }

    public static <S extends IModelElement> void appendNonPresentSolutionSets(SingleExplorationSolution selectedSolution, SuperSetMap collectedElements) {
        EList<Class<? extends IModelElement>> availSolutions = selectedSolution.getAvailableSolutionModels();
        for (Class solType : availSolutions) {
            if (collectedElements.containsKey(solType)) continue;
            SuperSet currSol = selectedSolution.getSolutionModel(solType);
            collectedElements.put(solType, currSol);
        }
    }

    public static IStatus createExceptionStatus(Exception e, String launcherPluginID, String title) {
        Status status = new Status(4, launcherPluginID, "Error executing " + title + ".", (Throwable)e);
        status = ExplorationUtils.tryCreateMultiStatusException((IStatus)status);
        if (ExplorationUtils.isDebugVerboseEnabled()) {
            e.printStackTrace();
        }
        return status;
    }

    public static IStatus tryCreateMultiStatusException(IStatus status) {
        Throwable t = status.getException();
        if (t != null) {
            StackTraceElement[] stackTraces = status.getException().getStackTrace();
            Stream<Status> childStatuses = Arrays.stream(stackTraces).map(tr -> new Status(4, status.getPlugin(), tr.toString()));
            return new MultiStatus(status.getPlugin(), status.getSeverity(), (IStatus[])childStatuses.toArray(Status[]::new), status.getMessage(), t);
        }
        return status;
    }

    public static Collection<IExplorationTarget<?>> convertRuleSetsToExplorationSpec(Collection<RuleSet> ruleSets, Collection<Class<? extends ISynthesisCategory>> synthCategory) {
        ArrayList expTargets = new ArrayList();
        ruleSets.forEach(rS -> rS.getExplorationTargets().stream().filter(eT -> synthCategory.containsAll((Collection<?>)eT.getSynthesisCategories())).forEach(eT -> {
            boolean bl = expTargets.add((IExplorationTarget<?>)eT);
        }));
        return expTargets;
    }
}

