/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.model.ManyToOneAllocationEntry;
import org.fortiss.af3.allocation.model.OneToManyAllocationEntry;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.project.SystemConstraintSet;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationScheduleUtils;
import org.fortiss.af3.exploration.util.ExplorationTimingConstraintUtils;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.function.model.Function;
import org.fortiss.af3.function.model.FunctionArchitecture;
import org.fortiss.af3.partition.model.Partition;
import org.fortiss.af3.partition.model.PartitionArchitecture;
import org.fortiss.af3.partition.model.PartitionChannel;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.GatewayUnit;
import org.fortiss.af3.platform.model.MemoryUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionConnection;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.af3.platform.utils.RouteUtils;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskMemoryAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskWcetTable;
import org.fortiss.af3.task.util.TaskArchitectureUtils;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class ModelSnapshotExtractUtils {
    private ModelSnapshotExtractUtils() {
    }

    private static <T extends IHierarchicElement> SuperSet<T> getFilteredElementSuperSet(Collection<T> elements, Collection<T> elementFilter, String name, Class<T> type) {
        Collection filteredElements = elementFilter != null ? (Collection)elements.stream().filter(elementFilter::contains).collect(Collectors.toList()) : elements;
        return DSMLModelElementFactory.createSuperSet(filteredElements, name, type);
    }

    private static <T extends IConnection> SuperSet<T> getFilteredConnectionSuperSet(Collection<T> connections, Collection<? extends IHierarchicElement> elementFilter, String name, Class<T> type) {
        Collection filteredConnections = elementFilter != null ? (Collection)connections.stream().filter(s -> elementFilter.contains(s.getSource().getOwner()) && elementFilter.contains(s.getTarget().getOwner())).collect(Collectors.toList()) : connections;
        return DSMLModelElementFactory.createSuperSet(filteredConnections, name, type);
    }

    private static Collection<IModelElement> getRouteEntities(Route route) {
        List entities = route.getAllSegments().stream().map(s -> s.getEntity()).collect(Collectors.toCollection(ArrayList::new));
        entities.add(route.getSenderExecutionUnit());
        entities.addAll(route.getReceiverExecutionUnits());
        return entities;
    }

    private static SuperSet<Route> getFilteredRouteSuperSet(Collection<Route> routes, Collection<IHierarchicElement> filter, String name) {
        Predicate<Route> filterContainsAllEntities = r -> filter.containsAll(ModelSnapshotExtractUtils.getRouteEntities(r));
        Collection filteredRoutes = filter != null ? (Collection)routes.stream().filter(filterContainsAllEntities).collect(Collectors.toList()) : routes;
        return DSMLModelElementFactory.createSuperSet(filteredRoutes, name, Route.class);
    }

    public static ModelSnapshot createTaskArchitectureSnapshot(TaskArchitecture taskArch, List<Task> taskFilter) {
        TaskMemoryAllocationTable memAllocTable;
        SuperSetMap superSetMap = ExplorationModelElementFactory.createSuperSetMap();
        SuperSet<Task> taskSS = ModelSnapshotExtractUtils.getFilteredElementSuperSet(taskArch.getTasks(), taskFilter, "Tasks", Task.class);
        superSetMap.put(Task.class, taskSS);
        SuperSet<Signal> signalSS = ModelSnapshotExtractUtils.getFilteredConnectionSuperSet(taskArch.getSignals(), taskFilter, "Signals", Signal.class);
        superSetMap.put(Signal.class, signalSS);
        ModelSnapshotExtractUtils.pruneLinkedConnections(taskSS, signalSS);
        TaskWcetTable wcetTable = taskArch.getWcetTable();
        if (wcetTable != null) {
            SuperSet<TaskWcetTable> wcetSet = DSMLModelElementFactory.createSuperSet(Arrays.asList(wcetTable), "Task WCETs", TaskWcetTable.class);
            superSetMap.put(TaskWcetTable.class, wcetSet);
        }
        if ((memAllocTable = taskArch.getMemoryAllocationTable()) != null) {
            SuperSet<TaskMemoryAllocationTable> memAllocSet = DSMLModelElementFactory.createSuperSet(Arrays.asList(memAllocTable), "Task Memory locations", TaskMemoryAllocationTable.class);
            superSetMap.put(TaskMemoryAllocationTable.class, memAllocSet);
        }
        return DSEProjectModelElementFactory.createModelSnapshot((IProjectRootElement)taskArch, superSetMap);
    }

    public static ModelSnapshot createTaskArchitectureSnapshot(TaskArchitecture taskArch) {
        return ModelSnapshotExtractUtils.createTaskArchitectureSnapshot(taskArch, null);
    }

    public static ModelSnapshot createPlatformArchitectureSnapshot(PlatformArchitecture platArch, List<IHierarchicElement> elementFilter) {
        Collection allExUnits = TaskArchitectureUtils.findTargetExecutionUnits((PlatformArchitecture)platArch);
        SuperSet<ExecutionUnit> exUnitSS = ModelSnapshotExtractUtils.getFilteredElementSuperSet(allExUnits, EcoreUtils.pickInstanceOf(ExecutionUnit.class, elementFilter), "ExecUnits", ExecutionUnit.class);
        List allTmUnits = PlatformArchitectureUtils.findAtomicTransmissionUnits((PlatformArchitecture)platArch);
        SuperSet<TransmissionUnit> tmUnitSS = ModelSnapshotExtractUtils.getFilteredElementSuperSet(allTmUnits, EcoreUtils.pickInstanceOf(TransmissionUnit.class, elementFilter), "TransUnits", TransmissionUnit.class);
        List allGwUnits = PlatformArchitectureUtils.findAllGatewayUnits((PlatformArchitecture)platArch);
        SuperSet<GatewayUnit> gwUnitSS = ModelSnapshotExtractUtils.getFilteredElementSuperSet(allGwUnits, EcoreUtils.pickInstanceOf(GatewayUnit.class, elementFilter), "GWUnits", GatewayUnit.class);
        SuperSet<MemoryUnit> memUnitSS = ModelSnapshotExtractUtils.getFilteredElementSuperSet(PlatformArchitectureUtils.findAllMemoryUnits((PlatformArchitecture)platArch), EcoreUtils.pickInstanceOf(MemoryUnit.class, elementFilter), "MemUnits", MemoryUnit.class);
        SuperSet<TransmissionConnection> platConSS = ModelSnapshotExtractUtils.getFilteredConnectionSuperSet(PlatformArchitectureUtils.findAllTransmissionConnections((PlatformArchitecture)platArch), elementFilter, "Connections", TransmissionConnection.class);
        platArch.getRoutes().clear();
        List allPlatformRoutes = RouteUtils.extractRoutes(exUnitSS.getEntries(), tmUnitSS.getEntries(), gwUnitSS.getEntries());
        platArch.getRoutes().addAll((Collection)allPlatformRoutes);
        UniqueIDUtils.generateMissingIDs((EObject)platArch, (int)UniqueIDUtils.getLargestID((EObject)platArch));
        SuperSet<Route> routeSS = ModelSnapshotExtractUtils.getFilteredRouteSuperSet(allPlatformRoutes, (Collection<IHierarchicElement>)EcoreUtils.pickInstanceOf(Arrays.asList(ExecutionUnit.class, TransmissionUnit.class, GatewayUnit.class), elementFilter), "Routes");
        SuperSetMap superSetMap = ExplorationModelElementFactory.createSuperSetMap();
        ModelSnapshotExtractUtils.pruneLinkedConnections(exUnitSS, platConSS);
        superSetMap.put(ExecutionUnit.class, exUnitSS);
        ModelSnapshotExtractUtils.pruneLinkedConnections(tmUnitSS, platConSS);
        superSetMap.put(TransmissionUnit.class, tmUnitSS);
        ModelSnapshotExtractUtils.pruneLinkedConnections(gwUnitSS, platConSS);
        superSetMap.put(GatewayUnit.class, gwUnitSS);
        ModelSnapshotExtractUtils.pruneLinkedConnections(memUnitSS, platConSS);
        superSetMap.put(MemoryUnit.class, memUnitSS);
        superSetMap.put(TransmissionConnection.class, platConSS);
        superSetMap.put(Route.class, routeSS);
        return DSEProjectModelElementFactory.createModelSnapshot((IProjectRootElement)platArch, superSetMap);
    }

    public static ModelSnapshot createPlatformArchitectureSnapshot(PlatformArchitecture platArch) {
        return ModelSnapshotExtractUtils.createPlatformArchitectureSnapshot(platArch, null);
    }

    public static ModelSnapshot createDataDictionarySnapshot(DataDictionary dictionary) {
        return DSEProjectModelElementFactory.createModelSnapshot((IProjectRootElement)dictionary, null);
    }

    public static ModelSnapshot createPartitionArchitectureSnapshot(PartitionArchitecture partArch, List<Partition> partitionFilter) {
        SuperSetMap superSetMap = ExplorationModelElementFactory.createSuperSetMap();
        SuperSet<Partition> partSS = ModelSnapshotExtractUtils.getFilteredElementSuperSet(partArch.getPartitions(), partitionFilter, "Partitions", Partition.class);
        superSetMap.put(Partition.class, partSS);
        SuperSet<PartitionChannel> partChanSS = ModelSnapshotExtractUtils.getFilteredConnectionSuperSet(partArch.getPartitionChannels(), partitionFilter, "Channels", PartitionChannel.class);
        superSetMap.put(PartitionChannel.class, partChanSS);
        ModelSnapshotExtractUtils.pruneLinkedConnections(partSS, partChanSS);
        return DSEProjectModelElementFactory.createModelSnapshot((IProjectRootElement)partArch, superSetMap);
    }

    public static ModelSnapshot createPartitionArchitectureSnapshot(PartitionArchitecture partArch) {
        return ModelSnapshotExtractUtils.createPartitionArchitectureSnapshot(partArch, null);
    }

    public static ModelSnapshot createComponentArchitectureSnapshot(ComponentArchitecture compArch, List<Component> compFilter) {
        SuperSetMap superSetMap = ExplorationModelElementFactory.createSuperSetMap();
        SuperSet<Component> compSS = ModelSnapshotExtractUtils.getFilteredElementSuperSet(ModelSnapshotExtractUtils.getComponents(compArch), compFilter, "Components", Component.class);
        superSetMap.put(Component.class, compSS);
        SuperSet<Channel> channelSS = ModelSnapshotExtractUtils.getFilteredConnectionSuperSet(ModelSnapshotExtractUtils.getChannels(compArch), compFilter, "Channels", Channel.class);
        superSetMap.put(Channel.class, channelSS);
        ModelSnapshotExtractUtils.pruneLinkedConnections(compSS, channelSS);
        return DSEProjectModelElementFactory.createModelSnapshot((IProjectRootElement)compArch, superSetMap);
    }

    private static <T extends IHierarchicElement, U extends IConnection> void pruneLinkedConnections(SuperSet<T> elemSS, SuperSet<U> connectionSS) {
        for (IHierarchicElement elem : elemSS.getEntries()) {
            for (IConnector connector : elem.getConnectors()) {
                connector.getIncoming().removeIf(con -> !connectionSS.getEntries().contains(con));
                connector.getOutgoing().removeIf(con -> !connectionSS.getEntries().contains(con));
            }
        }
    }

    public static ModelSnapshot createComponentArchitectureSnapshot(ComponentArchitecture compArch) {
        return ModelSnapshotExtractUtils.createComponentArchitectureSnapshot(compArch, null);
    }

    private static List<Component> getComponents(ComponentArchitecture compArch) {
        return EcoreUtils.getChildrenWithType((EObject)compArch, Component.class);
    }

    private static List<Channel> getChannels(ComponentArchitecture compArch) {
        return EcoreUtils.getChildrenWithType((EObject)compArch, Channel.class);
    }

    public static ModelSnapshot createFunctionArchitectureSnapshot(FunctionArchitecture funcArch, List<Function> funFilter) {
        SuperSetMap superSetMap = ExplorationModelElementFactory.createSuperSetMap();
        superSetMap.put(Function.class, ModelSnapshotExtractUtils.getFilteredElementSuperSet(ModelSnapshotExtractUtils.getFunctions(funcArch), funFilter, "Functions", Function.class));
        return DSEProjectModelElementFactory.createModelSnapshot((IProjectRootElement)funcArch, superSetMap);
    }

    private static List<Function> getFunctions(FunctionArchitecture funcArch) {
        return EcoreUtils.getChildrenWithType((EObject)funcArch, Function.class);
    }

    public static ModelSnapshot createAllocationTableCollectionSnapshot(AllocationTableCollection allocTableColl, Collection<Class<? extends AllocationEntry>> relevantTypes, Collection<ModelSnapshot> prevSnaps) {
        SuperSetMap superSetMap = ExplorationModelElementFactory.createSuperSetMap();
        for (AllocationTable allocationTable : allocTableColl.getAllocationTables()) {
            EList allocationEntries = allocationTable.getAllocationEntries();
            for (Class<? extends AllocationEntry> type : relevantTypes) {
                ModelSnapshotExtractUtils.addAllocationTableEntriesToSuperSetMap(superSetMap, (Collection<? extends AllocationEntry>)allocationEntries, type, prevSnaps);
            }
        }
        return DSEProjectModelElementFactory.createModelSnapshot((IProjectRootElement)allocTableColl, superSetMap);
    }

    private static <T extends AllocationEntry> void addAllocationTableEntriesToSuperSetMap(SuperSetMap superSetMap, Collection<? extends AllocationEntry> allocationEntries, Class<T> type, Collection<ModelSnapshot> prevSnaps) {
        SuperSet<T> allocationEntriesSuperSet = DSMLModelElementFactory.createSuperSet("Allocations", type);
        IAllocationService as = IAllocationService.getInstance();
        List<Object> allSrcElements = ModelSnapshotExtractUtils.getElements(prevSnaps, as.getSourceEntityTypes(type));
        List<Object> allTgtElements = ModelSnapshotExtractUtils.getElements(prevSnaps, as.getTargetEntityTypes(type));
        for (AllocationEntry ae : LambdaUtils.filterByType(allocationEntries, type)) {
            ArrayList unmatchedSourceElements = new ArrayList(AllocationUtils.getSourceElements((AllocationEntry)ae));
            unmatchedSourceElements.removeAll(allSrcElements);
            ArrayList unmatchedTargetElements = new ArrayList(AllocationUtils.getTargetElements((AllocationEntry)ae));
            unmatchedTargetElements.removeAll(allTgtElements);
            if (unmatchedSourceElements.isEmpty() && unmatchedTargetElements.isEmpty()) {
                allocationEntriesSuperSet.getEntries().add((Object)ae);
                continue;
            }
            if (ae instanceof OneToManyAllocationEntry && unmatchedSourceElements.isEmpty()) {
                EList targetElements = ((OneToManyAllocationEntry)ae).getTargetElements();
                targetElements.removeAll(unmatchedTargetElements);
                if (targetElements.isEmpty()) continue;
                allocationEntriesSuperSet.getEntries().add((Object)ae);
                continue;
            }
            if (!(ae instanceof ManyToOneAllocationEntry) || !unmatchedTargetElements.isEmpty()) continue;
            EList sourceElements = ((ManyToOneAllocationEntry)ae).getSourceElements();
            sourceElements.removeAll(unmatchedSourceElements);
            if (sourceElements.isEmpty()) continue;
            allocationEntriesSuperSet.getEntries().add((Object)ae);
        }
        if (!allocationEntriesSuperSet.getEntries().isEmpty()) {
            superSetMap.put(type, allocationEntriesSuperSet);
        }
    }

    private static List<Object> getElements(Collection<ModelSnapshot> prevSnaps, Collection<Class<? extends IModelElement>> entityTypes) {
        List<Object> allSrcElements = prevSnaps.stream().flatMap(snap -> {
            Predicate<SuperSet> predicate = ss -> entityTypes.stream().anyMatch(set -> ss.getEntryType().isAssignableFrom((Class<?>)set));
            return snap.getContainedSuperSets().stream().filter(predicate).flatMap(ss -> ss.getEntries().stream());
        }).collect(Collectors.toList());
        return allSrcElements;
    }

    public static ModelSnapshot createTimingSpecificationSnapshot(Optional<SuperSet<TaskToExecutionUnitAllocationEntry>> ta2hw, SuperSet<Task> taskSet, SuperSet<Route> routeSuperSet, Optional<SuperSet<SignalToRouteAllocationEntry>> s2rSetIn, TimingSpecification timingSpec) {
        SuperSetMap superSetMap = ExplorationModelElementFactory.createSuperSetMap();
        SystemConstraintSet timingConstraintSet = null;
        ArrayList<IModelElement> containments = new ArrayList<IModelElement>();
        if (!ta2hw.isPresent()) {
            SuperSet<ResourceAllocation> raSet = ExplorationScheduleUtils.createResourceAllocations(taskSet, timingSpec);
            superSetMap.put(ResourceAllocation.class, raSet);
            containments.addAll((Collection<IModelElement>)raSet.getEntries());
            timingConstraintSet = ExplorationTimingConstraintUtils.generateTimingConstraints(timingSpec, raSet);
        } else {
            superSetMap = ExplorationScheduleUtils.constructSchedulableEntities(ta2hw, routeSuperSet, s2rSetIn, timingSpec, containments);
            timingConstraintSet = ExplorationTimingConstraintUtils.generateTimingConstraints(timingSpec, superSetMap.get(ResourceAllocation.class));
        }
        return DSEProjectModelElementFactory.createModelSnapshot((IProjectRootElement)timingSpec, superSetMap, timingConstraintSet, containments);
    }
}

