/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Enumerator;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.ArithmeticPropertyLiteral;
import org.fortiss.af3.exploration.dseml.model.arithmetic.IArithmeticExpression;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Mul;
import org.fortiss.af3.exploration.dseml.model.arithmetic.Sum;
import org.fortiss.af3.exploration.dseml.model.booleanp.And;
import org.fortiss.af3.exploration.dseml.model.booleanp.Exists;
import org.fortiss.af3.exploration.dseml.model.booleanp.ForAll;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.IQuantifierExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.Implies;
import org.fortiss.af3.exploration.dseml.model.booleanp.Or;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.Allocation;
import org.fortiss.af3.exploration.dseml.model.booleanp.allocation.ILocationExpression;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.Equal;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.LessEqual;
import org.fortiss.af3.exploration.dseml.model.booleanp.comparison.NotEqual;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.ModelElementLiteral;
import org.fortiss.af3.exploration.dseml.model.expression.Set;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.Uses;
import org.fortiss.af3.exploration.dseml.model.function.Weight;
import org.fortiss.af3.exploration.lang.Function;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.model.annotation.MessageSize;
import org.fortiss.af3.platform.utils.RouteUtils;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.INamedElement;

public class PatternFactoryUtils {
    static int MAX_ALLOC_SIZE_PER_SIDE = 50;

    public static IExpression createRouteWeightConstraintPatternExpression(DSE dse) {
        SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
        Set<Route> setRoute = DSMLModelElementFactory.createSet(superSetMap.get(Route.class), superSetMap.get(Route.class).getEntries(), "Route", Route.class);
        Set<Signal> signalSet = DSMLModelElementFactory.createSet(superSetMap.get(Signal.class), superSetMap.get(Signal.class).getEntries(), "Signals", Signal.class);
        ModelElementLiteral signal = DSMLModelElementFactory.createModelElementLiteral(signalSet);
        ModelElementLiteral route = DSMLModelElementFactory.createModelElementLiteral(setRoute);
        ModelElementLiteral route2 = DSMLModelElementFactory.createModelElementLiteral(setRoute);
        Weight routeWeight = DSMLModelElementFactory.createWeight(route);
        Allocation allocation = DSMLModelElementFactory.createAllocation(signal, route2);
        Map<Integer, Integer> sigSizeMap = PatternFactoryUtils.createSignalSizeMap(signalSet);
        ArithmeticPropertyLiteral bandwidth = DSMLModelElementFactory.createArithmeticPropertyLiteral(signalSet, s -> (Number)sigSizeMap.get(s.getId()), "Signal Size");
        Sum sum = DSMLModelElementFactory.createSum(signalSet.getCastedSet(IModelElement.class), allocation, bandwidth);
        Equal equals = DSMLModelElementFactory.createEquals(routeWeight, sum);
        return DSMLModelElementFactory.createForAll(setRoute.getCastedSet(IModelElement.class), equals, false);
    }

    private static Map<Integer, Integer> createSignalSizeMap(Set<Signal> signalSet) {
        HashMap<Integer, Integer> sizeMap = new HashMap<Integer, Integer>();
        for (Signal sig : signalSet.getEntries()) {
            TaskOutputPort port = sig.getSourceTaskPort();
            Integer sigSize = (Integer)AnnotationUtils.getAnnotationValue((IModelElement)port, MessageSize.class, Integer.class);
            sizeMap.put(sig.getId(), sigSize);
        }
        return sizeMap;
    }

    public static IBooleanExpression createRouteUsesBusConstraintPatternExpression(DSE dse, TransmissionUnit bus, Route route) {
        SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
        Set<Route> routeSet = DSMLModelElementFactory.createSet(superSetMap.get(Route.class), route, "Route", Route.class);
        Set<TransmissionUnit> busSet = DSMLModelElementFactory.createSet(superSetMap.get(TransmissionUnit.class), bus, "Bus", TransmissionUnit.class);
        ModelElementLiteral arg0 = DSMLModelElementFactory.createModelElementLiteral(routeSet);
        ModelElementLiteral arg1 = DSMLModelElementFactory.createModelElementLiteral(busSet);
        Uses createUses = DSMLModelElementFactory.createUses(arg0, arg1);
        Equal createEquals = DSMLModelElementFactory.createEquals(createUses, DSMLModelElementFactory.createBooleanLiteral(RouteUtils.busUsesRoute((TransmissionUnit)bus, (Route)route)));
        ForAll forAll2 = DSMLModelElementFactory.createForAll(busSet.getCastedSet(IModelElement.class), createEquals, true);
        ForAll forAll1 = DSMLModelElementFactory.createForAll(routeSet.getCastedSet(IModelElement.class), forAll2, true);
        return forAll1;
    }

    public static IExpression createBusWeightOptimizationPatternExpression(DSE dse, TransmissionUnit bus, boolean minimize) {
        SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
        Set<Route> setRoute = DSMLModelElementFactory.createSet(superSetMap.get(Route.class), superSetMap.get(Route.class).getEntries(), "Routes", Route.class);
        Set<Signal> signalSet = DSMLModelElementFactory.createSet(superSetMap.get(Signal.class), superSetMap.get(Signal.class).getEntries(), "Signals", Signal.class);
        Set<TransmissionUnit> busSet = DSMLModelElementFactory.createSet(superSetMap.get(TransmissionUnit.class), bus, "Bus", TransmissionUnit.class);
        ModelElementLiteral busLiteral = DSMLModelElementFactory.createModelElementLiteral(busSet);
        ModelElementLiteral signalLiteral = DSMLModelElementFactory.createModelElementLiteral(signalSet);
        ModelElementLiteral routeLiteral1 = DSMLModelElementFactory.createModelElementLiteral(setRoute);
        ModelElementLiteral routeLiteral2 = DSMLModelElementFactory.createModelElementLiteral(setRoute);
        Uses createUses = DSMLModelElementFactory.createUses(routeLiteral1, busLiteral);
        Allocation signalAllocation = DSMLModelElementFactory.createAllocation(signalLiteral, routeLiteral2);
        ForAll forAllBuses = DSMLModelElementFactory.createForAll(busSet.getCastedSet(IModelElement.class), createUses, true);
        Exists existsSignal = DSMLModelElementFactory.createExists(signalSet.getCastedSet(IModelElement.class), signalAllocation, true);
        And and = DSMLModelElementFactory.createAnd(forAllBuses, existsSignal);
        ModelElementLiteral route = DSMLModelElementFactory.createModelElementLiteral(setRoute);
        Weight routeWeight = DSMLModelElementFactory.createWeight(route);
        Sum sum = DSMLModelElementFactory.createSum(setRoute.getCastedSet(IModelElement.class), and, routeWeight);
        if (minimize) {
            return DSMLModelElementFactory.createMinimize(sum);
        }
        return DSMLModelElementFactory.createMaximize(sum);
    }

    public static IExpression createHardwareOptimizationPatternExpression(DSE dse, boolean isMinimize, int operation, Collection<Task> tasks, Collection<ExecutionUnit> executionUnits, Class<? extends IAnnotatedSpecification> property) {
        SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
        Set<Task> swcs = DSMLModelElementFactory.createSet(superSetMap.get(Task.class), "SoftwareComponents", Task.class);
        Set<ExecutionUnit> hwcs = DSMLModelElementFactory.createSet(superSetMap.get(ExecutionUnit.class), "HardwareComponents", ExecutionUnit.class);
        Exists existQuantifier = DSMLModelElementFactory.createExists();
        existQuantifier.setUnfold(true);
        swcs.getEntries().addAll(tasks);
        hwcs.getEntries().addAll(executionUnits);
        ModelElementLiteral swc = DSMLModelElementFactory.createModelElementLiteral(swcs.getCastedSet(IModelElement.class));
        ModelElementLiteral hwc = DSMLModelElementFactory.createModelElementLiteral(hwcs.getCastedSet(IModelElement.class));
        Allocation le = DSMLModelElementFactory.createAllocation(swc, hwc);
        existQuantifier.setExpression(le);
        existQuantifier.setSet(swcs.getCastedSet(IModelElement.class));
        IArithmeticExpression term = operation == 0 ? DSMLModelElementFactory.createAnnotationArithPropLit(hwcs.getCastedSet(IModelElement.class), property) : DSMLModelElementFactory.createArithmeticLiteral(BigDecimal.ONE);
        Sum sum = DSMLModelElementFactory.createSum(hwcs.getCastedSet(IModelElement.class), existQuantifier, term);
        return isMinimize ? DSMLModelElementFactory.createMinimize(sum) : DSMLModelElementFactory.createMaximize(sum);
    }

    public static IBooleanExpression createUtilizationPatternExpression(DSE dse, double value, ExecutionUnit executionUnit, Class<? extends IAnnotatedSpecification> taskSpec, Class<? extends IAnnotatedSpecification> ecuSpec) {
        SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
        Set<Task> swcs = DSMLModelElementFactory.createSet(superSetMap.get(Task.class), "Tasks", Task.class);
        Set<ExecutionUnit> hwcs = DSMLModelElementFactory.createSet(superSetMap.get(ExecutionUnit.class), "HardwareComponents", ExecutionUnit.class);
        swcs.getEntries().addAll(superSetMap.get(Task.class).getEntries());
        hwcs.getEntries().add((Object)executionUnit);
        ModelElementLiteral swc = DSMLModelElementFactory.createModelElementLiteral(swcs.getCastedSet(IModelElement.class));
        ModelElementLiteral hwc = DSMLModelElementFactory.createModelElementLiteral(hwcs.getCastedSet(IModelElement.class));
        Allocation predicate = DSMLModelElementFactory.createAllocation(swc, hwc);
        ArithmeticPropertyLiteral swcProperty = DSMLModelElementFactory.createAnnotationArithPropLit(swcs, taskSpec);
        ArithmeticPropertyLiteral hwcProperty = DSMLModelElementFactory.createAnnotationArithPropLit(hwcs, ecuSpec);
        Sum swSetSum = DSMLModelElementFactory.createSum(swcs.getCastedSet(IModelElement.class), predicate, swcProperty);
        ArithmeticLiteral percentage = DSMLModelElementFactory.createArithmeticLiteral(new BigDecimal(String.valueOf(value)));
        Mul mul = DSMLModelElementFactory.createMul(hwcProperty, percentage);
        LessEqual compOp = DSMLModelElementFactory.createLessEqual(swSetSum, mul);
        return DSMLModelElementFactory.createForAll(hwcs.getCastedSet(IModelElement.class), compOp, true);
    }

    public static IBooleanExpression createSafetyPatternExpression(DSE dse, ExecutionUnit executionUnit, SuperSet<ComponentToTaskAllocationEntry> ca2taSet) {
        ModelElementLiteral task2;
        SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
        Set<Task> tasks = DSMLModelElementFactory.createSet(superSetMap.get(Task.class), superSetMap.get(Task.class).getEntries(), Task.class);
        Set<ExecutionUnit> hwcs = DSMLModelElementFactory.createSet(superSetMap.get(ExecutionUnit.class), executionUnit, ExecutionUnit.class);
        HashMap<Integer, Integer> taskSils = new HashMap<Integer, Integer>();
        for (ModelElementLiteral task2 : tasks.getEntries()) {
            Optional alloc = LambdaUtils.getFirst((Collection)LambdaUtils.filter(ca2taSet.getEntries(), arg_0 -> PatternFactoryUtils.lambda$1((Task)task2, arg_0)));
            Assert.isTrue((boolean)alloc.isPresent(), (String)("Could not determine the coomponent(s) mapped to the task " + task2.getName()));
            Integer sil = ((ComponentToTaskAllocationEntry)alloc.get()).getComponents().stream().mapToInt(c -> ((Enumerator)AnnotationUtils.getAnnotationValue((IModelElement)c, SafetyIntegrityLevel.class, Enumerator.class)).getValue()).max().getAsInt();
            taskSils.put(task2.getId(), sil);
        }
        task2 = DSMLModelElementFactory.createModelElementLiteral(tasks);
        ModelElementLiteral hwc = DSMLModelElementFactory.createModelElementLiteral(hwcs);
        Allocation le = DSMLModelElementFactory.createAllocation(task2, hwc);
        Function silGetter = t -> {
            Integer tID = t.getId();
            return (Integer)taskSils.get(tID);
        };
        ArithmeticPropertyLiteral swcProperty = DSMLModelElementFactory.createArithmeticPropertyLiteral(tasks, silGetter, "SafetyIntegrityLevel: Tasks");
        ArithmeticPropertyLiteral<ExecutionUnit, Integer> hwcProperty = DSMLModelElementFactory.createEnumAnnotationArithPropLit(hwcs, SafetyIntegrityLevel.class);
        LessEqual compOp = DSMLModelElementFactory.createLessEqual(swcProperty, hwcProperty);
        Implies impl = DSMLModelElementFactory.createImplies(le, compOp);
        ForAll swSetForall = DSMLModelElementFactory.createForAll(tasks.getCastedSet(IModelElement.class), impl, true);
        ForAll hwSetForAll = DSMLModelElementFactory.createForAll(hwcs.getCastedSet(IModelElement.class), swSetForall, true);
        return hwSetForAll;
    }

    public static IBooleanExpression createAllocationPatternExpression(DSE dse, boolean isAllocation, List<Task> taskList, List<ExecutionUnit> ecuList) {
        SuperSetMap dseSets = dse.getCurrentStep().getSuperSetMap();
        ILocationExpression locationConstraint = null;
        locationConstraint = isAllocation ? DSMLModelElementFactory.createAllocation(null, null) : DSMLModelElementFactory.createDislocation(null, null);
        SuperSet<Task> tSet = dseSets.get(Task.class);
        Set<IModelElement> leftSet = DSMLModelElementFactory.createSet(tSet, taskList, "Tasks", Task.class).getCastedSet(IModelElement.class);
        locationConstraint.setLeft(DSMLModelElementFactory.createModelElementLiteral(leftSet));
        SuperSet<ExecutionUnit> exUSet = dseSets.get(ExecutionUnit.class);
        Set<IModelElement> rightSet = DSMLModelElementFactory.createSet(exUSet, ecuList, "ExecutionUnits", ExecutionUnit.class).getCastedSet(IModelElement.class);
        locationConstraint.setRight(DSMLModelElementFactory.createModelElementLiteral(rightSet));
        Exists exists = DSMLModelElementFactory.createExists(rightSet, locationConstraint, true);
        ForAll forAll = DSMLModelElementFactory.createForAll(leftSet, exists, true);
        return forAll;
    }

    public static IExpression createFunctionCouplingPatternExpression(DSE dse, boolean isCoupling, Collection<Task> selectedTasks) {
        IQuantifierExpression expression = null;
        if (isCoupling) {
            Exists hwSetExists;
            SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
            Set<Task> swcs = DSMLModelElementFactory.createSet(superSetMap.get(Task.class), "Tasks", Task.class);
            swcs.getEntries().addAll(selectedTasks);
            Set<ExecutionUnit> hwcs = DSMLModelElementFactory.createSet(superSetMap.get(ExecutionUnit.class), superSetMap.get(ExecutionUnit.class).getEntries(), "HardwareComponents", ExecutionUnit.class);
            ModelElementLiteral swcLiteral = DSMLModelElementFactory.createModelElementLiteral(swcs);
            ModelElementLiteral hwcLiteral = DSMLModelElementFactory.createModelElementLiteral(hwcs);
            Allocation locationConstraint = DSMLModelElementFactory.createAllocation(swcLiteral, hwcLiteral);
            ForAll swSetForall = DSMLModelElementFactory.createForAll(swcs.getCastedSet(IModelElement.class), locationConstraint, true);
            expression = hwSetExists = DSMLModelElementFactory.createExists(hwcs.getCastedSet(IModelElement.class), swSetForall, true);
        } else {
            SuperSetMap superSetMap = dse.getCurrentStep().getSuperSetMap();
            Set<Task> swcs = DSMLModelElementFactory.createSet(superSetMap.get(Task.class), "aTasks", Task.class);
            Set<Task> swcs2 = DSMLModelElementFactory.createSet(superSetMap.get(Task.class), "bTasks", Task.class);
            swcs.getEntries().addAll(selectedTasks);
            swcs2.getEntries().addAll(selectedTasks);
            Set<ExecutionUnit> hwcs = DSMLModelElementFactory.createSet(superSetMap.get(ExecutionUnit.class), superSetMap.get(ExecutionUnit.class).getEntries(), "cHardwareComponents", ExecutionUnit.class);
            Set<ExecutionUnit> hwcs2 = DSMLModelElementFactory.createSet(superSetMap.get(ExecutionUnit.class), superSetMap.get(ExecutionUnit.class).getEntries(), "dHardwareComponents", ExecutionUnit.class);
            Allocation locationConstraint = DSMLModelElementFactory.createAllocation(DSMLModelElementFactory.createModelElementLiteral(swcs), DSMLModelElementFactory.createModelElementLiteral(hwcs));
            Allocation locationConstraint2 = DSMLModelElementFactory.createAllocation(DSMLModelElementFactory.createModelElementLiteral(swcs2), DSMLModelElementFactory.createModelElementLiteral(hwcs2));
            And premise = DSMLModelElementFactory.createAnd(locationConstraint, locationConstraint2);
            NotEqual distinctECUs = DSMLModelElementFactory.createNotEqual(DSMLModelElementFactory.createModelElementLiteral(hwcs), DSMLModelElementFactory.createModelElementLiteral(hwcs2));
            Equal sameTask = DSMLModelElementFactory.createEquals(DSMLModelElementFactory.createModelElementLiteral(swcs), DSMLModelElementFactory.createModelElementLiteral(swcs2));
            Or conclusion = DSMLModelElementFactory.createOr(distinctECUs, sameTask);
            Implies implication = DSMLModelElementFactory.createImplies(premise, conclusion);
            ForAll swSetForall2 = DSMLModelElementFactory.createForAll(swcs2.getCastedSet(IModelElement.class), implication, true);
            ForAll swSetForall = DSMLModelElementFactory.createForAll(swcs.getCastedSet(IModelElement.class), swSetForall2, true);
            ForAll hwSetForall2 = DSMLModelElementFactory.createForAll(hwcs2.getCastedSet(IModelElement.class), swSetForall, true);
            ForAll hwSetForall = DSMLModelElementFactory.createForAll(hwcs.getCastedSet(IModelElement.class), hwSetForall2, true);
            expression = hwSetForall;
        }
        return expression;
    }

    public static String calcPatternName(List<? extends INamedElement> selectedElements, String separator) {
        Object constraintNamePart = " ";
        if (selectedElements != null) {
            constraintNamePart = selectedElements.size() <= 1 ? "" : "{";
            if (((String)(constraintNamePart = (String)constraintNamePart + selectedElements.stream().map(e -> e.getName() + separator).collect(Collectors.joining()))).length() > separator.length()) {
                constraintNamePart = ((String)constraintNamePart).substring(0, ((String)constraintNamePart).length() - separator.length());
            }
            if (selectedElements.size() > 1) {
                constraintNamePart = (String)constraintNamePart + "}";
            }
            if (((String)constraintNamePart).length() > MAX_ALLOC_SIZE_PER_SIDE) {
                constraintNamePart = ((String)constraintNamePart).substring(0, MAX_ALLOC_SIZE_PER_SIDE);
                if (selectedElements.size() > 1) {
                    constraintNamePart = (String)constraintNamePart + "...; ...}";
                }
            }
        }
        return constraintNamePart;
    }

    private static /* synthetic */ boolean lambda$1(Task task, ComponentToTaskAllocationEntry e) {
        return e.getTargetElement() == task;
    }
}

