/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.rcp.application.advisors;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.exploration.service.IDSEBackend;
import org.fortiss.af3.exploration.service.IDSEBackendService;
import org.fortiss.af3.exploration.smt.backend.Z3Backend;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEUIPatternExtensionService;
import org.fortiss.af3.project.AF3Project;
import org.fortiss.af3.rcp.application.AF3ApplicationActivator;
import org.fortiss.af3.rcp.application.advisors.ApplicationWorkbenchWindowAdvisor;
import org.fortiss.af3.timing.ITimingSpecificationService;
import org.fortiss.tooling.base.ToolingBase;
import org.fortiss.tooling.kernel.ToolingKernel;
import org.fortiss.tooling.kernel.service.ICommandLineInterfaceService;
import org.fortiss.tooling.kernel.ui.ToolingKernelUI;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private long timestampInitialization;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void preStartup() {
        IDE.registerAdapters();
        AF3ExplorationUIActivator.registerWorkbenchListener();
    }

    public void postStartup() {
        ToolingKernel.start();
        ToolingBase.start();
        ToolingKernelUI.start();
        AF3Project.start();
        IAllocationService.getInstance().startService();
        ITimingSpecificationService.getInstance().startService();
        IDSEBackendService.getInstance().startService();
        IDSEUIPatternExtensionService.getInstance().startService();
        ICommandLineInterfaceService.getInstance().executeHandlers();
        LoggingUtils.info((Plugin)AF3ApplicationActivator.getDefault(), (String)("Startup time: " + (System.currentTimeMillis() - this.timestampInitialization) + "ms."));
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        this.timestampInitialization = System.currentTimeMillis();
        configurer.setSaveAndRestore(true);
        ToolingKernel.initialize();
        ToolingBase.initialize();
        ToolingKernelUI.initialize();
        AF3Project.initialize();
        IAllocationService.getInstance().initializeService();
        IDSEBackendService dbs = IDSEBackendService.getInstance();
        dbs.initializeService();
        dbs.registerDSEBackend((IDSEBackend)new Z3Backend());
        IDSEUIPatternExtensionService.getInstance().initializeService();
    }

    public String getInitialWindowPerspectiveId() {
        return "org.fortiss.af3.project.ui.perspective";
    }
}

