/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.rcp.application.handler;

import java.io.File;
import java.util.List;
import org.conqat.ide.commons.ui.logging.LoggingUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.about.AboutUtils;
import org.fortiss.af3.expression.examples.ConfiguredExpressionExample;
import org.fortiss.af3.mode.AF3ModeActivator;
import org.fortiss.af3.mode.ui.examples.SimpleTrafficLightsModesExample;
import org.fortiss.af3.project.example.IExample;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.ui.utils.ExportProjectUtils;
import org.fortiss.af3.project.ui.utils.ImportProjectUtils;
import org.fortiss.af3.rcp.application.AF3ApplicationActivator;
import org.fortiss.af3.rcp.application.example.SimpleTrafficLightsCodeGenerationExample;
import org.fortiss.af3.rcp.application.utils.ApplicationUtils;
import org.fortiss.tooling.kernel.extension.data.ModelStorageError;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EMFResourceUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ApplicationCommandHandler {
    private static boolean createAndSaveProject(String projectName, IExample builder) {
        return ApplicationUtils.createAndSaveProject(projectName, "af3_23", builder);
    }

    private static synchronized void loadExistingModel(String pluginID, String relativePath, String projectName) {
        URI fileURI = URI.createPlatformPluginURI((String)(pluginID + File.separator + relativePath), (boolean)true);
        try {
            ImportProjectUtils.importUISelectedFile((URI)fileURI);
        }
        catch (Exception e) {
            LoggingUtils.logAndShowError((Plugin)AF3ApplicationActivator.getDefault(), (String)"The project cannot be loaded.", (Throwable)e);
        }
    }

    public static final class AF3ExitCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            PlatformUI.getWorkbench().close();
            return null;
        }
    }

    public static final class ExportAF3ProjectCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            String exportFileLocation;
            FileProject selectedProject = ExportProjectUtils.getSelectedFileProject();
            if (selectedProject != null && (exportFileLocation = ExportProjectUtils.fileSelectionDialog((String)selectedProject.getName())) != null) {
                ExportProjectUtils.exportProject((FileProject)((FileProject)EcoreUtils.copy((EObject)selectedProject)), (URI)selectedProject.eResource().getURI(), (URI)URI.createFileURI((String)exportFileLocation));
            }
            return null;
        }
    }

    public static final class ImportAF3ProjectCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            String importFile = ImportProjectUtils.fileSelectionDialog();
            if (importFile != null) {
                ImportProjectUtils.importUISelectedFile((URI)URI.createFileURI((String)importFile));
            }
            return null;
        }
    }

    public static final class LoadACCExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ApplicationActivator.PLUGIN_ID, "test-data/ACC.af3_23", "ACC");
            return null;
        }
    }

    public static final class LoadACCRefinementExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ApplicationActivator.PLUGIN_ID, "test-data/ACCRefinement.af3_23", "ACCRefinementExample");
            return null;
        }
    }

    public static final class LoadECarExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ApplicationActivator.PLUGIN_ID, "test-data/eCar.af3_23", "eCar");
            return null;
        }
    }

    public static final class LoadEmergencyStopExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ApplicationActivator.PLUGIN_ID, "test-data/Emergency-Stop-Module.af3_23", "Emergency-Stop-Module");
            return null;
        }
    }

    public static final class LoadEmergencyStopWeaklyCausalExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ApplicationActivator.PLUGIN_ID, "test-data/Emergency-Stop-Module-Weakly-Causal.af3_23", "Emergency-Stop-Module-Weakly-Causal");
            return null;
        }
    }

    public static final class LoadMotorManagementExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ModeActivator.PLUGIN_ID, "test-data/MotorManagement.af3_23", "MotorManagement");
            return null;
        }
    }

    public static final class LoadOperatorPanelExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ApplicationActivator.PLUGIN_ID, "test-data/operator_panel_tutorial.af3_23", "OperatorPanel");
            return null;
        }
    }

    public static final class LoadSimpleTrafficLightsCodeGenerationExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationUtils.switchToAF3Perspective();
            ApplicationCommandHandler.createAndSaveProject("SimpleTrafficLightsCodeGenerationExample", (IExample)SimpleTrafficLightsCodeGenerationExample.INSTANCE);
            return null;
        }
    }

    public static final class LoadSimpleTrafficLightsExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ApplicationActivator.PLUGIN_ID, "test-data/SimpleTrafficLightsExample.af3_23", "SimpleTrafficLightsExample");
            return null;
        }
    }

    public static final class LoadSimpleTrafficLightsModesExampleCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationUtils.switchToAF3Perspective();
            ApplicationCommandHandler.createAndSaveProject("SimpleTrafficLightsModesExample", (IExample)SimpleTrafficLightsModesExample.INSTANCE);
            return null;
        }
    }

    public static final class LoadSimpleTrafficLights_AF3TourCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationCommandHandler.loadExistingModel(AF3ApplicationActivator.PLUGIN_ID, "test-data/SimpleTrafficLights_AF3Tour.af3_23", "SimpleTrafficLights_AF3Tour");
            return null;
        }
    }

    public static final class NewAF3ProjectCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            ApplicationUtils.switchToAF3Perspective();
            ApplicationCommandHandler.createAndSaveProject("AF3-Project", (IExample)ConfiguredExpressionExample.INSTANCE);
            return null;
        }
    }

    public static final class RefreshWorkspaceCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            EMFResourceUtils.refreshWorkspace();
            return null;
        }
    }

    public static final class ShowErrorLogCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            AboutUtils.openErrorLogBrowser((Shell)Display.getCurrent().getActiveShell());
            return null;
        }
    }

    public static final class ShowModelStorageErrorDialogCommandHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            Status status;
            List errors = IPersistencyService.getInstance().getAllStorageErrors();
            String pid = AF3ApplicationActivator.PLUGIN_ID;
            if (errors.isEmpty()) {
                status = new Status(1, pid, 0, "No model storage errors found!", null);
            } else {
                MultiStatus info = new MultiStatus(pid, 0, "Model storage errors found!", null);
                for (ModelStorageError error : errors) {
                    Object message = error.getMessage();
                    if (error.getCause() != null) {
                        Exception cause = error.getCause();
                        message = (String)message + " (caused by \"" + cause.getClass().getName() + ": " + cause.getMessage() + "\")";
                    }
                    info.add((IStatus)new Status(4, pid, 1, (String)message, null));
                }
                status = info;
            }
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Model Storage Errors", null, (IStatus)status);
            return null;
        }
    }
}

