/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.rcp.application.utils;

import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.project.example.IExample;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.ui.utils.ImportProjectUtils;
import org.fortiss.af3.project.utils.ProjectUtils;
import org.fortiss.af3.rcp.application.AF3ApplicationActivator;
import org.fortiss.tooling.kernel.utils.EMFResourceUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ApplicationUtils {
    public static void switchToAF3Perspective() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = workbench.getPerspectiveRegistry().getPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor pDesc = iPerspectiveDescriptorArray[n2];
            if (pDesc.getLabel().equals("Modeling")) {
                if (workbench.getActiveWorkbenchWindow() == null || workbench.getActiveWorkbenchWindow().getActivePage() == null) break;
                workbench.getActiveWorkbenchWindow().getActivePage().setPerspective(pDesc);
                break;
            }
            ++n2;
        }
        EMFResourceUtils.refreshWorkspace();
    }

    public static boolean createAndSaveProject(String projectName, String suffix, IExample builder) {
        ProjectUtils.ensureEclipseContainerProjectExists();
        URI projectURI = ImportProjectUtils.determineTargetFileLocation((String)projectName);
        if (projectURI != null) {
            projectName = projectURI.lastSegment().replace("." + suffix, "");
            FileProject project = builder.createProject(projectName);
            try {
                ProjectUtils.saveProject((FileProject)project, (URI)projectURI);
                EMFResourceUtils.refreshWorkspace();
            }
            catch (IOException e) {
                LoggingUtils.error((Plugin)AF3ApplicationActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
                LoggingUtils.showError((String)e.getMessage());
            }
        }
        return false;
    }
}

