/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.manufacturing.topology.compositor;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.manufacturing.topology.model.ManufacturingTopology;
import org.fortiss.af3.manufacturing.topology.model.StationInputPort;
import org.fortiss.af3.manufacturing.topology.model.StationOutputPort;
import org.fortiss.af3.manufacturing.topology.model.StationSignal;
import org.fortiss.af3.manufacturing.topology.util.ManufacturingTopologyModelElementFactory;
import org.fortiss.tooling.base.compose.ConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class StationConnectionCompositor
extends ConnectionCompositorBase<IHierarchicElement, EObject, EObject> {
    public boolean canConnect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        return target instanceof StationInputPort && source instanceof StationOutputPort;
    }

    public boolean connect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        ManufacturingTopology manufacturingTopology = (ManufacturingTopology)parent;
        EList<StationSignal> stationSignals = manufacturingTopology.getStationSignals();
        boolean isStationSignalExisiting = stationSignals.stream().anyMatch(s -> s.getSource().equals(source) && s.getTarget().equals(target));
        if (isStationSignalExisiting) {
            return false;
        }
        StationSignal connection = this.createConnection();
        UniqueIDUtils.prepareUniqueID((EObject)connection, (EObject)parent);
        connection.setName(connection.getName() + connection.getId());
        manufacturingTopology.getConnections().add((Object)connection);
        connection.setSource((IConnector)source);
        connection.setTarget((IConnector)target);
        return true;
    }

    protected StationSignal createConnection() {
        return ManufacturingTopologyModelElementFactory.createStationSignal("Transport");
    }

    public boolean canDisconnect(EObject connection) {
        return connection instanceof StationSignal;
    }
}

