/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.manufacturing.topology.util;

import org.fortiss.af3.manufacturing.topology.model.ManufacturingTopology;
import org.fortiss.af3.manufacturing.topology.model.ManufacturingTopologyFactory;
import org.fortiss.af3.manufacturing.topology.model.Station;
import org.fortiss.af3.manufacturing.topology.model.StationInputPort;
import org.fortiss.af3.manufacturing.topology.model.StationOutputPort;
import org.fortiss.af3.manufacturing.topology.model.StationSignal;
import org.fortiss.af3.manufacturing.topology.model.StationTransportInputPort;
import org.fortiss.af3.manufacturing.topology.model.StationTransportOutputPort;
import org.fortiss.af3.manufacturing.topology.model.allocation.AllocationFactory;
import org.fortiss.af3.manufacturing.topology.model.allocation.HardwareToStationAllocationTable;
import org.fortiss.af3.manufacturing.topology.model.allocation.StepToStationAllocationTable;
import org.fortiss.af3.platform.model.IPortSemantics;
import org.fortiss.af3.platform.model.IQueuingPort;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;

public class ManufacturingTopologyModelElementFactory {
    public static Station createStation(String name) {
        Station station = ManufacturingTopologyFactory.eINSTANCE.createStation();
        station.setName(name);
        return station;
    }

    public static StationSignal createStationSignal(String name) {
        StationSignal signal = ManufacturingTopologyFactory.eINSTANCE.createStationSignal();
        signal.setName(name);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)signal);
        return signal;
    }

    public static StationSignal createStationSignal(StationOutputPort stationOutputPort, StationInputPort stationInputPort, String name) {
        StationSignal signal = ManufacturingTopologyModelElementFactory.createStationSignal(name);
        signal.setSource((IConnector)stationOutputPort);
        signal.setTarget((IConnector)stationInputPort);
        return signal;
    }

    public static StationInputPort createStationInputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return ManufacturingTopologyModelElementFactory.createStationTransportInputPort(name);
        }
        return null;
    }

    public static StationOutputPort createStationOutputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return ManufacturingTopologyModelElementFactory.createStationTransportOutputPort(name);
        }
        return null;
    }

    public static StationTransportOutputPort createStationTransportOutputPort(String name) {
        StationTransportOutputPort pOutPort = ManufacturingTopologyFactory.eINSTANCE.createStationTransportOutputPort();
        pOutPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pOutPort);
        return pOutPort;
    }

    public static StationTransportInputPort createStationTransportInputPort(String name) {
        StationTransportInputPort pInPort = ManufacturingTopologyFactory.eINSTANCE.createStationTransportInputPort();
        pInPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pInPort);
        return pInPort;
    }

    public static ManufacturingTopology createManufacturingTopology(String name) {
        ManufacturingTopology manufacturingTopology = ManufacturingTopologyFactory.eINSTANCE.createManufacturingTopology();
        manufacturingTopology.setName(name);
        return manufacturingTopology;
    }

    public static HardwareToStationAllocationTable createHardwareToStationAllocationTable(String name) {
        HardwareToStationAllocationTable h2s = AllocationFactory.eINSTANCE.createHardwareToStationAllocationTable();
        h2s.setName(name);
        return h2s;
    }

    public static StepToStationAllocationTable createStepToStationAllocationTable(String name) {
        StepToStationAllocationTable s2s = AllocationFactory.eINSTANCE.createStepToStationAllocationTable();
        s2s.setName(name);
        return s2s;
    }
}

