/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.simulator;

import java.util.List;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.component.simulator.ExecutableAtomicComponentBase;
import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.language.evaluation.DoubleValue;
import org.fortiss.af3.expression.language.evaluation.IntValue;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.impl.VarStaticImpl;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.operatorpanel.model.InputOperatorPanelItem;
import org.fortiss.af3.operatorpanel.model.OPAreaInput;
import org.fortiss.af3.operatorpanel.model.OPColorDisplay;
import org.fortiss.af3.operatorpanel.model.OPITermInput;
import org.fortiss.af3.operatorpanel.model.OPPushButton;
import org.fortiss.af3.operatorpanel.model.OPReaction;
import org.fortiss.af3.operatorpanel.model.OPTextDisplay;
import org.fortiss.af3.operatorpanel.model.OPTextReaction;
import org.fortiss.af3.operatorpanel.model.OPToggleButton;
import org.fortiss.af3.operatorpanel.model.OperatorPanelItem;
import org.fortiss.af3.operatorpanel.model.OperatorPanelSpecification;
import org.fortiss.af3.operatorpanel.model.OutputOperatorPanelItem;
import org.fortiss.af3.operatorpanel.model.impl.OPAreaInputStaticImpl;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;

public class ExecutableOperatorPanelSpecification
extends ExecutableAtomicComponentBase<OperatorPanelSpecification> {
    public static final Var THIS_VARIABLE = VarStaticImpl.create((String)"_this");

    public ExecutableOperatorPanelSpecification(OperatorPanelSpecification specification) {
        super((IModelElementSpecification)specification);
    }

    public void initialize() {
        super.initialize();
        for (OperatorPanelItem item : ((OperatorPanelSpecification)this.specification).getItems()) {
            OPToggleButton tb;
            if (item instanceof OPToggleButton && (tb = (OPToggleButton)item).isStateType()) {
                this.setCurrentValue(tb, false);
            }
            if (!(item instanceof OPAreaInput)) continue;
            OPAreaInput in = (OPAreaInput)item;
            this.setCurrentValue(in, new Pair((Object)0.5, (Object)0.5));
        }
    }

    protected void doAtomicStep() {
        for (OperatorPanelItem item : ((OperatorPanelSpecification)this.specification).getItems()) {
            if (item instanceof InputOperatorPanelItem) {
                this.handleInputItem((InputOperatorPanelItem)item);
                continue;
            }
            if (!(item instanceof OutputOperatorPanelItem)) continue;
            this.handleOutputItem((OutputOperatorPanelItem)item);
        }
        for (OutputPort port : this.outputPortVariables.keySet()) {
            Term value = this.evaluationContext.getValue((VarBase)this.outputPortVariables.get(port));
            if (value == null) {
                value = NoVal.NOVAL;
            }
            this.setInternalOutputValue(port, value);
        }
    }

    public Object getCurrentValue(OperatorPanelItem item) {
        return this.getInternalValue((EObject)item);
    }

    public void setCurrentValue(InputOperatorPanelItem item, Object value) {
        this.setInternalValue((EObject)item, value);
    }

    public String computeDisplayValue(OPTextReaction reaction) {
        return this.getTermValue((ITerm)reaction.getItemInput()).toString();
    }

    private void handleOutputItem(OutputOperatorPanelItem item) {
        OPTextDisplay td;
        OPReaction reaction = null;
        if (item instanceof OPColorDisplay) {
            reaction = this.handleOPColorDisplay((OPColorDisplay)item);
        } else if (item instanceof OPTextDisplay && (td = (OPTextDisplay)item).getReactions().size() > 0) {
            reaction = (OPReaction)td.getReactions().get(0);
        }
        this.setInternalValue((EObject)item, reaction);
    }

    private void handleInputItem(InputOperatorPanelItem item) {
        List<Action> actions = null;
        if (item instanceof OPPushButton) {
            actions = this.handleOPPushButton((OPPushButton)item);
        } else if (item instanceof OPToggleButton) {
            actions = this.handleOPToggleButton((OPToggleButton)item);
        } else if (item instanceof OPITermInput) {
            actions = this.handleOPITermInput((OPITermInput)item);
        } else if (item instanceof OPAreaInput) {
            actions = this.handleOPAreaInput((OPAreaInput)item);
        }
        if (actions == null) {
            return;
        }
        for (Action action : actions) {
            Term value = this.getTermValue((ITerm)action.getValue());
            this.evaluationContext.setValue((VarBase)action.getVariable(), value);
        }
    }

    private List<Action> handleOPAreaInput(OPAreaInput item) {
        Pair itemVal = (Pair)this.getInternalValue((EObject)item);
        DoubleValue xTermValue = NoVal.NOVAL;
        DoubleValue yTermValue = NoVal.NOVAL;
        if (itemVal != null) {
            if (item.getType() instanceof TBool) {
                xTermValue = this.getOPAreaBool((Double)itemVal.getFirst());
                yTermValue = this.getOPAreaBool((Double)itemVal.getSecond());
            } else if (item.getType() instanceof TInt) {
                xTermValue = this.getOPAreaInt((Double)itemVal.getFirst());
                yTermValue = this.getOPAreaInt((Double)itemVal.getSecond());
            } else if (item.getType() instanceof TDouble) {
                xTermValue = new DoubleValue((Double)itemVal.getFirst());
                yTermValue = new DoubleValue((Double)itemVal.getSecond());
            }
        }
        this.evaluationContext.setValue((VarBase)OPAreaInputStaticImpl.THIS_X_VARIABLE, (Term)xTermValue);
        this.evaluationContext.setValue((VarBase)OPAreaInputStaticImpl.THIS_Y_VARIABLE, (Term)yTermValue);
        return item.getOutput();
    }

    private Term<? extends ITerm> getOPAreaBool(Double val) {
        if (val < 0.33) {
            return BoolValue.FALSE;
        }
        if (val > 0.66) {
            return BoolValue.TRUE;
        }
        return NoVal.NOVAL;
    }

    private Term<? extends ITerm> getOPAreaInt(Double val) {
        return new IntValue(Integer.valueOf((int)(val * 200.0 - 100.0)));
    }

    private List<Action> handleOPITermInput(OPITermInput item) {
        String itemVal = (String)this.getInternalValue((EObject)item);
        ITerm iTerm = this.compileToITerm(itemVal);
        Term term = this.getTermValue(iTerm);
        this.evaluationContext.setValue((VarBase)THIS_VARIABLE, term);
        return item.getOutput();
    }

    private List<Action> handleOPPushButton(OPPushButton item) {
        Object buttonState = this.getInternalValue((EObject)item);
        if (buttonState instanceof Boolean && ((Boolean)buttonState).booleanValue()) {
            this.setInternalValue((EObject)item, false);
            return item.getOnSelect();
        }
        return null;
    }

    private List<Action> handleOPToggleButton(OPToggleButton item) {
        Object buttonSelectionState = this.getInternalValue((EObject)item);
        if (buttonSelectionState instanceof Boolean) {
            if (!item.isStateType()) {
                this.setInternalValue((EObject)item, null);
            }
            if (((Boolean)buttonSelectionState).booleanValue()) {
                return item.getOnSelect();
            }
            return item.getOnDeselect();
        }
        return null;
    }

    private OPReaction handleOPColorDisplay(OPColorDisplay item) {
        for (OPReaction reaction : item.getReactions()) {
            Term result;
            Guard guard = reaction.getGuard();
            if (guard == null || !((result = this.getTermValue((ITerm)guard.getExpression())) instanceof BoolValue) || !((BoolValue)result).toJavaValue().booleanValue()) continue;
            return reaction;
        }
        return null;
    }
}

