/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.viewpanel.utils;

import java.util.HashSet;
import java.util.Set;
import org.fortiss.af3.operatorpanel.viewpanel.model.OP3DDisplay;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.CameraDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.CompositeDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.DisplayNodeBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.LightDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.ObjectDisplayNode;
import org.fortiss.tooling.graphicsGL.model.scene.Object3D;

public class DisplayNodeUtils {
    public static Set<ObjectDisplayNode> getObjectDisplayNodes(DisplayNodeBase node) {
        HashSet<ObjectDisplayNode> result = new HashSet<ObjectDisplayNode>();
        DisplayNodeUtils.findDisplayNodesByClass(node, result, ObjectDisplayNode.class);
        return result;
    }

    public static Set<CameraDisplayNode> getCameraDisplayNodes(DisplayNodeBase node) {
        HashSet<CameraDisplayNode> result = new HashSet<CameraDisplayNode>();
        DisplayNodeUtils.findDisplayNodesByClass(node, result, CameraDisplayNode.class);
        return result;
    }

    public static Set<LightDisplayNode> getLightDisplayNodes(DisplayNodeBase node) {
        HashSet<LightDisplayNode> result = new HashSet<LightDisplayNode>();
        DisplayNodeUtils.findDisplayNodesByClass(node, result, LightDisplayNode.class);
        return result;
    }

    private static <T extends DisplayNodeBase> void findDisplayNodesByClass(DisplayNodeBase node, Set<T> result, Class<T> clazz) {
        if (clazz.isInstance(node)) {
            result.add(node);
        }
        if (node instanceof CompositeDisplayNode) {
            CompositeDisplayNode cdn = (CompositeDisplayNode)node;
            for (DisplayNodeBase d : cdn.getSubNodes()) {
                DisplayNodeUtils.findDisplayNodesByClass(d, result, clazz);
            }
        }
    }

    public static Object3D find3DObjectByName(OP3DDisplay display, String name) {
        for (Object3D o : display.getLoadedObjects()) {
            if (!name.equals(o.getName())) continue;
            return o;
        }
        return null;
    }
}

