/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.viewpanel.utils;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.CameraDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.CompositeDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.DisplayNodeBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.LightDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.Node3DFactory;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.ObjectDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.RotationDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.ScalingDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.TransformDisplayNodeBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.TranslationDisplayNode;
import org.fortiss.tooling.graphicsGL.model.scene.Camera3D;
import org.fortiss.tooling.graphicsGL.model.scene.Light3D;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class NodeModelElementFactory {
    public static CompositeDisplayNode compositeDisplayNode(String name, String comment) {
        CompositeDisplayNode n = Node3DFactory.eINSTANCE.createCompositeDisplayNode();
        NodeModelElementFactory.setNameAndComment(n, name, comment);
        return n;
    }

    public static ObjectDisplayNode objectDisplayNode(String name, String comment) {
        ObjectDisplayNode n = Node3DFactory.eINSTANCE.createObjectDisplayNode();
        NodeModelElementFactory.setNameAndComment(n, name, comment);
        n.setModel("");
        return n;
    }

    public static CameraDisplayNode cameraDisplayNode(String name, String comment, Camera3D camera) {
        CameraDisplayNode n = Node3DFactory.eINSTANCE.createCameraDisplayNode();
        NodeModelElementFactory.setNameAndComment(n, name, comment);
        n.setCamera((Camera3D)EcoreUtils.copy((EObject)camera));
        return n;
    }

    public static LightDisplayNode lightDisplayNode(String name, String comment, Light3D light) {
        LightDisplayNode n = Node3DFactory.eINSTANCE.createLightDisplayNode();
        NodeModelElementFactory.setNameAndComment(n, name, comment);
        n.setLight((Light3D)EcoreUtils.copy((EObject)light));
        return n;
    }

    private static void setNameAndComment(DisplayNodeBase n, String name, String comment) {
        n.setName(name);
        n.setComment(comment);
    }

    public static RotationDisplayNode rotation(String name, String comment, IExpressionTerm angle, IExpressionTerm rx, IExpressionTerm ry, IExpressionTerm rz) {
        RotationDisplayNode rot = Node3DFactory.eINSTANCE.createRotationDisplayNode();
        NodeModelElementFactory.setNameAndComment(rot, name, comment);
        rot.setAngle((IExpressionTerm)EcoreUtils.copy((EObject)angle));
        NodeModelElementFactory.setXYZ(rx, ry, rz, rot);
        return rot;
    }

    public static TranslationDisplayNode translation(String name, String comment, IExpressionTerm dx, IExpressionTerm dy, IExpressionTerm dz) {
        TranslationDisplayNode trans = Node3DFactory.eINSTANCE.createTranslationDisplayNode();
        NodeModelElementFactory.setNameAndComment(trans, name, comment);
        NodeModelElementFactory.setXYZ(dx, dy, dz, trans);
        return trans;
    }

    public static ScalingDisplayNode scaling(String name, String comment, IExpressionTerm sx, IExpressionTerm sy, IExpressionTerm sz) {
        ScalingDisplayNode scale = Node3DFactory.eINSTANCE.createScalingDisplayNode();
        NodeModelElementFactory.setNameAndComment(scale, name, comment);
        NodeModelElementFactory.setXYZ(sx, sy, sz, scale);
        return scale;
    }

    private static void setXYZ(IExpressionTerm x, IExpressionTerm y, IExpressionTerm z, TransformDisplayNodeBase t) {
        t.setX((IExpressionTerm)EcoreUtils.copy((EObject)x));
        t.setY((IExpressionTerm)EcoreUtils.copy((EObject)y));
        t.setZ((IExpressionTerm)EcoreUtils.copy((EObject)z));
    }
}

