/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.analysis;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.ext.variability.model.OptionalVariationPointSpecification;
import org.fortiss.tooling.ext.variability.service.IDependingElementProviderService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.analysis.EMFProductLineModelTranslation;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.presence.AndPC;
import org.fortiss.variability.model.presence.PresenceCondition;
import org.fortiss.variability.model.presence.PresenceConditionTerm;

public class OptimizedProductLineTranslation
extends EMFProductLineModelTranslation {
    protected PresenceConditionTerm getLocalPresenceCondition(EObject model) {
        if (model instanceof IModelElement) {
            EList specifications = ((IModelElement)model).getSpecifications();
            OptionalVariationPointSpecification varSpec = (OptionalVariationPointSpecification)EcoreUtils.pickFirstInstanceOf(OptionalVariationPointSpecification.class, (List)specifications);
            if (varSpec == null) {
                return null;
            }
            PresenceCondition presenceCondition = varSpec.getPresenceCondition();
            if (presenceCondition == null) {
                return null;
            }
            return presenceCondition.resolveToFeatureLiterals();
        }
        return null;
    }

    protected void collectEObject(EObject eo, EClass cls, PresenceConditionTerm pc) {
        this.class2TranslatedEObjects.add((Object)cls, (Object)eo);
        this.collectPresenceCondition(eo, pc);
        List<EObject> dependingElements = IDependingElementProviderService.getInstance().getDependingElements(eo);
        for (EObject depObj : dependingElements) {
            Object depObjPC = this.getLocalPresenceCondition(depObj);
            depObjPC = depObjPC != null ? VariabilityModelElementFactory.createAndPC((PresenceConditionTerm)((PresenceConditionTerm)EcoreUtil.copy((EObject)depObjPC)), (PresenceConditionTerm)((PresenceConditionTerm)EcoreUtil.copy((EObject)pc)), (String)"") : pc;
            this.collectEObject(depObj, this.getTranslatedClass(depObj.eClass()), (PresenceConditionTerm)depObjPC);
        }
    }

    private PresenceConditionTerm collectPresenceCondition(EObject eObject, PresenceConditionTerm pc) {
        PresenceConditionTerm oldPC = (PresenceConditionTerm)this.object2presenceCondition.get(eObject);
        if (oldPC != null) {
            if (pc != null) {
                AndPC newPC = VariabilityModelElementFactory.createAndPC((PresenceConditionTerm)((PresenceConditionTerm)EcoreUtil.copy((EObject)oldPC)), (PresenceConditionTerm)((PresenceConditionTerm)EcoreUtil.copy((EObject)pc)), (String)"");
                this.object2presenceCondition.put(eObject, newPC);
                return newPC;
            }
            this.object2presenceCondition.put(eObject, oldPC);
            return oldPC;
        }
        this.object2presenceCondition.put(eObject, pc);
        return pc;
    }
}

