/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.constraint;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.base.ConstraintViolationBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.model.presence.BinaryOperatorPC;
import org.fortiss.variability.model.presence.DefaultPC;
import org.fortiss.variability.model.presence.LiteralPC;
import org.fortiss.variability.model.presence.PresenceCondition;
import org.fortiss.variability.model.presence.UnaryOperatorPC;

public class PresenceConditionChecker
extends ConstraintCheckerBase<PresenceCondition> {
    public List<? extends IConstraintViolation<? extends EObject>> apply(PresenceCondition pc) {
        BinaryOperatorPC binOp;
        LiteralPC literal;
        INamedElement modelElement = (INamedElement)EcoreUtils.getFirstParentWithType((EObject)pc, INamedElement.class);
        String modelElementName = modelElement.getName();
        String name = "this element";
        if (modelElementName != null && !modelElementName.isEmpty()) {
            name = modelElementName;
        }
        if (pc instanceof DefaultPC) {
            String msg = "DEFAULT presence conditions are not supported in this tool.";
            return Arrays.asList(new ConstraintViolationBase((EObject)modelElement, IConstraintViolation.ESeverity.ERROR, msg));
        }
        if (pc instanceof LiteralPC && (literal = (LiteralPC)pc).getLiteralReference() == null) {
            String msg = "The presence condition of " + name + " references the feature " + literal.getStringRepresentation() + " which does not exist.";
            return Arrays.asList(new ConstraintViolationBase((EObject)modelElement, IConstraintViolation.ESeverity.ERROR, msg));
        }
        boolean incorrect = false;
        if (pc instanceof BinaryOperatorPC && ((binOp = (BinaryOperatorPC)pc).getOperand1() == null || binOp.getOperand2() == null)) {
            incorrect = true;
        }
        if (pc instanceof UnaryOperatorPC && ((UnaryOperatorPC)pc).getOperand() == null) {
            incorrect = true;
        }
        if (incorrect) {
            String msg = "The presence condition of " + name + " is incorrectly fomulated.";
            return Arrays.asList(new ConstraintViolationBase((EObject)modelElement, IConstraintViolation.ESeverity.ERROR, msg));
        }
        return super.apply((EObject)pc);
    }
}

